/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging;

import ij.process.ByteProcessor;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.Filter;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.trakem2.transform.TransformMesh;

public final class Blending {
    public static final Bureaucrat blend(final List<Layer> layers, final boolean respect_current_mask, final Filter<Patch> filter) {
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Blending layer-wise"){

            @Override
            public void exec() {
                Blending.blendLayerWise(layers, respect_current_mask, filter);
            }
        }, layers.get(0).getProject());
    }

    public static final void blendLayerWise(List<Layer> layers, boolean respect_current_mask, Filter<Patch> filter) {
        for (Layer layer : layers) {
            ArrayList<Patch> patches = layer.getAll(Patch.class);
            HashSet<Patch> s = new HashSet<Patch>();
            if (null == filter) {
                s.addAll(patches);
            } else {
                for (Patch p : patches) {
                    if (!filter.accept(p)) continue;
                    s.add(p);
                }
            }
            Blending.blendPatches(s, respect_current_mask);
        }
    }

    public static final Bureaucrat blend(final Set<Patch> patches, final boolean respect_current_mask) {
        if (null == patches || patches.size() < 2) {
            return null;
        }
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Blending images"){

            @Override
            public void exec() {
                Blending.blendPatches(patches, respect_current_mask);
            }
        }, patches.iterator().next().getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void blendPatches(final Set<Patch> patches, final boolean respect_current_mask) {
        ExecutorService exe = null;
        try {
            if (null == patches || patches.size() < 2) {
                return;
            }
            Layer layer = patches.iterator().next().getLayer();
            for (Patch patch : patches) {
                if (null != patch.getCoordinateTransform()) {
                    Utils.log("CANNOT blend: at least one image has a coordinate transform.\nBlending of coordinate-transformed images will be enabled in the near future.");
                    return;
                }
                if (patch.getLayer() == layer) continue;
                Utils.log("CANNOT blend: all images must belong to the same layer!\n  Otherwise the overlap cannot be computed.");
                return;
            }
            final HashMap<Patch, TransformMesh> meshes = new HashMap<Patch, TransformMesh>();
            for (Patch p3 : patches) {
                meshes.put(p3, null == p3.getCoordinateTransform() ? null : new TransformMesh((CoordinateTransform)p3.getCoordinateTransform(), p3.getMeshResolution(), (double)p3.getOWidth(), (double)p3.getOHeight()));
            }
            exe = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            List<Future<?>> list = Collections.synchronizedList(new ArrayList());
            final List<Future<?>> futures2 = Collections.synchronizedList(new ArrayList());
            final HashMap<Patch, Integer> indices = new HashMap<Patch, Integer>();
            int i = 0;
            for (Displayable d : layer.getDisplayables()) {
                if (d.getClass() == Patch.class && patches.contains((Patch)d)) {
                    indices.put((Patch)d, i);
                }
                ++i;
            }
            for (final Patch p4 : patches) {
                if (Thread.currentThread().isInterrupted()) break;
                list.add(exe.submit(new Runnable(){

                    @Override
                    public void run() {
                        int pLayerIndex = (Integer)indices.get(p4);
                        HashSet<Patch> overlapping = new HashSet<Patch>();
                        for (Patch op : patches) {
                            if ((Integer)indices.get(op) >= pLayerIndex) continue;
                            overlapping.add(op);
                        }
                        if (Blending.setBlendingMask(p4, overlapping, meshes, respect_current_mask)) {
                            futures2.add(p4.updateMipMaps());
                        }
                    }
                }, null));
            }
            Utils.waitIfAlive(list, false);
            Utils.waitIfAlive(futures2, false);
        }
        catch (Exception e) {
            IJError.print(e);
        }
        finally {
            if (null != exe) {
                exe.shutdown();
            }
            Display.repaint();
        }
    }

    private static boolean setBlendingMask(Patch p, Set<Patch> overlapping, Map<Patch, TransformMesh> meshes, boolean respect_current_mask) {
        Utils.log2("Blending " + p);
        if (overlapping.contains(p)) {
            overlapping = new HashSet<Patch>(overlapping);
            overlapping.remove(p);
        }
        AffineTransform at = p.getAffineTransform();
        TransformMesh mesh = meshes.get(p);
        ByteProcessor mask = null;
        if (respect_current_mask) {
            mask = p.getAlphaMask();
        }
        if (null == mask) {
            mask = new ByteProcessor(p.getOWidth(), p.getOHeight());
            mask.setValue(255.0);
            mask.fill();
        }
        byte[] pix = (byte[])mask.getPixels();
        Point2D.Double po = new Point2D.Double();
        double[] fo = new double[2];
        int p_o_width = p.getOWidth();
        int p_o_height = p.getOHeight();
        int next = 0;
        double[] weights = new double[overlapping.size() + 1];
        int masked = 0;
        for (int y = 0; y < p_o_height; ++y) {
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            for (int x = 0; x < p_o_width; ++x) {
                int f;
                if (null != mesh) {
                    fo[0] = x;
                    fo[1] = y;
                    mesh.applyInPlace(fo);
                    po.x = fo[0];
                    po.y = fo[1];
                } else {
                    po.x = x;
                    po.y = y;
                }
                at.transform(po, po);
                fo[0] = po.x;
                fo[1] = po.y;
                if (0 == x && 0 == y) {
                    Utils.log2("point 0,0 goes to " + fo[0] + ", " + fo[1]);
                }
                next = 0;
                for (Patch other : overlapping) {
                    double weight = Blending.intersects(fo, other, meshes.get(other));
                    if (!(weight > 0.0)) continue;
                    weights[next++] = weight;
                }
                int i = y * p_o_width + x;
                if (respect_current_mask) {
                    if (next <= 0 || pix[i] == 0) continue;
                    weights[next++] = Blending.computeWeight(x, y, p_o_width, p_o_height);
                    double sum = 0.0;
                    for (f = 0; f < next; ++f) {
                        sum += weights[f];
                    }
                    pix[i] = (byte)(255.0 * (weights[next - 1] / sum) * (double)((float)(pix[i] & 0xFF) / 255.0f));
                    ++masked;
                    continue;
                }
                if (next <= 0) continue;
                weights[next++] = Blending.computeWeight(x, y, p_o_width, p_o_height);
                double sum = 0.0;
                for (f = 0; f < next; ++f) {
                    sum += weights[f];
                }
                pix[i] = (byte)(255.0 * (weights[next - 1] / sum));
                ++masked;
            }
        }
        Utils.log2("Masked = " + masked + " for " + p);
        if (masked > 0) {
            p.setAlphaMask(mask);
            return true;
        }
        Utils.log("Nothing to blend in image " + p);
        return false;
    }

    private static final double computeWeight(double x, double y, int width, int height) {
        return Math.min(x, (double)width - x) / (double)(width / 2) * (Math.min(y, (double)height - y) / (double)(height / 2));
    }

    private static double intersects(double[] fo, Patch other, TransformMesh mesh) {
        AffineTransform at = other.getAffineTransform();
        Point2D.Double po = new Point2D.Double(fo[0], fo[1]);
        int o_width = other.getOWidth();
        int o_height = other.getOHeight();
        try {
            at.inverseTransform(po, po);
        }
        catch (NoninvertibleTransformException nite) {
            return -1.0;
        }
        if (null == mesh) {
            if (po.x >= 0.0 && po.x < (double)o_width && po.y >= 0.0 && po.y < (double)o_height) {
                return Blending.computeWeight(po.x, po.y, o_width, o_height);
            }
            return -1.0;
        }
        try {
            fo[0] = po.x;
            fo[1] = po.y;
            mesh.applyInverseInPlace(fo);
            return Blending.computeWeight(fo[0], fo[1], o_width, o_height);
        }
        catch (NoninvertibleModelException nime) {
            return -1.0;
        }
    }
}

