/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.brush.neighborhood;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;

public final class MappingCursor<T>
extends AbstractEuclideanSpace
implements Cursor<T> {
    private final RandomAccess<T> source;
    private final Cursor<?> cursor;
    private final long[] offset;

    public MappingCursor(long[] offset, Cursor<?> cursor, RandomAccess<T> source) {
        super(source.numDimensions());
        this.offset = offset;
        this.cursor = cursor;
        this.source = source;
        this.reset();
    }

    public MappingCursor(MappingCursor<T> mappingCursor) {
        this(mappingCursor.offset, mappingCursor.cursor.copy(), mappingCursor.source.copy());
    }

    public T get() {
        return (T)this.source.get();
    }

    public void fwd() {
        this.cursor.fwd();
        this.source.setPosition((Localizable)this);
    }

    public void jumpFwd(long steps) {
        this.cursor.jumpFwd(steps);
        this.source.setPosition((Localizable)this);
    }

    public T next() {
        this.fwd();
        return this.get();
    }

    public void remove() {
    }

    public void reset() {
        this.cursor.reset();
        this.source.setPosition((Localizable)this);
    }

    public boolean hasNext() {
        return this.cursor.hasNext();
    }

    public float getFloatPosition(int d) {
        return this.cursor.getFloatPosition(d) + (float)this.offset[d];
    }

    public double getDoublePosition(int d) {
        return this.cursor.getDoublePosition(d) + (double)this.offset[d];
    }

    public int getIntPosition(int d) {
        return this.cursor.getIntPosition(d) + (int)this.offset[d];
    }

    public long getLongPosition(int d) {
        return this.cursor.getLongPosition(d) + this.offset[d];
    }

    public void localize(long[] position) {
        this.cursor.localize(position);
        for (int i = 0; i < this.offset.length; ++i) {
            int n = i;
            position[n] = position[n] + this.offset[i];
        }
    }

    public void localize(float[] position) {
        this.cursor.localize(position);
        for (int i = 0; i < this.offset.length; ++i) {
            int n = i;
            position[n] = position[n] + (float)this.offset[i];
        }
    }

    public void localize(double[] position) {
        this.cursor.localize(position);
        for (int i = 0; i < this.offset.length; ++i) {
            int n = i;
            position[n] = position[n] + (double)this.offset[i];
        }
    }

    public void localize(int[] position) {
        this.cursor.localize(position);
        for (int i = 0; i < this.offset.length; ++i) {
            int n = i;
            position[n] = (int)((long)position[n] + this.offset[i]);
        }
    }

    public MappingCursor<T> copy() {
        return new MappingCursor<T>(this);
    }
}

