/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;

public class TokenFunctions
implements Iterable<Token> {
    RSyntaxTextArea textArea;
    public final char[] importChars = new char[]{'i', 'm', 'p', 'o', 'r', 't'};

    public TokenFunctions(RSyntaxTextArea textArea) {
        this.textArea = textArea;
    }

    public static boolean tokenEquals(Token token, char[] text) {
        return token.is(6, text);
    }

    public static boolean isIdentifier(Token token) {
        if (token.getType() != 20) {
            return false;
        }
        char[] tokenText = token.getLexeme().toCharArray();
        if (tokenText == null || !Character.isJavaIdentifierStart(tokenText[0])) {
            return false;
        }
        for (int i = 1; i < tokenText.length; ++i) {
            if (Character.isJavaIdentifierPart(tokenText[i])) continue;
            return false;
        }
        return true;
    }

    public static String getText(Token token) {
        return token.getLexeme();
    }

    public void replaceToken(Token token, String text) {
        this.textArea.replaceRange(text, token.getOffset(), token.getEndOffset());
    }

    @Override
    public Iterator<Token> iterator() {
        return new TokenIterator();
    }

    public static boolean isDot(Token token) {
        return token.is(20, ".");
    }

    public static boolean isClass(Token token) {
        return token.is(6, "class");
    }

    public String getClassName() {
        boolean classSeen = false;
        for (Token token : this) {
            if (TokenFunctions.isClass(token)) {
                classSeen = true;
                continue;
            }
            if (!classSeen || !TokenFunctions.isIdentifier(token)) continue;
            return TokenFunctions.getText(token);
        }
        return null;
    }

    public void setClassName(String className) {
        boolean classSeen = false;
        for (Token token : this) {
            if (TokenFunctions.isClass(token)) {
                classSeen = true;
                continue;
            }
            if (!classSeen || !TokenFunctions.isIdentifier(token)) continue;
            this.replaceToken(token, className);
            return;
        }
    }

    Token skipNonCode(TokenIterator iter, Token current) {
        while (true) {
            switch (current.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 21: {
                    break;
                }
                default: {
                    return current;
                }
            }
            if (!iter.hasNext()) {
                return null;
            }
            current = iter.next();
        }
    }

    int skipToEOL(TokenIterator iter, Token current) {
        int end = this.textArea.getDocument().getLength();
        while (current.getType() != 0 && iter.hasNext()) {
            end = current.getEndOffset();
            current = iter.next();
        }
        return end;
    }

    public List<Import> getImports() {
        ArrayList<Import> result = new ArrayList<Import>();
        TokenIterator iter = new TokenIterator();
        while (iter.hasNext()) {
            int start;
            Token token = iter.next();
            int offset = token.getOffset();
            if (!TokenFunctions.tokenEquals(token = this.skipNonCode(iter, token), this.importChars)) continue;
            do {
                if (iter.hasNext()) continue;
                return result;
            } while (!TokenFunctions.isIdentifier(token = iter.next()));
            int end = start = token.getOffset();
            do {
                if (!iter.hasNext()) {
                    return result;
                }
                token = iter.next();
                if (TokenFunctions.isDot(token) && iter.hasNext()) {
                    token = iter.next();
                }
                end = token.getEndOffset();
            } while (TokenFunctions.isIdentifier(token));
            String identifier = this.getText(start, end);
            if (identifier.endsWith(";")) {
                identifier = identifier.substring(0, identifier.length() - 1);
            }
            end = this.skipToEOL(iter, token);
            result.add(new Import(offset, end, identifier));
        }
        return result;
    }

    public String getText(int start, int end) {
        try {
            return this.textArea.getText(start, end - start);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public boolean emptyLineAt(int offset) {
        return this.getText(offset, offset + 2).equals("\n\n");
    }

    public boolean eolAt(int offset) {
        return this.getText(offset, offset + 1).equals("\n");
    }

    void removeImport(Import imp) {
        int start = imp.startOffset;
        int end = imp.endOffset;
        if (this.emptyLineAt(start - 2) && this.emptyLineAt(end)) {
            end += 2;
        } else if (this.eolAt(end)) {
            ++end;
        }
        this.textArea.replaceRange("", start, end);
    }

    public void removeUnusedImports() {
        Set<String> identifiers = this.getAllUsedIdentifiers();
        List<Import> imports = this.getImports();
        for (int i = imports.size() - 1; i >= 0; --i) {
            Import imp = imports.get(i);
            String clazz = imp.classOrPackage;
            if (clazz.endsWith(".*")) continue;
            int dot = clazz.lastIndexOf(46);
            if (dot >= 0) {
                clazz = clazz.substring(dot + 1);
            }
            if (identifiers.contains(clazz)) continue;
            this.removeImport(imp);
        }
    }

    public void addImport(String className) {
        int endOffset;
        int startOffset;
        List<Import> imports = this.getImports();
        if (imports.size() == 0) {
            TokenIterator iter = new TokenIterator();
            int offset = 0;
            boolean insertLF = false;
            while (iter.hasNext()) {
                Token token = iter.next();
                if (token.getType() != 6) {
                    insertLF = false;
                    continue;
                }
                if (TokenFunctions.getText(token).equals("package")) {
                    this.skipToEOL(iter, token);
                    insertLF = true;
                    continue;
                }
                offset = token.getOffset();
                break;
            }
            this.textArea.insert((insertLF ? "\n" : "") + "import " + className + ";\n\n", offset);
            return;
        }
        String string = "import " + className + ";\n";
        Import imp = new Import(0, 0, className);
        int after = -1;
        for (int i = 0; i < imports.size(); ++i) {
            int cmp = imports.get(i).compareTo(imp);
            if (cmp == 0) {
                return;
            }
            if (cmp >= 0) continue;
            after = i;
        }
        if (after < 0) {
            startOffset = imports.get((int)0).startOffset;
            if (startOffset > 1 && !this.getText(startOffset - 2, startOffset).equals("\n\n")) {
                string = "\n" + string;
            }
        } else {
            startOffset = imports.get((int)after).endOffset;
            string = "\n" + string;
            if (!imp.getPackage().equals(imports.get(after).getPackage())) {
                string = "\n" + string;
            }
        }
        if (after + 1 < imports.size()) {
            endOffset = imports.get((int)(after + 1)).startOffset;
            if (!imp.getPackage().equals(imports.get(after + 1).getPackage())) {
                string = string + "\n";
            }
        } else {
            endOffset = after < 0 ? startOffset : imports.get((int)after).endOffset;
            if (endOffset + 1 < this.textArea.getDocument().getLength() && !this.getText(endOffset, endOffset + 2).equals("\n\n")) {
                string = string + "\n";
            }
        }
        this.textArea.replaceRange(string, startOffset, endOffset);
    }

    public Set<String> getAllUsedIdentifiers() {
        HashSet<String> result = new HashSet<String>();
        boolean classSeen = false;
        String className = null;
        for (Token token : this) {
            if (TokenFunctions.isClass(token)) {
                classSeen = true;
                continue;
            }
            if (classSeen && className == null && TokenFunctions.isIdentifier(token)) {
                className = TokenFunctions.getText(token);
                continue;
            }
            if (!classSeen || !TokenFunctions.isIdentifier(token)) continue;
            result.add(TokenFunctions.getText(token));
        }
        return result;
    }

    public void sortImports() {
        List<Import> imports = this.getImports();
        if (imports.size() == 0) {
            return;
        }
        int start = imports.get((int)0).startOffset;
        while (this.emptyLineAt(start - 2)) {
            --start;
        }
        int end = imports.get((int)(imports.size() - 1)).endOffset;
        while (this.eolAt(end)) {
            ++end;
        }
        Collections.sort(imports, new Comparator<Import>(){

            @Override
            public int compare(Import i1, Import i2) {
                return i1.classOrPackage.compareTo(i2.classOrPackage);
            }

            @Override
            public boolean equals(Object o) {
                return false;
            }
        });
        StringBuffer buffer = new StringBuffer();
        String lastPrefix = null;
        String lastImport = null;
        for (Import imp : imports) {
            if (imp.classOrPackage.equals(lastImport)) continue;
            lastImport = imp.classOrPackage;
            String prefix = imp.getPackage();
            if (!prefix.equals(lastPrefix)) {
                buffer.append("\n");
                lastPrefix = prefix;
            }
            buffer.append(this.getText(imp.startOffset, imp.endOffset));
            buffer.append("\n");
        }
        buffer.append("\n");
        this.textArea.replaceRange(buffer.toString(), start, end);
    }

    public void removeTrailingWhitespace() {
        int end = this.textArea.getDocument().getLength();
        for (int i = end - 1; i >= 0; --i) {
            if (!this.getText(i, i + 1).equals("\r")) continue;
            boolean isCRLF = i < end - 1 && this.getText(i + 1, i + 2).equals("\n");
            this.textArea.replaceRange("\n", i, i + 1 + (isCRLF ? 1 : 0));
            if (!isCRLF) continue;
            --end;
        }
        int realEnd = end;
        if (this.eolAt(end - 1)) {
            while (this.eolAt(end - 2) || this.getText(end - 2, end - 1).equals("\r")) {
                --end;
            }
            if (end < realEnd) {
                this.textArea.replaceRange("", end - 1, realEnd - 1);
            }
        }
        for (int i = this.textArea.getLineCount() - 1; i >= 0; --i) {
            try {
                int start = this.textArea.getLineStartOffset(i);
                if (this.eolAt(end - 1)) {
                    --end;
                }
                if (start == end) continue;
                String line = this.getText(start, end);
                realEnd = end;
                while (end - start - 1 >= 0 && Character.isWhitespace(line.charAt(end - start - 1))) {
                    --end;
                }
                if (end < realEnd) {
                    this.textArea.replaceRange("", end, realEnd);
                }
                end = start;
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class Import
    implements Comparable<Import> {
        int startOffset;
        int endOffset;
        String classOrPackage;

        Import(int start, int end, String text) {
            this.startOffset = start;
            this.endOffset = end;
            this.classOrPackage = text;
        }

        String getPackage() {
            int dot = this.classOrPackage.lastIndexOf(46);
            return dot < 0 ? "" : this.classOrPackage.substring(0, dot);
        }

        public boolean equals(Import imp) {
            return this.classOrPackage.equals(imp.classOrPackage);
        }

        @Override
        public int compareTo(Import imp) {
            return this.classOrPackage.compareTo(imp.classOrPackage);
        }

        public String toString() {
            return "Import(" + this.classOrPackage + "," + this.startOffset + "-" + this.endOffset + ")";
        }
    }

    class TokenIterator
    implements Iterator<Token> {
        int line = -1;
        Token current;
        Token next;

        TokenIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.getNextToken();
            }
            return this.next != null;
        }

        @Override
        public Token next() {
            this.current = this.next;
            this.next = null;
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        void getNextToken() {
            if (this.current != null) {
                this.next = this.current.getNextToken();
                if (this.next != null) {
                    return;
                }
            }
            while (this.next == null) {
                if (++this.line >= TokenFunctions.this.textArea.getLineCount()) {
                    return;
                }
                this.next = TokenFunctions.this.textArea.getTokenListForLine(this.line);
            }
        }
    }
}

