/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.kymograph;

import ij.gui.Line;
import ij.gui.Roi;
import ij.plugin.frame.RoiManager;
import io.scif.services.DatasetIOService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javafx.application.Platform;
import net.imagej.Dataset;
import net.imagej.display.ImageDisplay;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.ui.UIService;
import sc.fiji.filamentdetector.kymograph.KymographParameters;
import sc.fiji.filamentdetector.kymograph.LineGenerator;
import sc.fiji.filamentdetector.model.TrackedFilament;
import sc.fiji.filamentdetector.model.TrackedFilaments;
import sc.fiji.kymographBuilder.KymographFactory;

public class KymographGenerator {
    @Parameter
    private Context context;
    @Parameter
    private UIService ui;
    @Parameter
    private LogService log;
    @Parameter
    private DatasetIOService io;
    private ImageDisplay imageDisplay;
    private TrackedFilaments trackedFilaments;
    private KymographParameters kymographParameters;
    private List<Dataset> kymographs;
    private boolean kymographsHasBeenSaved;

    public KymographGenerator(Context context) {
        context.inject((Object)this);
        this.kymographParameters = new KymographParameters();
        System.setProperty("scijava.log.level:sc.fiji.kymographBuilder.KymographFactory", "none");
        System.setProperty("scijava.log.level:sc.fiji.kymographBuilder.KymographCreator", "none");
    }

    public void build() {
        ArrayList trackedFilamentsToBuild;
        if (this.kymographParameters.isBuildOneRandomKymograph()) {
            trackedFilamentsToBuild = new ArrayList();
            trackedFilamentsToBuild.add(this.getRandomTrackedFilament(this.trackedFilaments));
        } else {
            trackedFilamentsToBuild = this.trackedFilaments;
        }
        this.kymographs = new ArrayList<Dataset>();
        ArrayList<Line> lines = new ArrayList<Line>();
        LineGenerator lineDrawer = new LineGenerator(this.kymographParameters.getLineThickness(), this.kymographParameters.getStartOffsetLength(), this.kymographParameters.getEndOffsetLength());
        String baseFolder = new File(this.getDataset().getSource()).getParent();
        if (this.kymographParameters.isSaveKymographs() && baseFolder == null) {
            this.kymographsHasBeenSaved = false;
            this.log.warn((Object)"Can't get the parent folder of the image. Kymographs won't be saved.");
        } else {
            this.kymographsHasBeenSaved = true;
        }
        try {
            for (TrackedFilament trackedFilament : trackedFilamentsToBuild) {
                lineDrawer.setTrackedFilament(trackedFilament);
                Line line = lineDrawer.build(this.kymographParameters.getLineDrawer());
                if (this.kymographParameters.isSaveKymographLines() && baseFolder != null) {
                    lines.add(line);
                }
                KymographFactory kfactory = new KymographFactory(this.context, this.getDataset(), (Roi)line);
                kfactory.build();
                Dataset dataset = kfactory.getKymograph();
                dataset.setName("Kymograph_" + trackedFilament.getId() + ".tif");
                this.kymographs.add(dataset);
                if (this.kymographParameters.isShowKymographs()) {
                    Platform.runLater(() -> this.ui.show((Object)kymograph));
                }
                if (!this.kymographParameters.isSaveKymographs() || baseFolder == null) continue;
                try {
                    this.io.save(dataset, Paths.get(baseFolder, dataset.getName()).toString());
                }
                catch (IOException e) {
                    this.log.error((Object)("Error while saving the following kymograph : " + dataset));
                    this.log.error((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
        if (this.kymographParameters.isSaveKymographLines() && baseFolder != null) {
            RoiManager rm = RoiManager.getRoiManager();
            rm.runCommand("Deselect");
            if (rm.getRoisAsArray().length > 0) {
                rm.runCommand("Delete");
            }
            for (Roi roi : lines) {
                roi.setStrokeWidth(1.0f);
                rm.addRoi(roi);
            }
            rm.runCommand("Save", Paths.get(baseFolder, "KymographLines.zip").toString());
        }
    }

    public ImageDisplay getImageDisplay() {
        return this.imageDisplay;
    }

    public Dataset getDataset() {
        return (Dataset)this.imageDisplay.getActiveView().getData();
    }

    public TrackedFilaments getTrackedFilaments() {
        return this.trackedFilaments;
    }

    public KymographParameters getKymographParameters() {
        return this.kymographParameters;
    }

    public void setImageDisplay(ImageDisplay imageDisplay) {
        this.imageDisplay = imageDisplay;
    }

    public void setTrackedFilaments(TrackedFilaments trackedFilaments) {
        this.trackedFilaments = trackedFilaments;
    }

    public int nKymographs() {
        return this.kymographs.size();
    }

    private TrackedFilament getRandomTrackedFilament(TrackedFilaments trackedFilaments) {
        Random rand = new Random();
        int listSize = 1;
        List randomTrackedFilaments = rand.ints(listSize, 0, trackedFilaments.size()).mapToObj(i -> (TrackedFilament)trackedFilaments.get(i)).collect(Collectors.toList());
        return (TrackedFilament)randomTrackedFilaments.get(0);
    }

    public boolean kymographsHasBeenSaved() {
        return this.kymographsHasBeenSaved;
    }

    public List<Dataset> getKymographs() {
        return this.kymographs;
    }
}

