/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.math.BigDecimal;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Mutate2D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.transformation.TransformationMatrix;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public class Quaternion
extends Number
implements Scalar<Quaternion>,
NumberContext.Enforceable<Quaternion>,
Access2D<Double>,
TransformationMatrix<Double, PhysicalStore<Double>>,
Access2D.Collectable<Double, Mutate2D.Receiver<Double>> {
    public static final Scalar.Factory<Quaternion> FACTORY = new Scalar.Factory<Quaternion>(){

        @Override
        public Quaternion cast(double value) {
            return Quaternion.valueOf(value);
        }

        @Override
        public Quaternion cast(Number number) {
            return Quaternion.valueOf(number);
        }

        public Quaternion convert(double value) {
            return Quaternion.valueOf(value);
        }

        public Quaternion convert(Number number) {
            return Quaternion.valueOf(number);
        }

        public Quaternion one() {
            return ONE;
        }

        public Quaternion zero() {
            return ZERO;
        }
    };
    public static final Quaternion I = new Versor(PrimitiveMath.ONE, PrimitiveMath.ZERO, PrimitiveMath.ZERO);
    public static final Quaternion IJK = new Quaternion(PrimitiveMath.ONE, PrimitiveMath.ONE, PrimitiveMath.ONE).versor();
    public static final Quaternion INFINITY = Quaternion.makePolar(Double.POSITIVE_INFINITY, IJK.vector().toRawCopy1D(), PrimitiveMath.ZERO);
    public static final Quaternion J = new Versor(PrimitiveMath.ZERO, PrimitiveMath.ONE, PrimitiveMath.ZERO);
    public static final Quaternion K = new Versor(PrimitiveMath.ZERO, PrimitiveMath.ZERO, PrimitiveMath.ONE);
    public static final Quaternion NEG = new Versor(PrimitiveMath.NEG);
    public static final Quaternion ONE = new Versor(PrimitiveMath.ONE);
    public static final Quaternion ZERO = new Quaternion();
    private static final double ARGUMENT_TOLERANCE = PrimitiveMath.PI * PrimitiveScalar.CONTEXT.epsilon();
    public final double i;
    public final double j;
    public final double k;
    private final boolean myPureForSure;
    private final boolean myRealForSure;
    private final double myScalar;

    public static boolean isAbsolute(Quaternion value) {
        return value.isAbsolute();
    }

    public static boolean isInfinite(Quaternion value) {
        return Double.isInfinite(value.doubleValue()) || Double.isInfinite(value.i) || Double.isInfinite(value.j) || Double.isInfinite(value.k) || Double.isInfinite(value.norm());
    }

    public static boolean isNaN(Quaternion value) {
        return Double.isNaN(value.doubleValue()) || Double.isNaN(value.i) || Double.isNaN(value.j) || Double.isNaN(value.k);
    }

    public static boolean isReal(Quaternion value) {
        return value.isReal();
    }

    public static boolean isSmall(double comparedTo, Quaternion value) {
        return value.isSmall(comparedTo);
    }

    public static Quaternion makePolar(double norm, double[] unit, double angle) {
        double tmpSin;
        double tmpCos;
        double tmpAngle = angle % PrimitiveMath.TWO_PI;
        if (tmpAngle < PrimitiveMath.ZERO) {
            tmpAngle += PrimitiveMath.TWO_PI;
        }
        if (tmpAngle <= ARGUMENT_TOLERANCE) {
            return new Quaternion(norm);
        }
        if (PrimitiveFunction.ABS.invoke(tmpAngle - PrimitiveMath.PI) <= ARGUMENT_TOLERANCE) {
            return new Quaternion(-norm);
        }
        double tmpScalar = PrimitiveMath.ZERO;
        if (norm != PrimitiveMath.ZERO && (tmpCos = PrimitiveFunction.COS.invoke(tmpAngle)) != PrimitiveMath.ZERO) {
            tmpScalar = norm * tmpCos;
        }
        double tmpI = PrimitiveMath.ZERO;
        double tmpJ = PrimitiveMath.ZERO;
        double tmpK = PrimitiveMath.ZERO;
        if (norm != PrimitiveMath.ZERO && (tmpSin = PrimitiveFunction.SIN.invoke(tmpAngle)) != PrimitiveMath.ZERO) {
            tmpI = unit[0] * norm * tmpSin;
            tmpJ = unit[1] * norm * tmpSin;
            tmpK = unit[2] * norm * tmpSin;
        }
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    public static Versor makeRotation(RotationAxis axis, double angle) {
        double tmpScalar = PrimitiveFunction.COS.invoke(angle);
        double tmpI = PrimitiveMath.ZERO;
        double tmpJ = PrimitiveMath.ZERO;
        double tmpK = PrimitiveMath.ZERO;
        switch (axis) {
            case X: {
                tmpI = PrimitiveFunction.SIN.invoke(angle);
                break;
            }
            case Y: {
                tmpJ = PrimitiveFunction.SIN.invoke(angle);
                break;
            }
            case Z: {
                tmpK = PrimitiveFunction.SIN.invoke(angle);
                break;
            }
            default: {
                throw new ProgrammingError("How could this happen?");
            }
        }
        return new Versor(tmpScalar, tmpI, tmpJ, tmpK);
    }

    public static Quaternion of(double i, double j, double k) {
        return new Quaternion(0.0, i, j, k);
    }

    public static Quaternion of(double scalar, double i, double j, double k) {
        return new Quaternion(scalar, i, j, k);
    }

    public static Quaternion valueOf(double value) {
        return new Quaternion(value);
    }

    public static Quaternion valueOf(Number number) {
        if (number != null) {
            if (number instanceof Quaternion) {
                return (Quaternion)number;
            }
            if (number instanceof ComplexNumber) {
                ComplexNumber tmpComplex = (ComplexNumber)number;
                return new Quaternion(tmpComplex.doubleValue(), tmpComplex.i, PrimitiveMath.ZERO, PrimitiveMath.ZERO);
            }
            return new Quaternion(number.doubleValue());
        }
        return ZERO;
    }

    public Quaternion() {
        this.myScalar = PrimitiveMath.ZERO;
        this.myRealForSure = true;
        this.myPureForSure = true;
        this.i = PrimitiveMath.ZERO;
        this.j = PrimitiveMath.ZERO;
        this.k = PrimitiveMath.ZERO;
    }

    private Quaternion(double scalar, double[] vector) {
        this.myScalar = scalar;
        this.myRealForSure = false;
        this.myPureForSure = false;
        this.i = vector[0];
        this.j = vector[1];
        this.k = vector[2];
    }

    private Quaternion(double[] vector) {
        this.myScalar = PrimitiveMath.ZERO;
        this.myRealForSure = false;
        this.myPureForSure = true;
        this.i = vector[0];
        this.j = vector[1];
        this.k = vector[2];
    }

    Quaternion(double scalar) {
        this.myScalar = scalar;
        this.myRealForSure = true;
        this.myPureForSure = false;
        this.i = PrimitiveMath.ZERO;
        this.j = PrimitiveMath.ZERO;
        this.k = PrimitiveMath.ZERO;
    }

    Quaternion(double i, double j, double k) {
        this.myScalar = PrimitiveMath.ZERO;
        this.myRealForSure = false;
        this.myPureForSure = true;
        this.i = i;
        this.j = j;
        this.k = k;
    }

    Quaternion(double scalar, double i, double j, double k) {
        this.myScalar = scalar;
        this.myRealForSure = false;
        this.myPureForSure = false;
        this.i = i;
        this.j = j;
        this.k = k;
    }

    @Override
    public Quaternion add(double arg) {
        if (this.isReal()) {
            return new Quaternion(this.myScalar + arg);
        }
        return new Quaternion(this.myScalar + arg, this.i, this.j, this.k);
    }

    @Override
    public Quaternion add(Quaternion arg) {
        if (this.isReal()) {
            return arg.add(this.myScalar);
        }
        double tmpScalar = this.myScalar + arg.scalar();
        double tmpI = this.i + arg.i;
        double tmpJ = this.j + arg.j;
        double tmpK = this.k + arg.k;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    public double angle() {
        return PrimitiveFunction.ACOS.invoke(this.myScalar / this.norm());
    }

    @Override
    public int compareTo(Quaternion reference) {
        int retVal = 0;
        retVal = NumberContext.compare(this.norm(), reference.norm());
        if (retVal == 0 && (retVal = NumberContext.compare(this.myScalar, reference.scalar())) == 0 && (retVal = NumberContext.compare(this.i, reference.i)) == 0 && (retVal = NumberContext.compare(this.j, reference.j)) == 0) {
            retVal = NumberContext.compare(this.k, reference.k);
        }
        return retVal;
    }

    @Override
    public Quaternion conjugate() {
        double tmpScalar = this.myScalar;
        double tmpI = -this.i;
        double tmpJ = -this.j;
        double tmpK = -this.k;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public long count() {
        return 16L;
    }

    @Override
    public long countColumns() {
        return 4L;
    }

    @Override
    public long countRows() {
        return 4L;
    }

    @Override
    public Quaternion divide(double arg) {
        if (this.isReal()) {
            return new Quaternion(this.myScalar / arg);
        }
        if (this.isPure()) {
            double tmpI = this.i / arg;
            double tmpJ = this.j / arg;
            double tmpK = this.k / arg;
            return new Quaternion(tmpI, tmpJ, tmpK);
        }
        double tmpScalar = this.myScalar / arg;
        double tmpI = this.i / arg;
        double tmpJ = this.j / arg;
        double tmpK = this.k / arg;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public Quaternion divide(Quaternion arg) {
        Quaternion tmpReciprocal = arg.invert();
        return this.multiply(tmpReciprocal);
    }

    @Override
    public double doubleValue() {
        return this.myScalar;
    }

    @Override
    public double doubleValue(long index) {
        switch ((int)index) {
            case 0: {
                return this.myScalar;
            }
            case 1: {
                return this.i;
            }
            case 2: {
                return this.j;
            }
            case 3: {
                return this.k;
            }
            case 4: {
                return -this.i;
            }
            case 5: {
                return this.myScalar;
            }
            case 6: {
                return this.k;
            }
            case 7: {
                return -this.j;
            }
            case 8: {
                return -this.j;
            }
            case 9: {
                return -this.k;
            }
            case 10: {
                return this.myScalar;
            }
            case 11: {
                return this.i;
            }
            case 12: {
                return -this.k;
            }
            case 13: {
                return this.j;
            }
            case 14: {
                return -this.i;
            }
            case 15: {
                return this.myScalar;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public double doubleValue(long row, long col) {
        if (row == col) {
            return this.myScalar;
        }
        return this.doubleValue(row + col * 4L);
    }

    @Override
    public Quaternion enforce(NumberContext context) {
        double tmpScalar = context.enforce(this.myScalar);
        double tmpI = context.enforce(this.i);
        double tmpJ = context.enforce(this.j);
        double tmpK = context.enforce(this.k);
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Quaternion)) {
            return false;
        }
        Quaternion other = (Quaternion)obj;
        if (Double.doubleToLongBits(this.myScalar) != Double.doubleToLongBits(other.myScalar)) {
            return false;
        }
        if (Double.doubleToLongBits(this.i) != Double.doubleToLongBits(other.i)) {
            return false;
        }
        if (Double.doubleToLongBits(this.j) != Double.doubleToLongBits(other.j)) {
            return false;
        }
        return Double.doubleToLongBits(this.k) == Double.doubleToLongBits(other.k);
    }

    @Override
    public float floatValue() {
        return (float)this.myScalar;
    }

    @Override
    public Quaternion get() {
        return this;
    }

    @Override
    public Double get(long index) {
        return this.doubleValue(index);
    }

    @Override
    public Double get(long row, long col) {
        return this.doubleValue(row, col);
    }

    public double getDeterminant() {
        double tmpSumOfSquares = this.calculateSumOfSquaresAll();
        return tmpSumOfSquares * tmpSumOfSquares;
    }

    public Quaternion getPureVersor() {
        double tmpLength = this.getVectorLength();
        if (tmpLength > 0.0) {
            return new Quaternion(this.i / tmpLength, this.j / tmpLength, this.k / tmpLength);
        }
        return IJK;
    }

    public double getVectorLength() {
        return PrimitiveFunction.SQRT.invoke(this.calculateSumOfSquaresVector());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.myScalar);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.i);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.j);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.k);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public int intValue() {
        return (int)this.myScalar;
    }

    @Override
    public Quaternion invert() {
        Quaternion tmpConjugate = this.conjugate();
        double tmpSumOfSquares = this.calculateSumOfSquaresAll();
        return tmpConjugate.divide(tmpSumOfSquares);
    }

    @Override
    public boolean isAbsolute() {
        if (this.myRealForSure) {
            return this.myScalar >= PrimitiveMath.ZERO;
        }
        return !PrimitiveScalar.CONTEXT.isDifferent(this.myScalar, this.norm());
    }

    public boolean isPure() {
        return this.myPureForSure || PrimitiveScalar.CONTEXT.isSmall(this.norm(), this.myScalar);
    }

    public boolean isReal() {
        NumberContext cntxt = PrimitiveScalar.CONTEXT;
        return this.myRealForSure || cntxt.isSmall(this.myScalar, this.i) && cntxt.isSmall(this.myScalar, this.j) && cntxt.isSmall(this.myScalar, this.k);
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return PrimitiveScalar.CONTEXT.isSmall(comparedTo, this.norm());
    }

    @Override
    public long longValue() {
        return (long)this.myScalar;
    }

    @Override
    public Quaternion multiply(double arg) {
        if (this.isReal()) {
            return new Quaternion(this.myScalar * arg);
        }
        if (this.isPure()) {
            double tmpI = this.i * arg;
            double tmpJ = this.j * arg;
            double tmpK = this.k * arg;
            return new Quaternion(tmpI, tmpJ, tmpK);
        }
        double tmpScalar = this.myScalar * arg;
        double tmpI = this.i * arg;
        double tmpJ = this.j * arg;
        double tmpK = this.k * arg;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public Quaternion multiply(Quaternion arg) {
        if (this.isReal()) {
            return arg.multiply(this.myScalar);
        }
        double tmpScalar = this.myScalar * arg.scalar() - this.i * arg.i - this.j * arg.j - this.k * arg.k;
        double tmpI = this.myScalar * arg.i + this.i * arg.scalar() + this.j * arg.k - this.k * arg.j;
        double tmpJ = this.myScalar * arg.j - this.i * arg.k + this.j * arg.scalar() + this.k * arg.i;
        double tmpK = this.myScalar * arg.k + this.i * arg.j - this.j * arg.i + this.k * arg.scalar();
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public Quaternion negate() {
        double tmpScalar = -this.myScalar;
        double tmpI = -this.i;
        double tmpJ = -this.j;
        double tmpK = -this.k;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public double norm() {
        return PrimitiveFunction.SQRT.invoke(this.calculateSumOfSquaresAll());
    }

    public double scalar() {
        return this.myScalar;
    }

    @Override
    public Versor signum() {
        return this.versor();
    }

    @Override
    public Quaternion subtract(double arg) {
        if (this.isReal()) {
            return new Quaternion(this.myScalar - arg);
        }
        return new Quaternion(this.myScalar - arg, this.i, this.j, this.k);
    }

    @Override
    public Quaternion subtract(Quaternion arg) {
        double tmpScalar = this.myScalar - arg.scalar();
        double tmpI = this.i - arg.i;
        double tmpJ = this.j - arg.j;
        double tmpK = this.k - arg.k;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public void supplyTo(Mutate2D.Receiver<Double> receiver) {
        receiver.set(0L, this.myScalar);
        receiver.set(1L, this.i);
        receiver.set(2L, this.j);
        receiver.set(3L, this.k);
        receiver.set(4L, -this.i);
        receiver.set(5L, this.myScalar);
        receiver.set(6L, this.k);
        receiver.set(7L, -this.j);
        receiver.set(8L, -this.j);
        receiver.set(9L, -this.k);
        receiver.set(10L, this.myScalar);
        receiver.set(11L, this.i);
        receiver.set(12L, -this.k);
        receiver.set(13L, this.j);
        receiver.set(14L, -this.i);
        receiver.set(15L, this.myScalar);
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.myScalar, PrimitiveScalar.CONTEXT.getMathContext());
    }

    public MatrixStore<ComplexNumber> toComplexMatrix() {
        GenericDenseStore retVal = (GenericDenseStore)GenericDenseStore.COMPLEX.makeZero(2L, 2L);
        retVal.set(0L, (Number)ComplexNumber.of(this.myScalar, this.i));
        retVal.set(1L, (Number)ComplexNumber.of(-this.j, this.k));
        retVal.set(2L, (Number)ComplexNumber.of(this.j, this.k));
        retVal.set(3L, (Number)ComplexNumber.of(this.myScalar, -this.i));
        return retVal;
    }

    public MatrixStore<Double> toMultiplicationMatrix() {
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(this);
        this.supplyTo(retVal);
        return retVal;
    }

    public MatrixStore<Double> toMultiplicationVector() {
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(4L, 1L);
        retVal.set(0L, this.myScalar);
        retVal.set(1L, this.i);
        retVal.set(2L, this.j);
        retVal.set(3L, this.k);
        return retVal;
    }

    public MatrixStore<Double> toRotationMatrix() {
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(3L, 3L);
        double s = this.myScalar;
        double ss = s * s;
        double ii = this.i * this.i;
        double jj = this.j * this.j;
        double kk = this.k * this.k;
        double invs = 1.0 / (ii + jj + kk + ss);
        double r00 = (ii + ss - (jj + kk)) * invs;
        double r11 = (jj + ss - (ii + kk)) * invs;
        double r22 = (kk + ss - (ii + jj)) * invs;
        double tmp1 = this.i * this.j;
        double tmp2 = this.k * s;
        double r10 = 2.0 * (tmp1 + tmp2) * invs;
        double r01 = 2.0 * (tmp1 - tmp2) * invs;
        tmp1 = this.i * this.k;
        tmp2 = this.j * s;
        double r20 = 2.0 * (tmp1 - tmp2) * invs;
        double r02 = 2.0 * (tmp1 + tmp2) * invs;
        tmp1 = this.j * this.k;
        tmp2 = this.i * s;
        double r21 = 2.0 * (tmp1 + tmp2) * invs;
        double r12 = 2.0 * (tmp1 - tmp2) * invs;
        retVal.set(0L, r00);
        retVal.set(1L, r10);
        retVal.set(2L, r20);
        retVal.set(3L, r01);
        retVal.set(4L, r11);
        retVal.set(5L, r21);
        retVal.set(6L, r02);
        retVal.set(7L, r12);
        retVal.set(8L, r22);
        return retVal;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder("(");
        retVal.append(Double.toString(this.myScalar));
        if (this.i < PrimitiveMath.ZERO) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(Double.toString(PrimitiveFunction.ABS.invoke(this.i)));
        retVal.append("i");
        if (this.j < PrimitiveMath.ZERO) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(Double.toString(PrimitiveFunction.ABS.invoke(this.j)));
        retVal.append("j");
        if (this.k < PrimitiveMath.ZERO) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(Double.toString(PrimitiveFunction.ABS.invoke(this.k)));
        retVal.append("k)");
        return retVal.toString();
    }

    @Override
    public String toString(NumberContext context) {
        StringBuilder retVal = new StringBuilder("(");
        BigDecimal tmpScalar = context.enforce(new BigDecimal(this.myScalar, PrimitiveScalar.CONTEXT.getMathContext()));
        BigDecimal tmpI = context.enforce(new BigDecimal(this.i, PrimitiveScalar.CONTEXT.getMathContext()));
        BigDecimal tmpJ = context.enforce(new BigDecimal(this.j, PrimitiveScalar.CONTEXT.getMathContext()));
        BigDecimal tmpK = context.enforce(new BigDecimal(this.k, PrimitiveScalar.CONTEXT.getMathContext()));
        retVal.append(tmpScalar.toString());
        if (tmpI.signum() < 0) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(tmpI.abs().toString());
        retVal.append("i");
        if (tmpJ.signum() < 0) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(tmpJ.abs().toString());
        retVal.append("j");
        if (tmpK.signum() < 0) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(tmpK.abs().toString());
        retVal.append("k)");
        return retVal.toString();
    }

    @Override
    public void transform(PhysicalStore<Double> matrix) {
        double s = this.myScalar;
        double ss = s * s;
        double ii = this.i * this.i;
        double jj = this.j * this.j;
        double kk = this.k * this.k;
        double invs = 1.0 / (ii + jj + kk + ss);
        double r00 = (ii + ss - (jj + kk)) * invs;
        double r11 = (jj + ss - (ii + kk)) * invs;
        double r22 = (kk + ss - (ii + jj)) * invs;
        double tmp1 = this.i * this.j;
        double tmp2 = this.k * s;
        double r10 = 2.0 * (tmp1 + tmp2) * invs;
        double r01 = 2.0 * (tmp1 - tmp2) * invs;
        tmp1 = this.i * this.k;
        tmp2 = this.j * s;
        double r20 = 2.0 * (tmp1 - tmp2) * invs;
        double r02 = 2.0 * (tmp1 + tmp2) * invs;
        tmp1 = this.j * this.k;
        tmp2 = this.i * s;
        double r21 = 2.0 * (tmp1 + tmp2) * invs;
        double r12 = 2.0 * (tmp1 - tmp2) * invs;
        if (matrix.count() == 3L) {
            double x = matrix.doubleValue(0L);
            double y = matrix.doubleValue(1L);
            double z = matrix.doubleValue(2L);
            matrix.set(0L, r00 * x + r01 * y + r02 * z);
            matrix.set(1L, r10 * x + r11 * y + r12 * z);
            matrix.set(2L, r20 * x + r21 * y + r22 * z);
        } else if (matrix.countRows() == 3L) {
            long limit = matrix.countColumns();
            for (long c = 0L; c < limit; ++c) {
                double x = matrix.doubleValue(0L, c);
                double y = matrix.doubleValue(1L, c);
                double z = matrix.doubleValue(2L, c);
                matrix.set(0L, c, r00 * x + r01 * y + r02 * z);
                matrix.set(1L, c, r10 * x + r11 * y + r12 * z);
                matrix.set(2L, c, r20 * x + r21 * y + r22 * z);
            }
        } else if (matrix.countColumns() == 3L) {
            long limit = matrix.countRows();
            for (long r = 0L; r < limit; ++r) {
                double x = matrix.doubleValue(r, 0L);
                double y = matrix.doubleValue(r, 1L);
                double z = matrix.doubleValue(r, 2L);
                matrix.set(r, 0L, r00 * x + r01 * y + r02 * z);
                matrix.set(r, 1L, r10 * x + r11 * y + r12 * z);
                matrix.set(r, 2L, r20 * x + r21 * y + r22 * z);
            }
        } else {
            throw new ProgrammingError("Only works for 3D stuff!");
        }
    }

    public double[] unit() {
        double tmpLength = this.getVectorLength();
        if (tmpLength > 0.0) {
            return new double[]{this.i / tmpLength, this.j / tmpLength, this.k / tmpLength};
        }
        return new double[]{Quaternion.IJK.i, Quaternion.IJK.j, Quaternion.IJK.k};
    }

    public PhysicalStore<Double> vector() {
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(3L, 1L);
        retVal.set(0L, this.i);
        retVal.set(1L, this.j);
        retVal.set(2L, this.k);
        return retVal;
    }

    public Versor versor() {
        double norm = this.norm();
        if (this.isReal()) {
            return new Versor(this.myScalar / norm);
        }
        if (this.isPure()) {
            return new Versor(this.i / norm, this.j / norm, this.k / norm);
        }
        return new Versor(this.myScalar / norm, this.i / norm, this.j / norm, this.k / norm);
    }

    private double calculateSumOfSquaresAll() {
        return this.myScalar * this.myScalar + this.calculateSumOfSquaresVector();
    }

    private double calculateSumOfSquaresVector() {
        return this.i * this.i + this.j * this.j + this.k * this.k;
    }

    public static final class Versor
    extends Quaternion {
        Versor(double scalar) {
            super(scalar);
        }

        Versor(double i, double j, double k) {
            super(i, j, k);
        }

        Versor(double scalar, double i, double j, double k) {
            super(scalar, i, j, k);
        }

        @Override
        public double norm() {
            return PrimitiveMath.ONE;
        }

        @Override
        public MatrixStore<Double> toRotationMatrix() {
            PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(3L, 3L);
            double s = this.doubleValue();
            double ss = s * s;
            double ii = this.i * this.i;
            double jj = this.j * this.j;
            double kk = this.k * this.k;
            double r00 = ii + ss - (jj + kk);
            double r11 = jj + ss - (ii + kk);
            double r22 = kk + ss - (ii + jj);
            double tmp1 = this.i * this.j;
            double tmp2 = this.k * s;
            double r10 = 2.0 * (tmp1 + tmp2);
            double r01 = 2.0 * (tmp1 - tmp2);
            tmp1 = this.i * this.k;
            tmp2 = this.j * s;
            double r20 = 2.0 * (tmp1 - tmp2);
            double r02 = 2.0 * (tmp1 + tmp2);
            tmp1 = this.j * this.k;
            tmp2 = this.i * s;
            double r21 = 2.0 * (tmp1 + tmp2);
            double r12 = 2.0 * (tmp1 - tmp2);
            retVal.set(0L, r00);
            retVal.set(1L, r10);
            retVal.set(2L, r20);
            retVal.set(3L, r01);
            retVal.set(4L, r11);
            retVal.set(5L, r21);
            retVal.set(6L, r02);
            retVal.set(7L, r12);
            retVal.set(8L, r22);
            return retVal;
        }

        @Override
        public void transform(PhysicalStore<Double> matrix) {
            double s = this.doubleValue();
            double ss = s * s;
            double ii = this.i * this.i;
            double jj = this.j * this.j;
            double kk = this.k * this.k;
            double r00 = ii + ss - (jj + kk);
            double r11 = jj + ss - (ii + kk);
            double r22 = kk + ss - (ii + jj);
            double tmp1 = this.i * this.j;
            double tmp2 = this.k * s;
            double r10 = 2.0 * (tmp1 + tmp2);
            double r01 = 2.0 * (tmp1 - tmp2);
            tmp1 = this.i * this.k;
            tmp2 = this.j * s;
            double r20 = 2.0 * (tmp1 - tmp2);
            double r02 = 2.0 * (tmp1 + tmp2);
            tmp1 = this.j * this.k;
            tmp2 = this.i * s;
            double r21 = 2.0 * (tmp1 + tmp2);
            double r12 = 2.0 * (tmp1 - tmp2);
            if (matrix.count() == 3L) {
                double x = matrix.doubleValue(0L);
                double y = matrix.doubleValue(1L);
                double z = matrix.doubleValue(2L);
                matrix.set(0L, r00 * x + r01 * y + r02 * z);
                matrix.set(1L, r10 * x + r11 * y + r12 * z);
                matrix.set(2L, r20 * x + r21 * y + r22 * z);
            } else if (matrix.countRows() == 3L) {
                long limit = matrix.countColumns();
                for (long c = 0L; c < limit; ++c) {
                    double x = matrix.doubleValue(0L, c);
                    double y = matrix.doubleValue(1L, c);
                    double z = matrix.doubleValue(2L, c);
                    matrix.set(0L, c, r00 * x + r01 * y + r02 * z);
                    matrix.set(1L, c, r10 * x + r11 * y + r12 * z);
                    matrix.set(2L, c, r20 * x + r21 * y + r22 * z);
                }
            } else if (matrix.countColumns() == 3L) {
                long limit = matrix.countRows();
                for (long r = 0L; r < limit; ++r) {
                    double x = matrix.doubleValue(r, 0L);
                    double y = matrix.doubleValue(r, 1L);
                    double z = matrix.doubleValue(r, 2L);
                    matrix.set(r, 0L, r00 * x + r01 * y + r02 * z);
                    matrix.set(r, 1L, r10 * x + r11 * y + r12 * z);
                    matrix.set(r, 2L, r20 * x + r21 * y + r22 * z);
                }
            } else {
                throw new ProgrammingError("Only works for 3D stuff!");
            }
        }

        @Override
        public Versor versor() {
            return this;
        }
    }

    public static enum RotationAxis {
        X(0, new double[]{1.0, 0.0, 0.0}),
        Y(1, new double[]{0.0, 1.0, 0.0}),
        Z(2, new double[]{0.0, 0.0, 1.0});

        private final int myIndex;
        private final double[] myVector;

        private RotationAxis(int index, double[] axis) {
            this.myIndex = index;
            this.myVector = axis;
        }

        int index() {
            return this.myIndex;
        }

        double[] vector() {
            return this.myVector;
        }
    }
}

