/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.blosc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.commons.compress.utils.IOUtils;
import org.blosc.BufferSizes;
import org.blosc.JBlosc;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DefaultBlockReader;
import org.janelia.saalfeldlab.n5.DefaultBlockWriter;

@Compression.CompressionType(value="blosc")
public class BloscCompression
implements DefaultBlockReader,
DefaultBlockWriter,
Compression {
    public static final int NOSHUFFLE = 0;
    public static final int SHUFFLE = 1;
    public static final int BITSHUFFLE = 2;
    public static final int AUTOSHUFFLE = -1;
    @Compression.CompressionParameter
    private final String cname;
    @Compression.CompressionParameter
    private final int clevel;
    @Compression.CompressionParameter
    private final int shuffle;
    @Compression.CompressionParameter
    private final int blocksize;
    @Compression.CompressionParameter
    private int nthreads;
    private static final transient JBlosc blosc = new JBlosc();

    public String getCname() {
        return this.cname;
    }

    public int getClevel() {
        return this.clevel;
    }

    public int getShuffle() {
        return this.shuffle;
    }

    public int getBlocksize() {
        return this.blocksize;
    }

    public int getNthreads() {
        return this.nthreads;
    }

    public void setNthreads(int nthreads) {
        this.nthreads = nthreads;
    }

    public BloscCompression() {
        this.cname = "blosclz";
        this.clevel = 6;
        this.shuffle = 0;
        this.blocksize = 0;
        this.nthreads = 1;
    }

    public BloscCompression(String cname, int clevel, int shuffle, int blocksize, int nthreads) {
        this.cname = cname;
        this.clevel = clevel;
        this.shuffle = shuffle;
        this.blocksize = blocksize;
        this.nthreads = nthreads;
    }

    public BloscCompression(BloscCompression template) {
        this.cname = template.cname;
        this.clevel = template.clevel;
        this.shuffle = template.shuffle;
        this.blocksize = template.blocksize;
        this.nthreads = template.nthreads;
    }

    public <T, B extends DataBlock<T>> void read(B dataBlock, InputStream in) throws IOException {
        ByteBuffer dst;
        ByteBuffer src = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)in));
        boolean isByte = dataBlock.getData() instanceof byte[];
        if (isByte) {
            dst = dataBlock.toByteBuffer();
        } else {
            BufferSizes sizes = blosc.cbufferSizes(src);
            int dstSize = (int)sizes.getNbytes();
            dst = ByteBuffer.allocateDirect(dstSize);
        }
        JBlosc.decompressCtx((Buffer)src, (Buffer)dst, (long)dst.capacity(), (int)this.nthreads);
        dataBlock.readData(dst);
    }

    public <T> void write(DataBlock<T> dataBlock, OutputStream out) throws IOException {
        ByteBuffer src = dataBlock.toByteBuffer();
        ByteBuffer dst = ByteBuffer.allocate(src.limit() + 16);
        JBlosc.compressCtx((int)this.clevel, (int)this.shuffle, (int)1, (ByteBuffer)src, (long)src.limit(), (ByteBuffer)dst, (long)dst.limit(), (String)this.cname, (int)this.blocksize, (int)this.nthreads);
        BufferSizes sizes = blosc.cbufferSizes(dst);
        int dstSize = (int)sizes.getCbytes();
        out.write(dst.array(), 0, dstSize);
        out.flush();
    }

    public BloscCompression getReader() {
        return this;
    }

    public BloscCompression getWriter() {
        return this;
    }

    public OutputStream getOutputStream(OutputStream out) throws IOException {
        return null;
    }

    public InputStream getInputStream(InputStream in) throws IOException {
        return null;
    }
}

