/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.lut;

import ij.ImageJ;
import ij.ImagePlus;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.array.ArrayRandomAccess;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.InverseRealTransform;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransformRealRandomAccessible;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.janelia.thickness.lut.AbstractLUTGrid;

public class LUTGrid
extends AbstractLUTGrid {
    public LUTGrid(int numSourceDimensions, int numTargetDimensions, RandomAccessibleInterval<DoubleType> lutArray) {
        super(numSourceDimensions, numTargetDimensions, lutArray);
    }

    public LUTGrid(int numSourceDimensions, int numTargetDimensions, RandomAccessibleInterval<DoubleType> lutArray, double[] scale, double[] shift) {
        super(numSourceDimensions, numTargetDimensions, lutArray, scale, shift);
    }

    public void apply(double[] source, double[] target) {
        int d;
        this.updateCoordinates(source);
        for (d = 0; d < this.nNonTransformedCoordinates; ++d) {
            target[d] = source[d];
        }
        for (d = this.nNonTransformedCoordinates; d < target.length; ++d) {
            target[d] = this.applyChecked(source[d]);
        }
    }

    public void apply(float[] source, float[] target) {
        int d;
        this.updateCoordinates(source);
        for (d = 0; d < this.nNonTransformedCoordinates; ++d) {
            target[d] = source[d];
        }
        for (d = this.nNonTransformedCoordinates; d < target.length; ++d) {
            target[d] = (float)this.applyChecked(source[d]);
        }
    }

    public void apply(RealLocalizable source, RealPositionable target) {
        int d;
        this.updateCoordinates(source);
        for (d = 0; d < this.nNonTransformedCoordinates; ++d) {
            target.setPosition(source.getDoublePosition(d), d);
        }
        for (d = this.nNonTransformedCoordinates; d < target.numDimensions(); ++d) {
            target.setPosition(this.applyChecked(source.getDoublePosition(d)), d);
        }
    }

    public void applyInverse(double[] source, double[] target) {
        int d;
        this.updateCoordinates(target);
        for (d = 0; d < this.nNonTransformedCoordinates; ++d) {
            source[d] = target[d];
        }
        for (d = this.nNonTransformedCoordinates; d < target.length; ++d) {
            source[d] = this.applyInverseChecked(target[d]);
        }
    }

    public void applyInverse(float[] source, float[] target) {
        int d;
        this.updateCoordinates(target);
        for (d = 0; d < this.nNonTransformedCoordinates; ++d) {
            source[d] = target[d];
        }
        for (d = this.nNonTransformedCoordinates; d < target.length; ++d) {
            source[d] = (float)this.applyInverseChecked(target[d]);
        }
    }

    public void applyInverse(RealPositionable source, RealLocalizable target) {
        double dPos;
        double pos;
        int d;
        double epsilon = 1.0E-10;
        this.updateCoordinates(target);
        for (d = 0; d < this.nNonTransformedCoordinates; ++d) {
            pos = target.getDoublePosition(d);
            dPos = pos - 1.0E-10;
            source.setPosition(dPos > 0.0 ? dPos : pos, d);
        }
        for (d = this.nNonTransformedCoordinates; d < target.numDimensions(); ++d) {
            pos = this.applyInverseChecked(target.getDoublePosition(d));
            dPos = pos - 1.0E-10;
            source.setPosition(dPos > 0.0 ? dPos : pos, d);
        }
    }

    public InvertibleRealTransform inverse() {
        return new InverseRealTransform((InvertibleRealTransform)this);
    }

    public LUTGrid copy() {
        return new LUTGrid(this.numSourceDimensions, this.numTargetDimensions, (RandomAccessibleInterval<DoubleType>)this.lutArray, this.scale, this.shift);
    }

    public LUTGrid reScale(double ... scale) {
        int i;
        double[] sc = new double[this.scale.length];
        for (i = 0; i < scale.length; ++i) {
            sc[i] = scale[i];
        }
        for (i = scale.length; i < sc.length; ++i) {
            sc[i] = scale[scale.length - 1];
        }
        return new LUTGrid(this.numSourceDimensions, this.numTargetDimensions, (RandomAccessibleInterval<DoubleType>)this.lutArray, sc, this.shift);
    }

    public LUTGrid reShift(double ... shift) {
        int i;
        double[] sh = new double[this.shift.length];
        for (i = 0; i < shift.length; ++i) {
            sh[i] = shift[i];
        }
        for (i = shift.length; i < sh.length; ++i) {
            sh[i] = shift[shift.length - 1];
        }
        return new LUTGrid(this.numSourceDimensions, this.numTargetDimensions, (RandomAccessibleInterval<DoubleType>)this.lutArray, this.scale, sh);
    }

    public static final void main(String[] args) {
        new ImageJ();
        ImagePlus imp = new ImagePlus("http://media.npr.org/images/picture-show-flickr-promo.jpg");
        for (int y = imp.getHeight() / 2; y < imp.getHeight(); ++y) {
            for (int x = imp.getWidth() / 2; x < imp.getWidth(); ++x) {
                imp.getProcessor().setf(x, y, Float.NaN);
            }
        }
        imp.show();
        System.out.println(imp.getHeight() + " " + imp.getWidth() + " " + imp.getStack().getSize());
        int xyIndices = 5;
        ArrayImg img4D = ArrayImgs.floats((long[])new long[]{5L, 5L, imp.getWidth(), imp.getHeight()});
        ArrayImg lut = ArrayImgs.doubles((long[])new long[]{5L, 5L, Math.max(imp.getWidth(), imp.getHeight())});
        ArrayRandomAccess lutRA = lut.randomAccess();
        ArrayRandomAccess ra = img4D.randomAccess();
        ra.setPosition(new int[]{0, 0, 0, 0});
        for (int yPrime = 0; yPrime < 5; ++yPrime) {
            ra.setPosition(yPrime, 1);
            for (int xPrime = 0; xPrime < 5; ++xPrime) {
                ra.setPosition(xPrime, 0);
                for (int y = 0; y < imp.getHeight(); ++y) {
                    ra.setPosition(y, 3);
                    for (int x = 0; x < imp.getWidth(); ++x) {
                        ra.setPosition(x, 2);
                        ((FloatType)ra.get()).set(imp.getProcessor().getf(x, y));
                        if (Math.abs(x - y) <= 5) continue;
                        ((FloatType)ra.get()).set(Float.NaN);
                    }
                }
            }
        }
        for (int xPrime = 0; xPrime < 5; ++xPrime) {
            for (int yPrime = 0; yPrime < 5; ++yPrime) {
                int z = 0;
                while ((long)z < lut.dimension(2)) {
                    lutRA.setPosition(new int[]{xPrime, yPrime, z});
                    ((DoubleType)lutRA.get()).set((double)z);
                    ++z;
                }
            }
        }
        LUTGrid lutGrid = new LUTGrid(4, 4, (RandomAccessibleInterval<DoubleType>)lut);
        RealRandomAccessible source = Views.interpolate((EuclideanSpace)Views.extendValue((RandomAccessibleInterval)img4D, (Type)new FloatType(Float.NaN)), (InterpolatorFactory)new NLinearInterpolatorFactory());
        RealTransformRealRandomAccessible source2 = RealViews.transformReal((RealRandomAccessible)source, (InvertibleRealTransform)lutGrid);
        RealRandomAccessible source3 = Views.interpolate((EuclideanSpace)Views.extendBorder((RandomAccessibleInterval)img4D), (InterpolatorFactory)new NLinearInterpolatorFactory());
        RealTransformRealRandomAccessible source4 = RealViews.transformReal((RealRandomAccessible)source3, (InvertibleRealTransform)lutGrid);
        IntervalView v1 = Views.hyperSlice((RandomAccessibleInterval)Views.hyperSlice((RandomAccessibleInterval)img4D, (int)1, (long)2L), (int)0, (long)2L);
        IntervalView v2 = Views.interval((RandomAccessible)Views.hyperSlice((RandomAccessible)Views.hyperSlice((RandomAccessible)Views.raster((RealRandomAccessible)source2), (int)1, (long)0L), (int)0, (long)0L), (Interval)new FinalInterval((Interval)v1));
        IntervalView v3 = Views.interval((RandomAccessible)Views.hyperSlice((RandomAccessible)Views.hyperSlice((RandomAccessible)Views.raster((RealRandomAccessible)source4), (int)1, (long)0L), (int)0, (long)0L), (Interval)new FinalInterval((Interval)v1));
        ImageJFunctions.show((RandomAccessibleInterval)v1, (String)"hyperSlice");
        ImageJFunctions.show((RandomAccessibleInterval)v2, (String)"extendNaN");
        ImageJFunctions.show((RandomAccessibleInterval)v3, (String)"extendBorder");
    }
}

