/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.plugin;

import bdv.tools.brightness.MinMaxGroup;
import bdv.util.AxisOrder;
import bdv.util.Bdv;
import bdv.util.BdvFunctions;
import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.FolderOpener;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.FloatStatistics;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.Checkbox;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mpicbg.ij.util.Filter;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.converter.RealDoubleConverter;
import net.imglib2.converter.read.ConvertedRandomAccessibleInterval;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransformRealRandomAccessible;
import net.imglib2.realtransform.RealViews;
import net.imglib2.realtransform.Scale;
import net.imglib2.realtransform.Scale3D;
import net.imglib2.transform.Transform;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import net.imglib2.view.IntervalView;
import net.imglib2.view.TransformView;
import net.imglib2.view.Views;
import org.janelia.thickness.inference.InferFromMatrix;
import org.janelia.thickness.inference.Options;
import org.janelia.thickness.inference.fits.AbstractCorrelationFit;
import org.janelia.thickness.inference.fits.GlobalCorrelationFitAverage;
import org.janelia.thickness.inference.fits.LocalCorrelationFitAverage;
import org.janelia.thickness.inference.visitor.CorrelationFitVisitor;
import org.janelia.thickness.inference.visitor.FileSaverVisitor;
import org.janelia.thickness.inference.visitor.LUTVisitor;
import org.janelia.thickness.inference.visitor.LazyVisitor;
import org.janelia.thickness.inference.visitor.ListVisitor;
import org.janelia.thickness.inference.visitor.MatrixVisitor;
import org.janelia.thickness.inference.visitor.ScalingFactorsVisitor;
import org.janelia.thickness.inference.visitor.Visitor;
import org.janelia.thickness.lut.LUTRealTransform;
import org.janelia.thickness.lut.PermutationTransform;
import org.janelia.thickness.lut.SingleDimensionLUTRealTransform;
import org.janelia.thickness.lut.SingleDimensionPermutationTransform;
import org.janelia.thickness.plugin.NonBlockingGenericDialogWithFileField;
import org.janelia.thickness.plugin.RealSumFloatNCC;
import org.janelia.thickness.plugin.SourcePixelReader;
import org.janelia.thickness.plugin.TargetPixelWriter;
import org.janelia.utility.MatrixStripConversion;
import org.janelia.utility.arrays.ArraySortedIndices;

public class ZPositionCorrection
implements PlugIn {
    private static HashMap<String, VisitorFactory> visitors = new HashMap();

    public static void addVisitor(String name, Visitor visitor) {
        ZPositionCorrection.addVisitor(name, (RandomAccessibleInterval<DoubleType> matrix, Options options) -> visitor);
    }

    public static void addVisitor(String name, VisitorFactory factory) {
        if (name.equals("lazy") && visitors.containsKey(name)) {
            IJ.log((String)"Default visitor (\"lazy\") will not be replaced.");
        } else {
            visitors.put(name, factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String arg0) {
        RandomAccessibleInterval<DoubleType> matrix;
        FloatProcessor matrixFp;
        Options options = Options.generateDefaultOptions();
        GenericDialogPlus dialog = new GenericDialogPlus("Correct layer z-positions");
        dialog.addMessage("Data source settings : ");
        dialog.addFileField("Input path (use current image if empty)", "");
        dialog.addChoice("Type of input data : ", new String[]{"Matrix", "Image Stack"}, "Image Stack");
        dialog.addMessage("Inference settings : ");
        dialog.addMessage("Section neighbor range :");
        dialog.addNumericField("test_maximally :", (double)options.comparisonRange.intValue(), 0, 6, "layers");
        dialog.addMessage("Optimizer :");
        dialog.addNumericField("outer_iterations :", (double)options.nIterations.intValue(), 0, 6, "");
        dialog.addNumericField("outer_regularization :", 1.0 - options.shiftProportion, 2, 6, "");
        dialog.addNumericField("inner_iterations :", (double)options.scalingFactorEstimationIterations.intValue(), 0, 6, "");
        dialog.addNumericField("inner_regularization :", options.scalingFactorRegularizerWeight.doubleValue(), 2, 6, "");
        dialog.addCheckbox(" allow_reordering", options.withReorder.booleanValue());
        dialog.addNumericField("number of local estimates :", 1.0, 0, 6, "");
        HashMap<String, VisitorFactory> hashMap = visitors;
        synchronized (hashMap) {
            String[] visitorStrings = new String[visitors.size()];
            Iterator<String> keysIterator = visitors.keySet().iterator();
            for (int i = 0; i < visitorStrings.length; ++i) {
                visitorStrings[i] = keysIterator.next();
            }
            dialog.addChoice("Visitor", visitorStrings, visitors.containsKey("lazy") ? "lazy" : visitorStrings[0]);
        }
        dialog.showDialog();
        if (dialog.wasCanceled()) {
            return;
        }
        String inputPath = dialog.getNextString();
        boolean inputIsMatrix = dialog.getNextChoiceIndex() == 0;
        ImagePlus input = inputPath.equals("") ? IJ.getImage() : FolderOpener.open((String)inputPath);
        options.comparisonRange = (int)dialog.getNextNumber();
        options.nIterations = (int)dialog.getNextNumber();
        options.shiftProportion = 1.0 - dialog.getNextNumber();
        options.scalingFactorEstimationIterations = (int)dialog.getNextNumber();
        options.scalingFactorRegularizerWeight = dialog.getNextNumber();
        options.withReorder = dialog.getNextBoolean();
        options.forceMonotonicity = true;
        options.minimumSectionThickness = 1.0E-9;
        options.regularizationType = InferFromMatrix.RegularizationType.BORDER;
        int nLocalEstimates = (int)dialog.getNextNumber();
        String visitorString = dialog.getNextChoice();
        FloatProcessor floatProcessor = matrixFp = inputIsMatrix ? ZPositionCorrection.normalize(input).getProcessor().convertToFloatProcessor() : ZPositionCorrection.calculateSimilarityMatrix(input, options.comparisonRange);
        if (matrixFp == null) {
            return;
        }
        boolean isStrip = matrixFp.getWidth() != matrixFp.getHeight();
        RandomAccessibleInterval<DoubleType> wrappedFp = ZPositionCorrection.wrapDouble(new ImagePlus("", (ImageProcessor)matrixFp));
        RandomAccessibleInterval<DoubleType> randomAccessibleInterval = matrix = isStrip ? MatrixStripConversion.stripToMatrix(wrappedFp, new DoubleType()) : wrappedFp;
        if (!inputIsMatrix) {
            ImageJFunctions.show(matrix);
        }
        double[] startingCoordinates = new double[(int)matrix.dimension(0)];
        for (int i = 0; i < startingCoordinates.length; ++i) {
            startingCoordinates[i] = i;
        }
        options.estimateWindowRadius = startingCoordinates.length / nLocalEstimates;
        AbstractCorrelationFit correlationFit = nLocalEstimates < 2 ? new GlobalCorrelationFitAverage() : new LocalCorrelationFitAverage(startingCoordinates.length, options);
        InferFromMatrix inf = new InferFromMatrix(correlationFit);
        boolean estimatedSuccessfully = false;
        double[] transform = null;
        try {
            VisitorFactory factory = visitors.get(visitorString);
            Visitor visitor = factory.create(matrix, options);
            transform = inf.estimateZCoordinates(matrix, startingCoordinates, visitor, options);
            estimatedSuccessfully = true;
        }
        catch (NotEnoughDataPointsException e) {
            e.printStackTrace();
        }
        catch (IllDefinedDataPointsException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IJ.log((String)options.toString());
        if (estimatedSuccessfully) {
            IJ.log((String)Arrays.toString(transform));
            double[] sortedTransform = (double[])transform.clone();
            int[] forward = new int[sortedTransform.length];
            int[] backward = new int[sortedTransform.length];
            if (options.withReorder.booleanValue()) {
                ArraySortedIndices.sort(sortedTransform, forward, backward);
            } else {
                for (int i = 0; i < forward.length; ++i) {
                    forward[i] = i;
                    backward[i] = i;
                }
            }
            int[] permutationArray = backward;
            PermutationTransform permutation = new PermutationTransform(permutationArray, 2, 2);
            LUTRealTransform lut = new LUTRealTransform(sortedTransform, 2, 2);
            RandomAccessibleInterval<DoubleType> transformedStripOrMatrix = Views.interval((RandomAccessible)Views.raster(ZPositionCorrection.generateTransformed(matrix, (Transform)permutation, lut, new DoubleType(Double.NaN))), matrix);
            RandomAccessibleInterval<DoubleType> transformedMatrix = isStrip ? MatrixStripConversion.matrixToStrip(transformedStripOrMatrix, options.comparisonRange, new DoubleType()) : transformedStripOrMatrix;
            ImageJFunctions.show((RandomAccessibleInterval)transformedMatrix, (String)"Warped matrix");
            GenericDialogPlus saveAsCsvDialog = new GenericDialogPlus("Save transform");
            saveAsCsvDialog.addFileField("Store transform as CSV", null);
            saveAsCsvDialog.showDialog();
            if (saveAsCsvDialog.wasOKed()) {
                String csvPath = saveAsCsvDialog.getNextString();
                File f = new File(csvPath);
                try {
                    f.createNewFile();
                    try (FileOutputStream fos = new FileOutputStream(f);
                         BufferedOutputStream bos = new BufferedOutputStream(fos);
                         DataOutputStream dos = new DataOutputStream(bos);){
                        StringBuilder sb = new StringBuilder("z-index,mapping,sorted mapping,forward permutation,backward permutation");
                        for (int i = 0; i < forward.length; ++i) {
                            sb.append("\n").append(i).append(",").append(transform[i]).append(",").append(sortedTransform[i]).append(",").append(forward[i]).append(",").append(backward[i]);
                        }
                        dos.writeBytes(sb.toString());
                    }
                }
                catch (Exception e) {
                    IJ.log((String)("Unable to save transform at: " + csvPath));
                    IJ.handleException((Throwable)new IOException("Unable to save transform at: " + csvPath, e));
                }
            }
            double stackXScale = inputIsMatrix ? 1.0 : input.getCalibration().pixelWidth;
            double stackYScale = inputIsMatrix ? 1.0 : input.getCalibration().pixelHeight;
            double stackZScale = inputIsMatrix ? 1.0 : input.getCalibration().pixelDepth;
            boolean showTransformedStack = true;
            Pair<ImagePlus, double[]> inputAndVoxelSizeBdv = ZPositionCorrection.askShowAsBdv(inputIsMatrix ? null : input, permutationArray, sortedTransform, stackXScale, stackYScale, stackZScale, true);
            stackXScale = ((double[])inputAndVoxelSizeBdv.getB())[0];
            stackYScale = ((double[])inputAndVoxelSizeBdv.getB())[1];
            stackZScale = ((double[])inputAndVoxelSizeBdv.getB())[2];
            boolean renderIntoImagePlus = true;
            Pair<ImagePlus, double[]> pair = ZPositionCorrection.askRenderAsImgPlus(inputIsMatrix ? null : input, permutationArray, sortedTransform, stackXScale, stackYScale, stackZScale, true);
        }
    }

    public static RandomAccessibleInterval<DoubleType> wrapDouble(ImagePlus input) {
        return new ConvertedRandomAccessibleInterval((RandomAccessibleInterval)ImageJFunctions.wrapFloat((ImagePlus)input), (Converter)new RealDoubleConverter(), DoubleType::new);
    }

    public static ImagePlus normalize(ImagePlus input) {
        FloatProcessor fp = input.getProcessor().convertToFloatProcessor();
        FloatStatistics stat = new FloatStatistics((ImageProcessor)fp);
        float[] array = (float[])fp.getPixels();
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = (float)((double)array[n] / stat.max);
        }
        return input;
    }

    public static RandomAccessibleInterval<DoubleType> normalizeAndWrap(ImagePlus input) {
        return ZPositionCorrection.wrapDouble(ZPositionCorrection.normalize(input));
    }

    public static FloatProcessor calculateSimilarityMatrix(ImagePlus input, int range) {
        GenericDialog dialog = new GenericDialog("Choose similiarity calculation method");
        dialog.addChoice("Similarity_method :", new String[]{"NCC (aligned)"}, "NCC (aligned)");
        dialog.showDialog();
        if (dialog.wasCanceled()) {
            return null;
        }
        int method = dialog.getNextChoiceIndex();
        FloatProcessor matrix = ZPositionCorrection.createEmptyMatrix(input.getStack().getSize());
        boolean similarityCalculationWasSuccessful = false;
        switch (method) {
            case 1: {
                similarityCalculationWasSuccessful = ZPositionCorrection.invokeSIFT(input, range, matrix);
            }
        }
        similarityCalculationWasSuccessful = ZPositionCorrection.invokeNCC(input, range, matrix);
        if (similarityCalculationWasSuccessful) {
            return matrix;
        }
        return null;
    }

    public static void main(String[] args) {
        new ImageJ();
        ImagePlus imp = new FolderOpener().openFolder("/data/hanslovskyp/davi_toy_set/data/seq");
        Calibration calibration = imp.getCalibration().copy();
        calibration.pixelWidth = 1.0;
        calibration.pixelHeight = 1.0;
        calibration.pixelDepth = 10.0;
        imp.setCalibration(calibration);
        imp.show();
        new ZPositionCorrection().run("");
    }

    public static boolean invokeSIFT(ImagePlus input, int range, FloatProcessor matrix) {
        return false;
    }

    public static boolean invokeNCC(ImagePlus input, final int range, final FloatProcessor matrix) {
        new ImageConverter(input).convertToGray32();
        ImageStack stackSource = input.getStack();
        GenericDialog dialog = new GenericDialog("NCC options");
        dialog.addNumericField("Scale xy before similarity calculation", 1.0, 3);
        dialog.showDialog();
        if (dialog.wasCanceled()) {
            return false;
        }
        double xyScale = dialog.getNextNumber();
        final ImageStack stack = xyScale == 1.0 ? stackSource : ZPositionCorrection.downsampleStack(stackSource, xyScale);
        final int height = input.getStackSize();
        int nThreads = Runtime.getRuntime().availableProcessors();
        ArrayList<2> callables = new ArrayList<2>();
        int i = 0;
        while (i < height) {
            final int finalI = i++;
            callables.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    for (int k = finalI + 1; k - finalI <= range && k < height; ++k) {
                        float val = new RealSumFloatNCC((float[])stack.getProcessor(finalI + 1).getPixels(), (float[])stack.getProcessor(k + 1).getPixels()).call().floatValue();
                        matrix.setf(finalI, k, val);
                        matrix.setf(k, finalI, val);
                    }
                    return null;
                }
            });
        }
        ExecutorService es = Executors.newFixedThreadPool(nThreads);
        try {
            es.invokeAll(callables);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static ImageStack downsampleStack(ImageStack stackSource, double xyScale) {
        ImageStack stack = new ImageStack((int)Math.round((double)stackSource.getWidth() * xyScale), (int)Math.round((double)stackSource.getHeight() * xyScale));
        for (int z = 1; z <= stackSource.getSize(); ++z) {
            stack.addSlice(Filter.createDownsampled((ImageProcessor)stackSource.getProcessor(z), (double)xyScale, (float)0.5f, (float)0.5f));
        }
        return stack;
    }

    public static FloatProcessor createEmptyMatrix(int height) {
        FloatProcessor matrix = new FloatProcessor(height, height);
        matrix.add(Double.NaN);
        for (int i = 0; i < height; ++i) {
            matrix.setf(i, i, 1.0f);
        }
        return matrix;
    }

    public static ImagePlus getFileFromOption(String path) {
        return path.equals("") ? IJ.getImage() : (new File(path).isDirectory() ? FolderOpener.open((String)path) : new ImagePlus(path));
    }

    public static <T extends RealType<T>> RealRandomAccessible<T> generateTransformed(RandomAccessibleInterval<T> input, Transform permutation, InvertibleRealTransform lut, T dummy) {
        dummy.setReal(Double.NaN);
        IntervalView permuted = Views.interval((RandomAccessible)new TransformView(input, permutation), input);
        RealRandomAccessible interpolated = Views.interpolate((EuclideanSpace)Views.extendValue((RandomAccessibleInterval)permuted, dummy), (InterpolatorFactory)new NLinearInterpolatorFactory());
        return RealViews.transformReal((RealRandomAccessible)interpolated, (InvertibleRealTransform)lut);
    }

    public static <T extends RealType<T>> ImageStack generateStack(RealRandomAccessible<T> input, int width, int height, int size, double zScale) {
        Scale3D scaleTransform = new Scale3D(1.0, 1.0, zScale);
        RealTransformRealRandomAccessible scaledInput = RealViews.transformReal(input, (InvertibleRealTransform)scaleTransform);
        int scaledSize = (int)((double)size * zScale);
        return ZPositionCorrection.generateStack(scaledInput, width, height, scaledSize);
    }

    public static <T extends RealType<T>> ImageStack generateStack(RealRandomAccessible<T> input, final int width, final int height, int size) {
        final ImageStack stack = new ImageStack(width, height, size);
        int nThreads = Runtime.getRuntime().availableProcessors();
        ExecutorService es = Executors.newFixedThreadPool(nThreads);
        ArrayList<3> callables = new ArrayList<3>();
        for (int z = 0; z < size; ++z) {
            int zeroBased = z;
            final int oneBased = z + 1;
            final RandomAccess access = Views.raster(input).randomAccess();
            access.setPosition(zeroBased, 2);
            callables.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    FloatProcessor fp = new FloatProcessor(width, height);
                    for (int x = 0; x < width; ++x) {
                        access.setPosition(x, 0);
                        for (int y = 0; y < height; ++y) {
                            access.setPosition(y, 1);
                            fp.setf(x, y, ((RealType)access.get()).getRealFloat());
                        }
                    }
                    stack.setProcessor((ImageProcessor)fp, oneBased);
                    return null;
                }
            });
        }
        try {
            es.invokeAll(callables);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return stack;
    }

    private static Pair<ImagePlus, double[]> askShowAsBdv(ImagePlus input, int[] permutationArray, double[] sortedTransform, double stackXScale, double stackYScale, double stackZScale, boolean showTransformedStack) {
        GenericDialogPlus renderDialog = new GenericDialogPlus("Show result.");
        renderDialog.addCheckbox("Show transformed stack?", showTransformedStack);
        if (input == null) {
            renderDialog.addFileField("Input path (use current image if empty)", "");
        }
        renderDialog.addNumericField("voxel size: x", stackXScale, 4);
        renderDialog.addNumericField("voxel size: y", stackYScale, 4);
        renderDialog.addNumericField("voxel size: z", stackZScale, 4);
        renderDialog.showDialog();
        if (renderDialog.wasCanceled()) {
            return new ValuePair((Object)input, (Object)new double[]{stackXScale, stackYScale, stackZScale});
        }
        showTransformedStack = renderDialog.getNextBoolean();
        stackXScale = renderDialog.getNextNumber();
        stackYScale = renderDialog.getNextNumber();
        stackZScale = renderDialog.getNextNumber();
        if (showTransformedStack) {
            ImagePlus stackImp = input == null ? ZPositionCorrection.getFileFromOption(renderDialog.getNextString()) : input;
            double displayRangeMin = stackImp.getDisplayRangeMin();
            double displayRangeMax = stackImp.getDisplayRangeMax();
            RandomAccessibleInterval<DoubleType> stack = ZPositionCorrection.convertImagePlus(stackImp);
            SingleDimensionPermutationTransform permutation1D = new SingleDimensionPermutationTransform(permutationArray, 3, 3, 2);
            SingleDimensionLUTRealTransform lut1D = new SingleDimensionLUTRealTransform(sortedTransform, 3, 3, 2);
            RealRandomAccessible<DoubleType> transformed = ZPositionCorrection.generateTransformed(stack, (Transform)permutation1D, lut1D, new DoubleType(Double.NaN));
            Scale3D scaleTransform = new Scale3D(stackXScale, stackYScale, stackZScale);
            RealTransformRealRandomAccessible scaled = RealViews.transformReal(transformed, (InvertibleRealTransform)scaleTransform);
            long[] dim = new long[stack.numDimensions()];
            stack.dimensions(dim);
            dim[0] = (long)((double)dim[0] * stackXScale);
            dim[1] = (long)((double)dim[1] * stackYScale);
            dim[2] = (long)((double)dim[2] * stackZScale);
            new Thread(() -> {
                BdvStackSource bdv = BdvFunctions.show((RealRandomAccessible)scaled, (Interval)new FinalInterval(dim), (String)"Transformed stack.", (BdvOptions)Bdv.options().axisOrder(AxisOrder.XYZ));
                for (MinMaxGroup minMax : bdv.getBdvHandle().getSetupAssignments().getMinMaxGroups()) {
                    minMax.setRange(displayRangeMin, displayRangeMax);
                }
                IJ.log((String)"Showing warped image stack.");
            }).start();
            return new ValuePair((Object)stackImp, (Object)new double[]{stackXScale, stackYScale, stackZScale});
        }
        return new ValuePair((Object)input, (Object)new double[]{stackXScale, stackYScale, stackZScale});
    }

    private static Pair<ImagePlus, double[]> askRenderAsImgPlus(ImagePlus input, int[] permutationArray, double[] sortedTransform, double stackXScale, double stackYScale, double stackZScale, boolean doRenderIntoImgPlus) {
        NonBlockingGenericDialogWithFileField renderDialog = new NonBlockingGenericDialogWithFileField("Render stack.");
        renderDialog.addCheckbox("Render into img plus?", doRenderIntoImgPlus);
        if (input == null) {
            renderDialog.addFileField("Input path (use current image if empty)", "");
        }
        renderDialog.addNumericField("voxel size: x", stackXScale, 4);
        renderDialog.addNumericField("voxel size: y", stackYScale, 4);
        renderDialog.addNumericField("voxel size: z", stackZScale, 4);
        renderDialog.addNumericField("Upsample z by", 1.0, 0);
        renderDialog.showDialog();
        if (renderDialog.wasCanceled()) {
            return new ValuePair((Object)input, (Object)new double[]{stackXScale, stackYScale, stackZScale});
        }
        doRenderIntoImgPlus = renderDialog.getNextBoolean();
        stackXScale = renderDialog.getNextNumber();
        stackYScale = renderDialog.getNextNumber();
        stackZScale = renderDialog.getNextNumber();
        int upsampleBy = Math.max((int)renderDialog.getNextNumber(), 1);
        if (doRenderIntoImgPlus) {
            ImagePlus stackImp = input == null ? ZPositionCorrection.getFileFromOption(renderDialog.getNextString()) : input;
            double displayRangeMin = stackImp.getDisplayRangeMin();
            double displayRangeMax = stackImp.getDisplayRangeMax();
            RandomAccessibleInterval<DoubleType> stack = ZPositionCorrection.convertImagePlus(stackImp);
            SingleDimensionPermutationTransform permutation1D = new SingleDimensionPermutationTransform(permutationArray, 1, 1, 0);
            SingleDimensionLUTRealTransform lut1D = new SingleDimensionLUTRealTransform(sortedTransform, 1, 1, 0);
            int width = stackImp.getWidth();
            int height = stackImp.getHeight();
            int depth = stackImp.getStackSize();
            ImageStack resultStack = new ImageStack(width, height);
            double[] zSource = new double[1];
            IJ.log((String)"Rendering warped image into stack.");
            if (upsampleBy == 1) {
                for (int z = 0; z < depth; ++z) {
                    zSource[0] = z;
                    lut1D.applyInverse(zSource, zSource);
                    double zMapped = zSource[0];
                    int z1 = Math.min(Math.max((int)Math.floor(zMapped), 0), depth - 1);
                    int z2 = Math.min(Math.max((int)Math.ceil(zMapped), 0), depth - 1);
                    int z1Perm = permutation1D.apply(z1);
                    int z2Perm = permutation1D.apply(z2);
                    if (z1 == z2) {
                        resultStack.addSlice(stackImp.getStack().getProcessor(z1Perm + 1).duplicate());
                        continue;
                    }
                    double w1 = (double)z2 - zMapped;
                    double w2 = zMapped - (double)z1;
                    ImageProcessor ip1 = stackImp.getStack().getProcessor(z1Perm + 1);
                    ImageProcessor ip2 = stackImp.getStack().getProcessor(z2Perm + 1);
                    ImageProcessor target = ip1.createProcessor(ip1.getWidth(), ip1.getHeight());
                    ZPositionCorrection.interpolate(ip1, ip2, w1, w2, target);
                    resultStack.addSlice(target);
                }
            } else {
                Scale scale = new Scale(new double[]{upsampleBy});
                FloatProcessor nanProcessor = new FloatProcessor(width, height);
                Arrays.fill((float[])nanProcessor.getPixels(), Float.NaN);
                int scaledDepth = depth * upsampleBy - (upsampleBy - 1);
                for (int z = 0; z < scaledDepth; ++z) {
                    zSource[0] = z;
                    scale.applyInverse(zSource, zSource);
                    lut1D.applyInverse(zSource, zSource);
                    double zMapped = zSource[0];
                    resultStack.addSlice(ZPositionCorrection.generateInterpolatedProcessor(zMapped, permutation1D, stackImp.getStack(), nanProcessor));
                }
            }
            ImagePlus imp = new ImagePlus("Z-Spacing: " + input.getTitle(), resultStack);
            imp.show();
            imp.setDisplayRange(displayRangeMin, displayRangeMax);
            Calibration calibration = stackImp.getCalibration().copy();
            calibration.pixelWidth = stackXScale;
            calibration.pixelHeight = stackYScale;
            calibration.pixelDepth = stackZScale / (double)upsampleBy;
            imp.setDimensions(1, (int)stack.dimension(2), 1);
            imp.setCalibration(calibration);
            IJ.log((String)"Rendered warped image stack.");
            return new ValuePair((Object)imp, (Object)new double[]{stackXScale, stackYScale, stackXScale});
        }
        return new ValuePair((Object)input, (Object)new double[]{stackXScale, stackYScale, stackZScale});
    }

    private static <T extends RealType<T>> RandomAccessibleInterval<DoubleType> convertImagePlus(ImagePlus imp) {
        return Converters.convert((RandomAccessibleInterval)ImageJFunctions.wrapReal((ImagePlus)imp), (Converter)new RealDoubleConverter(), (Type)new DoubleType());
    }

    private static ImageProcessor generateInterpolatedProcessor(double zMapped, SingleDimensionPermutationTransform permutation1D, ImageStack stack, FloatProcessor nanProcessor) {
        int depth = stack.getSize();
        int z1 = (int)Math.floor(zMapped);
        int z2 = (int)Math.ceil(zMapped);
        double w1 = (double)z2 - zMapped;
        double w2 = zMapped - (double)z1;
        int width = nanProcessor.getWidth();
        int height = nanProcessor.getHeight();
        int size = width * height;
        if (z1 == z2 && z1 >= 0 && z1 < depth) {
            int z1Perm = permutation1D.apply(z1);
            return stack.getProcessor(z1Perm + 1).duplicate();
        }
        if (z1 < 0 || z1 >= depth || z2 < 0 || z2 >= depth) {
            ImageProcessor target = stack.getProcessor(1).createProcessor(width, height);
            for (int i = 0; i < size; ++i) {
                target.setf(i, nanProcessor.getf(i));
            }
            return target;
        }
        int z1Perm = permutation1D.apply(z1);
        int z2Perm = permutation1D.apply(z2);
        ImageProcessor ip1 = stack.getProcessor(z1Perm + 1);
        ImageProcessor ip2 = stack.getProcessor(z2Perm + 1);
        ImageProcessor target = ip1.createProcessor(ip1.getWidth(), ip1.getHeight());
        ZPositionCorrection.interpolate(ip1, ip2, w1, w2, target);
        return target;
    }

    private static void interpolate(ImageProcessor ip1, ImageProcessor ip2, double w1, double w2, ImageProcessor target) {
        ZPositionCorrection.interpolate(SourcePixelReader.forImageProcessor(ip1), SourcePixelReader.forImageProcessor(ip2), w1, w2, TargetPixelWriter.forImageProcessor(target), target.getWidth() * target.getHeight());
    }

    private static void interpolate(SourcePixelReader r1, SourcePixelReader r2, double w1, double w2, TargetPixelWriter t, int size) {
        double norm = 1.0 / (w1 + w2);
        for (int i = 0; i < size; ++i) {
            double v1 = w1 * r1.valueAt(i);
            double v2 = w2 * r2.valueAt(i);
            t.setValueAt(i, (v1 + v2) * norm);
        }
    }

    static {
        ZPositionCorrection.addVisitor("lazy", new LazyVisitor());
        VisitorFactory factory = new VisitorFactory(){

            @Override
            public Visitor create(RandomAccessibleInterval<DoubleType> matrix, Options options) {
                ArrayList<Visitor> vs;
                FileSaverVisitor v;
                GenericDialogPlus dialog = new GenericDialogPlus("Choose output directory for visitor!");
                dialog.addDirectoryField("Output directory", System.getProperty("user.home"));
                dialog.addCheckboxGroup(4, 1, new String[]{"Fit", "Scaling Factors", "Coordinate Transformation", "Matrix"}, new boolean[]{false, false, false, false});
                dialog.showDialog();
                if (dialog.wasCanceled()) {
                    return new LazyVisitor();
                }
                String basePath = dialog.getNextString();
                Vector boxes = dialog.getCheckboxes();
                IJ.log((String)("" + boxes.get(0)));
                ListVisitor lv = new ListVisitor();
                if (((Checkbox)boxes.get(0)).getState()) {
                    v = new CorrelationFitVisitor(basePath, "", ",", 0);
                    v.setRelativeFilePattern("correlation-fit/", options.nIterations, ".csv");
                    lv.addVisitor(v);
                }
                if (((Checkbox)boxes.get(1)).getState()) {
                    v = new ScalingFactorsVisitor(basePath, "", ",");
                    v.setRelativeFilePattern("scaling-factors/", options.nIterations, ".csv");
                    lv.addVisitor(v);
                }
                if (((Checkbox)boxes.get(2)).getState()) {
                    v = new LUTVisitor(basePath, "", ",");
                    v.setRelativeFilePattern("lut/", options.nIterations, ".csv");
                    lv.addVisitor(v);
                }
                if (((Checkbox)boxes.get(3)).getState()) {
                    v = new MatrixVisitor(basePath, "", options.comparisonRange);
                    v.setRelativeFilePattern("matrices/", options.nIterations, ".tif");
                    lv.addVisitor(v);
                }
                if ((vs = lv.getVisitors()).size() == 0) {
                    return new LazyVisitor();
                }
                return lv;
            }
        };
        ZPositionCorrection.addVisitor("variables", factory);
    }

    public static interface VisitorFactory {
        public Visitor create(RandomAccessibleInterval<DoubleType> var1, Options var2);
    }
}

