/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.queue;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.IntFunction;
import net.imglib2.cache.queue.BlockingFetchQueues;

public class FetcherThreads {
    private final ArrayList<Fetcher> fetchers;

    public FetcherThreads(BlockingFetchQueues<Callable<?>> queue, int numFetcherThreads) {
        this(queue, numFetcherThreads, i -> String.format("Fetcher-%d", i));
    }

    public FetcherThreads(BlockingFetchQueues<Callable<?>> queue, int numFetcherThreads, IntFunction<String> threadIndexToName) {
        this.fetchers = new ArrayList(numFetcherThreads);
        for (int i = 0; i < numFetcherThreads; ++i) {
            Fetcher f = new Fetcher(queue);
            f.setDaemon(true);
            f.setName(threadIndexToName.apply(i));
            this.fetchers.add(f);
            f.start();
        }
    }

    public void pauseFor(long ms) {
        this.pauseUntil(System.currentTimeMillis() + ms);
    }

    public void pauseUntil(long timeMillis) {
        for (Fetcher f : this.fetchers) {
            f.pauseUntil(timeMillis);
        }
    }

    public void wakeUp() {
        for (Fetcher f : this.fetchers) {
            f.wakeUp();
        }
    }

    public void shutdown() {
        for (Fetcher f : this.fetchers) {
            f.shutdown();
        }
    }

    static final class Fetcher
    extends Thread {
        private final BlockingFetchQueues<Callable<?>> queue;
        private final Object lock = new Object();
        private volatile long pauseUntilTimeMillis = 0L;
        private volatile boolean shutdown = false;

        public Fetcher(BlockingFetchQueues<Callable<?>> queue) {
            this.queue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public final void run() {
            loader = null;
            do lbl-1000:
            // 3 sources

            {
                block15: {
                    if (loader != null) break block15;
                    try {
                        loader = this.queue.take();
                    }
                    catch (InterruptedException var2_2) {
                        // empty catch block
                    }
                    if (!this.shutdown) ** GOTO lbl-1000
                    return;
                }
                waitMillis = this.pauseUntilTimeMillis - System.currentTimeMillis();
                while (waitMillis > 0L) {
                    try {
                        var4_4 = this.lock;
                        synchronized (var4_4) {
                            this.lock.wait(waitMillis);
                        }
                    }
                    catch (InterruptedException var4_5) {
                        // empty catch block
                    }
                    if (this.shutdown) {
                        return;
                    }
                    waitMillis = this.pauseUntilTimeMillis - System.currentTimeMillis();
                }
                try {
                    loader.call();
                    loader = null;
                }
                catch (InterruptedException var4_6) {
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof InterruptedException) continue;
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } while (!this.shutdown);
        }

        public void pauseUntil(long timeMillis) {
            this.pauseUntilTimeMillis = timeMillis;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeUp() {
            this.pauseUntilTimeMillis = 0L;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }
    }
}

