/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.loaders.lw3d;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.jogamp.java3d.loaders.ParsingErrorException;
import org.jogamp.java3d.loaders.lw3d.DebugOutput;

class LWOBFileReader
extends BufferedInputStream {
    static final int TRACE = 1;
    static final int VALUES = 2;
    static final int MISC = 4;
    static final int LINE_TRACE = 8;
    static final int NONE = 0;
    static final int EXCEPTION = 16;
    protected DebugOutput debugPrinter = new DebugOutput(127);
    protected String theFilename;
    protected int marker = 0;

    protected void debugOutputLn(int outputType, String theOutput) {
        if (theOutput.equals("")) {
            this.debugPrinter.println(outputType, theOutput);
        } else {
            this.debugPrinter.println(outputType, this.getClass().getName() + "::" + theOutput);
        }
    }

    public String getToken() throws ParsingErrorException {
        byte[] tokenBuffer = new byte[4];
        try {
            int readResult = this.read(tokenBuffer, 0, 4);
            if (readResult == -1) {
                this.debugOutputLn(8, "no token - returning null");
                return null;
            }
            return new String(tokenBuffer);
        }
        catch (IOException e) {
            this.debugOutputLn(16, "getToken: " + e);
            throw new ParsingErrorException(e.getMessage());
        }
    }

    public void skipLength(int amount) throws ParsingErrorException {
        try {
            this.skip(amount);
            this.marker += amount;
        }
        catch (IOException e) {
            this.debugOutputLn(16, "skipLength: " + e);
            throw new ParsingErrorException(e.getMessage());
        }
    }

    public int getInt() throws ParsingErrorException {
        try {
            int x = 0;
            for (int i = 0; i < 4; ++i) {
                int readResult = this.read();
                if (readResult == -1) {
                    throw new ParsingErrorException("Unexpected EOF");
                }
                x = x << 8 | readResult;
            }
            return x;
        }
        catch (IOException e) {
            this.debugOutputLn(16, "getInt: " + e);
            throw new ParsingErrorException(e.getMessage());
        }
    }

    public float getFloat() throws ParsingErrorException {
        return Float.intBitsToFloat(this.getInt());
    }

    public String getFilename() {
        return this.theFilename;
    }

    public String getString() throws ParsingErrorException {
        byte[] buf = new byte[512];
        try {
            byte b;
            int len = 0;
            do {
                b = (byte)this.read();
                buf[len++] = b;
            } while (b != 0);
            if (len % 2 != 0) {
                this.read();
            }
        }
        catch (IOException e) {
            this.debugOutputLn(16, "getString: " + e);
            throw new ParsingErrorException(e.getMessage());
        }
        return new String(buf);
    }

    public void getVerts(float[] ar, int num) throws ParsingErrorException {
        for (int i = 0; i < num; ++i) {
            ar[i * 3 + 0] = this.getFloat();
            ar[i * 3 + 1] = this.getFloat();
            ar[i * 3 + 2] = -this.getFloat();
        }
    }

    public int getShortInt() throws ParsingErrorException {
        int i = 0;
        try {
            i = this.read();
            i = i << 8 | this.read();
            if ((i & 0x8000) != 0) {
                i |= 0xFFFF0000;
            }
        }
        catch (IOException e) {
            this.debugOutputLn(16, "getShortInt: " + e);
            throw new ParsingErrorException(e.getMessage());
        }
        return i;
    }

    public int getMarker() {
        return this.marker;
    }

    @Override
    public int read() throws IOException {
        ++this.marker;
        return super.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        int ret = super.read(buffer, offset, count);
        if (ret != -1) {
            this.marker += ret;
        }
        return ret;
    }

    public LWOBFileReader(String filename) throws FileNotFoundException {
        super(new FileInputStream(filename));
    }

    public LWOBFileReader(URL url) throws IOException {
        super(url.openStream());
    }
}

