/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.interpolators;

import org.jogamp.java3d.Alpha;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.TransformInterpolator;
import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.java3d.utils.behaviors.interpolators.TCBKeyFrame;

public abstract class TCBSplinePathInterpolator
extends TransformInterpolator {
    private int keysLength;
    protected TCBKeyFrame[] keyFrames;
    protected float currentU;
    protected int lowerKnot;
    protected int upperKnot;

    TCBSplinePathInterpolator() {
    }

    public TCBSplinePathInterpolator(Alpha alpha, TCBKeyFrame[] keys) {
        this(alpha, null, keys);
    }

    public TCBSplinePathInterpolator(Alpha alpha, TransformGroup target, TCBKeyFrame[] keys) {
        super(alpha, target);
        this.processKeyFrames(keys);
    }

    public TCBSplinePathInterpolator(Alpha alpha, TransformGroup target, Transform3D axisOfTransform, TCBKeyFrame[] keys) {
        super(alpha, target, axisOfTransform);
        this.processKeyFrames(keys);
    }

    private void processKeyFrames(TCBKeyFrame[] keys) {
        int i;
        this.keysLength = keys.length;
        if (this.keysLength < 2) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator0"));
        }
        if ((double)keys[0].knot < -1.0E-4 || (double)keys[0].knot > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator1"));
        }
        if ((double)keys[this.keysLength - 1].knot - 1.0 < -1.0E-4 || (double)keys[this.keysLength - 1].knot - 1.0 > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator2"));
        }
        for (i = 0; i < this.keysLength; ++i) {
            if (i <= 0 || !(keys[i].knot < keys[i - 1].knot)) continue;
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator3"));
        }
        this.keyFrames = new TCBKeyFrame[this.keysLength + 2];
        this.keyFrames[0] = new TCBKeyFrame();
        this.keyFrames[0] = keys[0];
        for (i = 1; i < this.keysLength + 1; ++i) {
            this.keyFrames[i] = keys[i - 1];
        }
        this.keyFrames[this.keysLength + 1] = new TCBKeyFrame();
        this.keyFrames[this.keysLength + 1] = keys[this.keysLength - 1];
        this.keysLength += 2;
    }

    public int getArrayLength() {
        return this.keysLength - 2;
    }

    public TCBKeyFrame getKeyFrame(int index) {
        return this.keyFrames[index + 1];
    }

    protected void computePathInterpolation(float alphaValue) {
        int i;
        int len = this.keysLength - 2;
        for (i = 1; alphaValue > this.keyFrames[i].knot && i < len; ++i) {
        }
        if (i == 1) {
            this.currentU = 0.0f;
            this.lowerKnot = 1;
            this.upperKnot = 2;
        } else {
            this.currentU = (alphaValue - this.keyFrames[i - 1].knot) / (this.keyFrames[i].knot - this.keyFrames[i - 1].knot);
            this.lowerKnot = i - 1;
            this.upperKnot = i;
        }
    }

    protected void computePathInterpolation() {
        float value = this.getAlpha().value();
        this.computePathInterpolation(value);
    }

    @Override
    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        super.duplicateNode(originalNode, forceDuplicate);
        TCBSplinePathInterpolator originalSpline = (TCBSplinePathInterpolator)originalNode;
        this.setAlpha(originalSpline.getAlpha());
        this.keysLength = originalSpline.keysLength;
        this.keyFrames = new TCBKeyFrame[this.keysLength];
        System.arraycopy(originalSpline.keyFrames, 0, this.keyFrames, 0, this.keysLength);
    }
}

