/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.io.Serializable;
import java.util.Random;
import mpicbg.models.Point;

public class Spring
implements Serializable {
    private static final long serialVersionUID = 1901169757781308736L;
    protected static final Random rnd = new Random(0L);
    protected double length;
    protected final double maxStretch;
    protected double[] weights;
    protected double weight;

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    protected static double squareLength(double[] p1, double[] p2) {
        assert (p1.length == p2.length) : "Both locations have to have the same dimensionality.";
        double l = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            double dl = p1[i] - p2[i];
            l += dl * dl;
        }
        return l;
    }

    protected static double length(double[] p1, double[] p2) {
        return Math.sqrt(Spring.squareLength(p1, p2));
    }

    protected void calculateWeight() {
        this.weight = 1.0;
        for (double wi : this.weights) {
            this.weight *= wi;
        }
    }

    public double getWeight() {
        return this.weight;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] weights) {
        this.weights = (double[])weights.clone();
        this.calculateWeight();
    }

    public void addWeight(double w) {
        double[] newWeights = new double[this.weights.length + 1];
        System.arraycopy(this.weights, 0, newWeights, 0, this.weights.length);
        newWeights[this.weights.length] = w;
        this.weights = newWeights;
        this.calculateWeight();
    }

    public void removeWeight(int index) {
        if (index < this.weights.length) {
            double[] newWeights = new double[this.weights.length - 1];
            int j = 0;
            for (int i = 0; i < this.weights.length; ++i) {
                if (i == index) continue;
                newWeights[j++] = this.weights[i];
            }
            this.weights = newWeights;
            this.calculateWeight();
        }
    }

    public void setWeight(int index, double weight) {
        this.weights[index] = weight;
        this.calculateWeight();
    }

    public void calculateForce(Point p1, Point p2, double[] force) {
        double[] w2;
        assert (force.length == p1.getL().length && force.length == p2.getL().length) : "Both vertices and force have to have the same dimensionality.";
        double[] w1 = p1.getW();
        double lw = Spring.length(w1, w2 = p2.getW());
        double d = lw - this.length;
        if (Math.abs(d) > this.maxStretch) {
            for (int i = 0; i < force.length; ++i) {
                force[i] = 0.0;
            }
        } else if (lw == 0.0) {
            for (int i = 0; i < force.length; ++i) {
                force[i] = 0.0;
            }
            force[(int)((double)force.length * Spring.rnd.nextDouble())] = d * this.weight;
        } else {
            for (int i = 0; i < w1.length; ++i) {
                force[i] = (w2[i] - w1[i]) / lw * d * this.weight;
            }
        }
    }

    public Spring(double length, double[] weights) {
        this.length = length;
        this.weights = (double[])weights.clone();
        this.calculateWeight();
        this.maxStretch = Double.MAX_VALUE;
    }

    public Spring(double length, double[] weights, double maxStretch) {
        this.length = length;
        this.weights = (double[])weights.clone();
        this.calculateWeight();
        this.maxStretch = maxStretch;
    }

    public Spring(double length, double weight) {
        this.length = length;
        this.weights = new double[]{weight};
        this.weight = weight;
        this.maxStretch = Double.MAX_VALUE;
    }

    public Spring(double length, double weight, double maxStretch) {
        this.length = length;
        this.weights = new double[]{weight};
        this.weight = weight;
        this.maxStretch = maxStretch;
    }

    public Spring(double length) {
        this.length = length;
        this.weight = 1.0;
        this.maxStretch = Double.MAX_VALUE;
    }

    public Spring(Point p1, Point p2, double[] weights) {
        this(Spring.length(p1.getL(), p2.getL()), weights);
    }

    public Spring(Point p1, Point p2, double[] weights, double maxStretch) {
        this(Spring.length(p1.getL(), p2.getL()), weights, maxStretch);
    }

    public Spring(Point p1, Point p2, double weight) {
        this(Spring.length(p1.getL(), p2.getL()), weight);
    }

    public Spring(Point p1, Point p2, double weight, double maxStretch) {
        this(Spring.length(p1.getL(), p2.getL()), weight, maxStretch);
    }

    public Spring(Point p1, Point p2) {
        this(Spring.length(p1.getL(), p2.getL()));
    }
}

