/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.net.URI;
import java.net.URISyntaxException;
import org.janelia.saalfeldlab.n5.CachedGsonKeyValueN5Reader;
import org.janelia.saalfeldlab.n5.GsonUtils;
import org.janelia.saalfeldlab.n5.KeyValueAccess;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.cache.N5JsonCache;

public class N5KeyValueReader
implements CachedGsonKeyValueN5Reader {
    public static final String ATTRIBUTES_JSON = "attributes.json";
    protected final KeyValueAccess keyValueAccess;
    protected final Gson gson;
    protected final boolean cacheMeta;
    protected URI uri;
    private final N5JsonCache cache;

    public N5KeyValueReader(KeyValueAccess keyValueAccess, String basePath, GsonBuilder gsonBuilder, boolean cacheMeta) throws N5Exception {
        this(true, keyValueAccess, basePath, gsonBuilder, cacheMeta, true);
    }

    protected N5KeyValueReader(boolean checkVersion, KeyValueAccess keyValueAccess, String basePath, GsonBuilder gsonBuilder, boolean cacheMeta, boolean checkExists) throws N5Exception {
        this.keyValueAccess = keyValueAccess;
        this.gson = GsonUtils.registerGson(gsonBuilder);
        this.cacheMeta = cacheMeta;
        this.cache = this.newCache();
        try {
            this.uri = keyValueAccess.uri(basePath);
        }
        catch (URISyntaxException e) {
            throw new N5Exception(e);
        }
        boolean versionFound = false;
        if (checkVersion) {
            N5Reader.Version version = this.getVersion();
            boolean bl = versionFound = !version.equals(NO_VERSION);
            if (!VERSION.isCompatible(version)) {
                throw new N5Exception.N5IOException("Incompatible version " + version + " (this is " + VERSION + ").");
            }
        }
        if (checkExists && !versionFound && !this.inferExistence("/")) {
            throw new N5Exception.N5IOException("No container exists at " + basePath);
        }
    }

    private boolean inferExistence(String path) {
        JsonElement attributes = this.getAttributes(path);
        return attributes != null || this.exists(path);
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }

    @Override
    public KeyValueAccess getKeyValueAccess() {
        return this.keyValueAccess;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public boolean cacheMeta() {
        return this.cacheMeta;
    }

    @Override
    public N5JsonCache getCache() {
        return this.cache;
    }
}

