/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.overlay;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.imagej.axis.Axes;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.overlay.AbstractROIOverlay;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.roi.PolygonRegionOfInterest;
import org.scijava.Context;

public class PolygonOverlay
extends AbstractROIOverlay<PolygonRegionOfInterest> {
    private static final long serialVersionUID = 1L;

    public PolygonOverlay() {
        super(new PolygonRegionOfInterest());
    }

    public PolygonOverlay(Context context) {
        super(context, new PolygonRegionOfInterest());
        this.setAxis(new DefaultLinearAxis(Axes.X), 0);
        this.setAxis(new DefaultLinearAxis(Axes.Y), 1);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        PolygonRegionOfInterest roi = (PolygonRegionOfInterest)this.getRegionOfInterest();
        int vertexCount = roi.getVertexCount();
        out.writeInt(vertexCount);
        for (int i = 0; i < vertexCount; ++i) {
            RealLocalizable vertex = roi.getVertex(i);
            out.writeDouble(vertex.getDoublePosition(0));
            out.writeDouble(vertex.getDoublePosition(1));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        PolygonRegionOfInterest roi = (PolygonRegionOfInterest)this.getRegionOfInterest();
        while (roi.getVertexCount() > 0) {
            roi.removeVertex(0);
        }
        int vertexCount = in.readInt();
        for (int i = 0; i < vertexCount; ++i) {
            RealPoint vertex = new RealPoint(new double[]{in.readDouble(), in.readDouble()});
            roi.addVertex(i, (RealLocalizable)vertex);
        }
    }

    @Override
    public void move(double[] deltas) {
        ((PolygonRegionOfInterest)this.getRegionOfInterest()).move(deltas);
    }
}

