/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.assign;

import net.imagej.ChannelCollection;
import net.imagej.Dataset;
import net.imagej.Position;
import net.imagej.display.OverlayService;
import net.imagej.overlay.Overlay;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Edit", weight=1.0, mnemonic=101), @Menu(label="Fill", weight=28.0, accelerator="^F")}, headless=true, attrs={@Attr(name="no-legacy")})
public class FillDataValues<T extends RealType<T>>
extends ContextCommand {
    @Parameter
    private OverlayService overlayService;
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;
    @Parameter
    private Position position;
    @Parameter(persist=false)
    private Overlay overlay;
    @Parameter
    private ChannelCollection color;

    public void run() {
        if (this.overlay == null) {
            this.cancel("This command requires a selection");
            return;
        }
        if (this.color == null) {
            this.cancel("This command requires a color to fill with");
            return;
        }
        this.overlayService.fillOverlay(this.overlay, this.dataset, this.position, this.color);
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public void setOverlay(Overlay overlay) {
        this.overlay = overlay;
    }

    public ChannelCollection getColor() {
        return this.color;
    }

    public void setColor(ChannelCollection color) {
        this.color = color;
    }
}

