/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.imglib;

import java.util.Random;
import net.imagej.Dataset;
import net.imagej.Extents;
import net.imagej.Position;
import net.imagej.autoscale.AutoscaleService;
import net.imagej.autoscale.DataRange;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.stats.ComputeMinMax;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.RealRect;

@Plugin(type=Command.class, menu={@Menu(label="Process", weight=3.0, mnemonic=112), @Menu(label="Noise", mnemonic=110), @Menu(label="Salt and Pepper", weight=3.0)}, headless=true, attrs={@Attr(name="no-legacy")})
public class SaltAndPepper
extends ContextCommand {
    @Parameter
    private AutoscaleService autoscaleService;
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private OverlayService overlayService;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;
    @Parameter(label="Use data min and max (ignore values below)")
    private boolean autoCalcMinMax = false;
    @Parameter(label="Salt Value")
    private double saltValue = 255.0;
    @Parameter(label="Pepper Value")
    private double pepperValue = 0.0;
    private Dataset input;
    private RealRect selection;
    private Img<? extends RealType<?>> inputImage;
    private RandomAccess<? extends RealType<?>> accessor;
    private long[] position;

    public void run() {
        if (!this.inputOkay()) {
            return;
        }
        this.setupWorkingData();
        this.assignPixels();
        this.cleanup();
        this.input.update();
    }

    public void setDisplay(ImageDisplay disp) {
        this.display = disp;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public void setSaltValue(double val) {
        this.saltValue = val;
    }

    public double getSaltValue() {
        return this.saltValue;
    }

    public void setPepperValue(double val) {
        this.pepperValue = val;
    }

    public double getPepperValue() {
        return this.pepperValue;
    }

    private boolean inputOkay() {
        this.input = this.imageDisplayService.getActiveDataset(this.display);
        if (this.input == null) {
            this.cancel("Input dataset must not be null.");
            return false;
        }
        if (this.input.getImgPlus() == null) {
            this.cancel("Input Imgplus must not be null.");
            return false;
        }
        if (!this.input.isInteger()) {
            this.cancel("Input dataset must be an integral type.");
            return false;
        }
        if (this.input.isRGBMerged()) {
            this.cancel("Input dataset cannot be color.");
            return false;
        }
        return true;
    }

    private void setupWorkingData() {
        this.selection = this.overlayService.getSelectionBounds(this.display);
        this.inputImage = this.input.getImgPlus();
        this.position = new long[this.inputImage.numDimensions()];
        this.accessor = this.inputImage.randomAccess();
        if (this.autoCalcMinMax) {
            DataRange range = this.autoscaleService.getDefaultIntervalRange(this.inputImage);
            this.pepperValue = range.getMin();
            this.saltValue = range.getMax();
            RealType t = (RealType)this.inputImage.firstElement();
            ComputeMinMax cmm = new ComputeMinMax(this.inputImage, t.createVariable(), t.createVariable());
            cmm.process();
            this.pepperValue = ((RealType)cmm.getMin()).getRealDouble();
            this.saltValue = ((RealType)cmm.getMax()).getRealDouble();
        }
    }

    private void assignPixels() {
        Random rng = new Random();
        rng.setSeed(System.currentTimeMillis());
        long[] planeDims = new long[this.inputImage.numDimensions() - 2];
        for (int i = 0; i < planeDims.length; ++i) {
            planeDims[i] = this.inputImage.dimension(i + 2);
        }
        Extents extents = new Extents(planeDims);
        Position planePos = extents.createPosition();
        if (planeDims.length == 0) {
            this.assignPlanePixels(planePos, rng);
        } else {
            while (planePos.hasNext()) {
                planePos.fwd();
                this.assignPlanePixels(planePos, rng);
            }
        }
    }

    private void cleanup() {
    }

    private void assignPlanePixels(Position planePos, Random rng) {
        for (int i = 2; i < this.position.length; ++i) {
            this.position[i] = planePos.getLongPosition(i - 2);
        }
        long ou = (long)this.selection.x;
        long ov = (long)this.selection.y;
        long w = (long)this.selection.width;
        long h = (long)this.selection.height;
        if (w <= 0L) {
            w = this.inputImage.dimension(0);
        }
        if (h <= 0L) {
            h = this.inputImage.dimension(1);
        }
        double percentToChange = 0.05;
        long numPixels = (long)(0.05 * (double)w * (double)h);
        for (long p = 0L; p < numPixels / 2L; ++p) {
            long randomU = ou + this.nextLong(rng, w);
            long randomV = ov + this.nextLong(rng, h);
            this.setPixel(randomU, randomV, this.saltValue);
            randomU = ou + this.nextLong(rng, w);
            randomV = ov + this.nextLong(rng, h);
            this.setPixel(randomU, randomV, this.pepperValue);
        }
    }

    private long nextLong(Random rng, long bound) {
        double val = rng.nextDouble();
        return (long)(val * (double)bound);
    }

    private void setPixel(long u, long v, double value) {
        this.position[0] = u;
        this.position[1] = v;
        this.accessor.setPosition(this.position);
        ((RealType)this.accessor.get()).setReal(value);
    }
}

