/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class StaticSwingUtils {
    private static final int DEFAULT_X = 5;
    private static final int DEFAULT_Y = 80;
    private static Point lastFramePosition = new Point(5, 80);

    private StaticSwingUtils() {
    }

    public static JButton createButton16(ImageIcon icon) {
        return StaticSwingUtils.createButton16(icon, null);
    }

    public static JButton createButton16(ImageIcon icon, String toolTip) {
        JButton newButton = new JButton();
        newButton.setMargin(new Insets(0, 0, 0, 0));
        newButton.setMinimumSize(new Dimension(16, 16));
        if (toolTip != null) {
            newButton.setToolTipText(toolTip);
        }
        newButton.setIcon(icon);
        return newButton;
    }

    public static void addHotKey(int key, JComponent to, String actionName, Action action) {
        KeyStroke keystroke = KeyStroke.getKeyStroke(key, 2);
        InputMap map = to.getInputMap(2);
        map.put(keystroke, actionName);
        to.getActionMap().put(actionName, action);
        if (to instanceof JMenuItem) {
            ((JMenuItem)to).setAccelerator(keystroke);
        }
        if (to instanceof AbstractButton) {
            ((AbstractButton)to).addActionListener(action);
        }
    }

    public static JFrame getTopFrame(Component comp) {
        if (comp == null) {
            return null;
        }
        Component top = comp;
        while (top.getParent() != null) {
            top = top.getParent();
        }
        if (top instanceof JFrame) {
            return (JFrame)top;
        }
        return null;
    }

    public static void placeInClipboard(String str) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(str), null);
    }

    public static String getFromClipboard() {
        String str = null;
        try {
            str = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return str;
    }

    public Component findUltimateParent(Component c) {
        Component parent = c;
        while (null != parent.getParent()) {
            if (!((parent = parent.getParent()) instanceof JPopupMenu)) continue;
            JPopupMenu popup = (JPopupMenu)parent;
            parent = popup.getInvoker();
        }
        return parent;
    }

    public static void locateCenter(Container component) {
        int w = component.getWidth();
        int h = component.getHeight();
        Rectangle bounds = StaticSwingUtils.getWorkSpaceBounds();
        int x = (int)(bounds.getX() + (bounds.getWidth() - (double)w) / 2.0);
        int y = (int)(bounds.getY() + (bounds.getHeight() - (double)h) / 2.0);
        component.setLocation(x, y);
    }

    public static void locateUpperRight(Container component) {
        int w = component.getWidth();
        Rectangle bounds = StaticSwingUtils.getWorkSpaceBounds();
        int x = (int)(bounds.getX() + bounds.getWidth() - (double)w);
        int y = (int)bounds.getY();
        component.setLocation(x, y);
    }

    public static void locateLowerRight(Container component) {
        int w = component.getWidth();
        int h = component.getHeight();
        Rectangle bounds = StaticSwingUtils.getWorkSpaceBounds();
        int x = (int)(bounds.getX() + bounds.getWidth() - (double)w);
        int y = (int)(bounds.getY() + bounds.getHeight() - (double)h);
        component.setLocation(x, y);
    }

    public static void locateUpperLeft(Container component) {
        Rectangle bounds = StaticSwingUtils.getWorkSpaceBounds();
        component.setLocation((int)bounds.getX(), (int)bounds.getY());
    }

    public static void locateLowerLeft(Container component) {
        int h = component.getHeight();
        Rectangle bounds = StaticSwingUtils.getWorkSpaceBounds();
        int x = (int)bounds.getX();
        int y = (int)(bounds.getY() + bounds.getHeight() - (double)h);
        component.setLocation(x, y);
    }

    public static Point nextFramePosition() {
        StaticSwingUtils.lastFramePosition.x += 16;
        StaticSwingUtils.lastFramePosition.y += 16;
        if (StaticSwingUtils.lastFramePosition.x > 200) {
            StaticSwingUtils.lastFramePosition.x = 5;
            StaticSwingUtils.lastFramePosition.y = 80;
        }
        return lastFramePosition;
    }

    public static Rectangle getWorkSpaceBounds() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
    }

    @Deprecated
    public static void dispatchToEDT(Runnable runnable) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    @Deprecated
    public static void dispatchToEDTWait(Runnable runnable) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(StaticSwingUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(StaticSwingUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            runnable.run();
        }
    }

    public static void scrollToBottom(JScrollPane scrollPane) {
        JViewport viewport = scrollPane.getViewport();
        viewport.setViewPosition(new Point(0, viewport.getView().getHeight()));
    }

    public static boolean isScrolledToBottom(JScrollPane scrollPane) {
        BoundedRangeModel m = scrollPane.getVerticalScrollBar().getModel();
        return m.getValue() + m.getExtent() >= m.getMaximum();
    }

    public static abstract class PopperUpper
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popUp(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popUp(e);
            }
        }

        protected abstract void popUp(MouseEvent var1);
    }
}

