/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.cfg;

import com.google.common.base.Predicate;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.ir.ssa.PhiFunction;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.compiler.ir.tac.statements.Assignment;
import org.renjin.compiler.ir.tac.statements.Statement;

public class CfgPredicates {
    private CfgPredicates() {
    }

    public static Predicate<BasicBlock> containsAssignmentTo(final Variable variable) {
        return new Predicate<BasicBlock>(){

            public boolean apply(BasicBlock input) {
                for (Statement stmt : input.getStatements()) {
                    Assignment assignment;
                    if (!(stmt instanceof Assignment) || !(assignment = (Assignment)stmt).getLHS().equals(variable)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Statement> isPhiAssignment() {
        return new Predicate<Statement>(){

            public boolean apply(Statement input) {
                if (!(input instanceof Assignment)) {
                    return false;
                }
                Assignment assignment = (Assignment)input;
                return assignment.getRHS() instanceof PhiFunction;
            }
        };
    }
}

