/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.sequence;

import org.renjin.eval.EvalException;
import org.renjin.primitives.sequence.RepDoubleVector;
import org.renjin.primitives.sequence.RepStringVector;
import org.renjin.sexp.AbstractAtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class RepLogicalVector
extends LogicalVector {
    public static final int LENGTH_THRESHOLD = 100;
    private final Vector source;
    private int length;
    private int each;

    public RepLogicalVector(Vector source, int length2, int each, AttributeMap attributes2) {
        super(attributes2);
        this.source = source;
        this.length = length2;
        this.each = each;
        if (this.length <= 0) {
            throw new IllegalArgumentException("length: " + length2);
        }
    }

    public RepLogicalVector(Vector source, int length2, int each) {
        this(source, length2, each, RepLogicalVector.transformAttributes(source, length2, each));
    }

    private static AttributeMap transformAttributes(Vector source, int length2, int each) {
        if (source.getAttributes().hasNames()) {
            return source.getAttributes().copy().setNames(new RepStringVector(source.getAttributes().getNames(), length2, each, AttributeMap.EMPTY)).build();
        }
        return source.getAttributes();
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new RepDoubleVector(this.source, this.length, this.each, attributes2);
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int getElementAsRawLogical(int index) {
        return this.source.getElementAsInt(index / this.each % this.source.length());
    }

    public static Builder newConstantBuilder(Logical value, int length2) {
        return new Builder(value, length2);
    }

    public static class Builder
    extends AbstractAtomicVector.AbstractAtomicBuilder {
        private LogicalVector vector;
        private int length = 1;
        private int each = 1;

        public Builder(Logical value, int length2) {
            switch (value) {
                case TRUE: {
                    this.vector = LogicalVector.TRUE;
                    break;
                }
                case FALSE: {
                    this.vector = LogicalVector.FALSE;
                    break;
                }
                default: {
                    this.vector = LogicalVector.NA_VECTOR;
                }
            }
            this.length = length2;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public LogicalVector build() {
            return new RepLogicalVector(this.vector, this.length, this.each, this.buildAttributes());
        }

        @Override
        public Builder setNA(int index) {
            throw new EvalException("cannot set na on constant builder", new Object[0]);
        }

        public Builder setFrom(int destinationIndex, Vector source, int sourceIndex) {
            throw new EvalException("cannot set from on constant builder", new Object[0]);
        }

        @Override
        public Builder add(Number value) {
            throw new EvalException("cannot add something to constant builder", new Object[0]);
        }
    }
}

