/*
 * Decompiled with CFR 0.152.
 */
package Bug_Submitter;

import Bug_Submitter.SubmissionResult;
import ij.IJ;
import ij.plugin.PlugIn;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.UpToDate;
import net.imagej.updater.util.Progress;
import net.imagej.updater.util.StderrProgress;

public class Bug_Submitter
implements PlugIn {
    final String bugzillaBaseURI = "http://fiji.sc/bugzilla/";
    static final int SUCCESS = 1;
    static final int LOGIN_FAILURE = 2;
    static final int OTHER_FAILURE = 3;
    static final int CC_UNKNOWN_FAILURE = 4;
    static final int IOEXCEPTION_FAILURE = 5;
    String usernamePreferenceKey = "Bug_Submitter.username";
    String passwordPreferenceKey = "Bug_Submitter.password";

    public String e(String original) {
        try {
            return URLEncoder.encode(original, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            IJ.error((String)("UnsupportedEncodingException (!): " + e));
            return null;
        }
    }

    public static String rot13(String s) {
        int n = s.length();
        char[] originalChars = s.toCharArray();
        char[] newChars = new char[n];
        for (int i = 0; i < n; ++i) {
            char c = originalChars[i];
            if (c >= 'a' && c <= 'm' || c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z' || c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            newChars[i] = c;
        }
        return new String(newChars);
    }

    public String getUsefulSystemInformation() {
        String[] interestingProperties = new String[]{"os.arch", "os.name", "os.version", "java.version", "java.vendor", "java.runtime.name", "java.runtime.version", "java.vm.name", "java.vm.version", "java.vm.vendor", "java.vm.info", "java.awt.graphicsenv", "java.specification.name", "java.specification.version", "sun.cpu.endian", "sun.desktop", "file.separator"};
        StringBuffer result = new StringBuffer();
        for (String k : interestingProperties) {
            result.append("  ");
            result.append(k);
            result.append(" => ");
            String value = System.getProperty(k);
            result.append(value == null ? "null" : value);
            result.append("\n");
        }
        return result.toString();
    }

    protected String getPathInformation() {
        StringBuffer sb = new StringBuffer();
        sb.append("  JAVA_HOME is set to: ");
        sb.append(System.getenv("JAVA_HOME"));
        sb.append("\n  imagej.dir => ");
        sb.append(System.getProperty("imagej.dir"));
        return sb.toString();
    }

    public SubmissionResult submitBug(String submitterEmail, String submitterBugzillaPassword, String bugSubject, String bugText) {
        String bugComponent = "Plugins";
        Pattern cookiePattern = Pattern.compile("^(\\w+)=(\\w+);.*$");
        Pattern tokenPattern = Pattern.compile(".*<input [^>]*name=\"token\" value=\"([^\"]*)\".*");
        Pattern linuxPattern = Pattern.compile("^Linux.*$", 2);
        Pattern windowsPattern = Pattern.compile("^Windows.*$", 2);
        Pattern macPattern = Pattern.compile("^Mac ?OS.*$", 2);
        Pattern badAuthentication = Pattern.compile("^.*username or password you entered is not valid.*$");
        StringBuffer submissionReply = new StringBuffer();
        StringBuffer authenticationReply = new StringBuffer();
        try {
            URL url = new URL("http://fiji.sc/bugzilla/enter_bug.cgi");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestMethod("POST");
            PrintStream ps = new PrintStream(connection.getOutputStream());
            ps.println("Bugzilla_login=" + this.e(submitterEmail) + "&Bugzilla_password=" + this.e(submitterBugzillaPassword) + "&classification=__all&GoAheadAndLogIn=" + this.e("Log in") + "&product=Fiji");
            ps.close();
            HashMap<String, String> cookies = new HashMap<String, String>();
            Map<String, List<String>> headers = connection.getHeaderFields();
            List<String> setCookiesFields = headers.get("Set-Cookie");
            if (setCookiesFields != null) {
                for (String s : setCookiesFields) {
                    Matcher cookieMatcher = cookiePattern.matcher(s);
                    if (!cookieMatcher.matches()) continue;
                    String key = cookieMatcher.group(1);
                    String value = cookieMatcher.group(2);
                    cookies.put(key, value);
                }
            }
            if (cookies.size() == 0) {
                return new SubmissionResult(2, -1, null, authenticationReply.toString(), submissionReply.toString());
            }
            InputStream is = connection.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            boolean authenticationFailed = false;
            String token = "";
            while ((line = br.readLine()) != null) {
                authenticationReply.append(line).append("\n");
                if (badAuthentication.matcher(line).matches()) {
                    authenticationFailed = true;
                }
                Matcher tokenMatcher = tokenPattern.matcher(line);
                if (!"".equals(token) || !tokenMatcher.matches()) continue;
                token = tokenMatcher.group(1);
            }
            if (authenticationFailed) {
                return new SubmissionResult(2, -1, null, authenticationReply.toString(), submissionReply.toString());
            }
            if (token.isEmpty()) {
                IJ.error((String)"No session token discovered after authentication. This version of Bug Submitter is not compatible with the current configuration of BugZilla.");
                return new SubmissionResult(3, -1, null, authenticationReply.toString(), submissionReply.toString());
            }
            String ccString = "";
            if (submitterEmail != null && submitterEmail.trim().length() > 0) {
                ccString = "&cc=" + this.e(submitterEmail.trim());
            }
            url = new URL("http://fiji.sc/bugzilla/post_bug.cgi");
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestMethod("POST");
            boolean firstCookie = true;
            String cookieValueToSend = "";
            for (String cookieKey : cookies.keySet()) {
                String value = (String)cookies.get(cookieKey);
                if (firstCookie) {
                    firstCookie = false;
                    cookieValueToSend = cookieValueToSend + cookieKey + "=" + value;
                    continue;
                }
                cookieValueToSend = cookieValueToSend + "; " + cookieKey + "=" + value;
            }
            connection.setRequestProperty("Cookie", cookieValueToSend);
            String osParameterValue = null;
            String platformParameterValue = null;
            String osName = System.getProperty("os.name");
            if (linuxPattern.matcher(osName).matches()) {
                osParameterValue = "Linux";
                platformParameterValue = "PC";
            } else if (windowsPattern.matcher(osName).matches()) {
                osParameterValue = "Windows";
                platformParameterValue = "PC";
            } else if (macPattern.matcher(osName).matches()) {
                osParameterValue = "Mac OS";
                platformParameterValue = "Macintosh";
            } else {
                osParameterValue = "Other";
                platformParameterValue = "Other";
            }
            ps = new PrintStream(connection.getOutputStream());
            ps.println("product=Fiji&token=" + this.e(token) + "&component=" + this.e(bugComponent) + "&rep_platform=" + this.e(platformParameterValue) + "&op_sys=" + this.e(osParameterValue) + "&priority=P4&bug_severity=normal&target_milestone=" + this.e("---") + "&version=unspecified&bug_file_loc=" + this.e("http://") + "&bug_status=NEW&assigned_to=" + ccString + "&estimated_time=&deadline=&short_desc=" + this.e(bugSubject) + "&comment=" + this.e(bugText) + "&commentprivacy=0&dependson=&blocked=&hidden=enter_bug");
            ps.close();
            Pattern successfullySubmitted = Pattern.compile("^.*Bug\\s+(\\d+)\\s+Submitted.*$", 2);
            Pattern ccEmailUnknown = Pattern.compile("^.*did not match anything.*$");
            int bugNumber = -1;
            boolean unknownCC = false;
            is = connection.getInputStream();
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                submissionReply.append(line).append("\n");
                Matcher submittedMatcher = successfullySubmitted.matcher(line);
                if (submittedMatcher.matches()) {
                    bugNumber = Integer.parseInt(submittedMatcher.group(1), 10);
                    continue;
                }
                if (!ccEmailUnknown.matcher(line).matches()) continue;
                unknownCC = true;
            }
            if (unknownCC) {
                IJ.error((String)("Your email address (" + submitterEmail + ") didn't match a Bugzilla account.\nEither create an account for that email address, which is the\nrecommended option, or leave the email field blank."));
                return new SubmissionResult(4, -1, null, authenticationReply.toString(), submissionReply.toString());
            }
            if (bugNumber < 1) {
                return new SubmissionResult(3, -1, null, authenticationReply.toString(), submissionReply.toString());
            }
            return new SubmissionResult(1, bugNumber, "http://fiji.sc/bugzilla/show_bug.cgi?id=" + bugNumber, authenticationReply.toString(), submissionReply.toString());
        }
        catch (IOException e) {
            System.out.println("Got an IOException: " + e);
            e.printStackTrace();
            return new SubmissionResult(5, -1, null, authenticationReply.toString(), submissionReply.toString());
        }
    }

    public void run(String ignore) {
        IJ.showMessage((String)"Bug Submitter Temporarily Unavailable", (String)"<html>This functionality is currently undergoing a redesign.<br />If you need immediate assistance please see the ImageJ Help resources at:<ul><li><a href=\"http://imagej.net/Help\">http://imagej.net/Help</a></li></ul>");
    }

    public static void addAccelerator(final Component source, JComponent container, final ActionListener listener, int key, int modifiers) {
        container.getInputMap(2).put(KeyStroke.getKeyStroke(key, modifiers), source);
        if (container.getActionMap().get(source) != null) {
            return;
        }
        container.getActionMap().put(source, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!source.isEnabled()) {
                    return;
                }
                ActionEvent event = new ActionEvent(source, 0, "Accelerator");
                listener.actionPerformed(event);
            }
        });
    }

    private class LegacyUpdater {
        private LegacyUpdater() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Information about your version of Java:\n\n");
            builder.append(Bug_Submitter.this.getUsefulSystemInformation());
            builder.append("\nThe up-to-date check says: ");
            ClassLoader loader = this.getClass().getClassLoader();
            try {
                Class<?> upToDateClass = loader.loadClass("imagej.updater.core.UpToDate");
                Method check = upToDateClass.getMethod("check", new Class[0]);
                builder.append(check.invoke(null, new Object[0]).toString());
            }
            catch (Throwable e) {
                builder.append(e.getMessage());
            }
            builder.append("\n\nInformation relevant to JAVA_HOME related problems:\n\n");
            builder.append(Bug_Submitter.this.getPathInformation());
            builder.append("\n\nInformation about the version of each plugin:\n\n");
            try {
                Class<?> filesCollectionClass = loader.loadClass("imagej.updater.core.FilesCollection");
                Class<?> progressClass = loader.loadClass("imagej.updater.util.Progress");
                Method getInstalledVersions = filesCollectionClass.getMethod("getInstalledVersions", File.class, progressClass);
                String ijDir = System.getProperty("imagej.dir");
                if (ijDir == null) {
                    ijDir = System.getProperty("ij.dir");
                }
                builder.append(getInstalledVersions.invoke(null, new File(ijDir), null).toString());
            }
            catch (Throwable e) {
                builder.append(e.getMessage());
            }
            return builder.toString();
        }
    }

    private class ModernUpdater {
        private ModernUpdater() {
        }

        public String toString() {
            String check;
            try {
                check = UpToDate.check().toString();
            }
            catch (Exception e) {
                check = e.getMessage();
            }
            StderrProgress progress = new StderrProgress();
            String ijDirProperty = System.getProperty("imagej.dir");
            if (ijDirProperty == null) {
                ijDirProperty = System.getProperty("ij.dir");
            }
            return "Information about your version of Java:\n\n" + Bug_Submitter.this.getUsefulSystemInformation() + "\nThe up-to-date check says: " + check + "\n\nInformation relevant to JAVA_HOME related problems:\n\n" + Bug_Submitter.this.getPathInformation() + "\n\nInformation about the version of each plugin:\n\n" + FilesCollection.getInstalledVersions((File)new File(ijDirProperty), (Progress)progress);
        }
    }
}

