/*
 * Decompiled with CFR 0.152.
 */
package preview.net.imglib2.algorithm.neighborhood;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessible;
import net.imglib2.Sampler;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import preview.net.imglib2.algorithm.neighborhood.NeighborhoodFactory;

public abstract class NeighborhoodLocalizableSampler<T>
extends AbstractEuclideanSpace
implements Localizable,
Sampler<Neighborhood<T>> {
    private final RandomAccessible<T> source;
    private final Interval sourceInterval;
    private final NeighborhoodFactory neighborhoodFactory;
    private final Neighborhood<T> currentNeighborhood;
    protected final long[] currentPos;

    public NeighborhoodLocalizableSampler(RandomAccessible<T> source, NeighborhoodFactory factory, Interval accessInterval) {
        super(source.numDimensions());
        this.source = source;
        this.neighborhoodFactory = factory;
        this.currentPos = new long[this.n];
        if (accessInterval == null && source instanceof Interval) {
            accessInterval = (Interval)source;
        }
        if (accessInterval == null) {
            this.sourceInterval = null;
        } else {
            long[] accessMin = new long[this.n];
            long[] accessMax = new long[this.n];
            Interval boundingBox = this.neighborhoodFactory.create(new long[this.n], source.randomAccess()).getStructuringElementBoundingBox();
            accessInterval.min(accessMin);
            accessInterval.max(accessMax);
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                accessMin[n] = accessMin[n] + boundingBox.min(d);
                int n2 = d;
                accessMax[n2] = accessMax[n2] + boundingBox.max(d);
            }
            this.sourceInterval = new FinalInterval(accessMin, accessMax);
        }
        this.currentNeighborhood = this.neighborhoodFactory.create(this.currentPos, this.sourceInterval == null ? source.randomAccess() : source.randomAccess(this.sourceInterval));
    }

    protected NeighborhoodLocalizableSampler(NeighborhoodLocalizableSampler<T> c) {
        super(c.n);
        this.source = c.source;
        this.sourceInterval = c.sourceInterval;
        this.neighborhoodFactory = c.neighborhoodFactory;
        this.currentPos = (long[])c.currentPos.clone();
        this.currentNeighborhood = this.neighborhoodFactory.create(this.currentPos, this.sourceInterval == null ? this.source.randomAccess() : this.source.randomAccess(this.sourceInterval));
    }

    public Neighborhood<T> get() {
        return this.currentNeighborhood;
    }

    public void localize(int[] position) {
        this.currentNeighborhood.localize(position);
    }

    public void localize(long[] position) {
        this.currentNeighborhood.localize(position);
    }

    public int getIntPosition(int d) {
        return this.currentNeighborhood.getIntPosition(d);
    }

    public long getLongPosition(int d) {
        return this.currentNeighborhood.getLongPosition(d);
    }

    public void localize(float[] position) {
        this.currentNeighborhood.localize(position);
    }

    public void localize(double[] position) {
        this.currentNeighborhood.localize(position);
    }

    public float getFloatPosition(int d) {
        return this.currentNeighborhood.getFloatPosition(d);
    }

    public double getDoublePosition(int d) {
        return this.currentNeighborhood.getDoublePosition(d);
    }
}

