/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.detection.ThresholdDetector;
import fiji.plugin.trackmate.detection.ThresholdDetectorFactory;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.detector.MaskDetectorConfigurationPanel;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.HashMap;
import java.util.Map;
import net.imagej.ImgPlus;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotDetectorFactory.class)
public class MaskDetectorFactory<T extends RealType<T> & NativeType<T>>
extends ThresholdDetectorFactory<T> {
    public static final String DETECTOR_KEY = "MASK_DETECTOR";
    public static final String NAME = "Mask detector";
    public static final String INFO_TEXT = "<html>This detector creates spots from a black and white mask.<p>More precisely, all the pixels in the designated channel that have a value strictly larger than 0 are considered as part of the foreground, and used to build connected regions. In 2D, spots are created with the (possibly simplified) contour of the region. In 3D, a spherical spot is created for each region in its center, with a volume equal to the region volume.<p>The spot quality stores the object area or volume in pixels.</html>";
    public static final String URL_DOC = "https://imagej.net/plugins/trackmate/detectors/trackmate-mask-detector";

    @Override
    public boolean has2Dsegmentation() {
        return true;
    }

    @Override
    public SpotDetector<T> getDetector(ImgPlus<T> img, Map<String, Object> settings, Interval interval, int frame) {
        double intensityThreshold = 0.0;
        boolean simplifyContours = (Boolean)settings.get("SIMPLIFY_CONTOURS");
        double[] calibration = TMUtils.getSpatialCalibration(img);
        int channel = (Integer)settings.get("TARGET_CHANNEL") - 1;
        RandomAccessibleInterval<T> imFrame = DetectionUtils.prepareFrameImg(img, channel, frame);
        ThresholdDetector<T> detector = new ThresholdDetector<T>(imFrame, interval, calibration, 0.0, simplifyContours);
        detector.setNumThreads(1);
        return detector;
    }

    @Override
    public String getKey() {
        return DETECTOR_KEY;
    }

    @Override
    public ConfigurationPanel getDetectorConfigurationPanel(Settings lSettings, Model model) {
        return new MaskDetectorConfigurationPanel(lSettings, model);
    }

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getUrl() {
        return URL_DOC;
    }

    @Override
    public Map<String, Object> getDefaultSettings() {
        HashMap<String, Object> lSettings = new HashMap<String, Object>();
        lSettings.put("TARGET_CHANNEL", 1);
        lSettings.put("SIMPLIFY_CONTOURS", true);
        return lSettings;
    }
}

