/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components;

import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.features.EdgeFeatureGrapher;
import fiji.plugin.trackmate.features.FeatureUtils;
import fiji.plugin.trackmate.features.SpotFeatureGrapher;
import fiji.plugin.trackmate.features.TrackFeatureGrapher;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.components.FeaturePlotSelectionPanel;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.util.EverythingDisablerAndReenabler;
import fiji.plugin.trackmate.util.Threads;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.jgrapht.graph.DefaultWeightedEdge;

public class GrapherPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final TrackMate trackmate;
    private final JPanel panelSpot;
    private final JPanel panelEdges;
    private final JPanel panelTracks;
    private final FeaturePlotSelectionPanel spotFeatureSelectionPanel;
    private final FeaturePlotSelectionPanel edgeFeatureSelectionPanel;
    private final FeaturePlotSelectionPanel trackFeatureSelectionPanel;
    private final DisplaySettings displaySettings;
    private final SelectionModel selectionModel;
    private final JPanel panelSelection;
    private final JRadioButton rdbtnAll;
    private final JRadioButton rdbtnSelection;
    private final JRadioButton rdbtnTracks;
    private final JCheckBox chkboxConnectDots;

    public GrapherPanel(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings) {
        this.trackmate = trackmate;
        this.selectionModel = selectionModel;
        this.displaySettings = displaySettings;
        this.setLayout(new BorderLayout(0, 0));
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.add((Component)tabbedPane, "Center");
        this.panelSpot = new JPanel();
        tabbedPane.addTab("Spots", Icons.SPOT_ICON_64x64, this.panelSpot, null);
        this.panelSpot.setLayout(new BorderLayout(0, 0));
        this.panelEdges = new JPanel();
        tabbedPane.addTab("Links", Icons.EDGE_ICON_64x64, this.panelEdges, null);
        this.panelEdges.setLayout(new BorderLayout(0, 0));
        this.panelTracks = new JPanel();
        tabbedPane.addTab("Tracks", Icons.TRACK_ICON_64x64, this.panelTracks, null);
        this.panelTracks.setLayout(new BorderLayout(0, 0));
        Map<String, String> spotFeatureNames = FeatureUtils.collectFeatureKeys(DisplaySettings.TrackMateObject.SPOTS, trackmate.getModel(), trackmate.getSettings());
        Set<String> spotFeatures = spotFeatureNames.keySet();
        this.spotFeatureSelectionPanel = new FeaturePlotSelectionPanel("T", "Mean intensity ch1", spotFeatures, spotFeatureNames, (xKey, yKeys) -> Threads.run(() -> this.plotSpotFeatures(xKey, yKeys)));
        this.panelSpot.add(this.spotFeatureSelectionPanel);
        this.panelEdges.removeAll();
        Map<String, String> edgeFeatureNames = FeatureUtils.collectFeatureKeys(DisplaySettings.TrackMateObject.EDGES, trackmate.getModel(), trackmate.getSettings());
        Set<String> edgeFeatures = edgeFeatureNames.keySet();
        this.edgeFeatureSelectionPanel = new FeaturePlotSelectionPanel("Edge time", "Speed", edgeFeatures, edgeFeatureNames, (xKey, yKeys) -> Threads.run(() -> this.plotEdgeFeatures(xKey, yKeys)));
        this.panelEdges.add(this.edgeFeatureSelectionPanel);
        this.panelTracks.removeAll();
        Map<String, String> trackFeatureNames = FeatureUtils.collectFeatureKeys(DisplaySettings.TrackMateObject.TRACKS, trackmate.getModel(), trackmate.getSettings());
        Set<String> trackFeatures = trackFeatureNames.keySet();
        this.trackFeatureSelectionPanel = new FeaturePlotSelectionPanel("Track index", "Number of spots in track", trackFeatures, trackFeatureNames, (xKey, yKeys) -> Threads.run(() -> this.plotTrackFeatures(xKey, yKeys)));
        this.panelTracks.add(this.trackFeatureSelectionPanel);
        this.panelSelection = new JPanel();
        this.panelSelection.setLayout(new BoxLayout(this.panelSelection, 2));
        this.add((Component)this.panelSelection, "South");
        this.rdbtnAll = new JRadioButton("All");
        this.rdbtnAll.setFont(this.rdbtnAll.getFont().deriveFont((float)this.rdbtnAll.getFont().getSize() - 2.0f));
        this.panelSelection.add(this.rdbtnAll);
        this.rdbtnSelection = new JRadioButton("Selection");
        this.rdbtnSelection.setFont(this.rdbtnSelection.getFont().deriveFont((float)this.rdbtnSelection.getFont().getSize() - 2.0f));
        this.panelSelection.add(this.rdbtnSelection);
        this.rdbtnTracks = new JRadioButton("Tracks of selection");
        this.rdbtnTracks.setFont(this.rdbtnTracks.getFont().deriveFont((float)this.rdbtnTracks.getFont().getSize() - 2.0f));
        this.panelSelection.add(this.rdbtnTracks);
        ButtonGroup btngrp = new ButtonGroup();
        btngrp.add(this.rdbtnAll);
        btngrp.add(this.rdbtnSelection);
        btngrp.add(this.rdbtnTracks);
        this.rdbtnAll.setSelected(true);
        this.panelSelection.add(new JSeparator(1));
        this.chkboxConnectDots = new JCheckBox("Connect");
        this.chkboxConnectDots.setFont(this.chkboxConnectDots.getFont().deriveFont((float)this.chkboxConnectDots.getFont().getSize() - 2.0f));
        this.chkboxConnectDots.setSelected(true);
        this.panelSelection.add(this.chkboxConnectDots);
    }

    public FeaturePlotSelectionPanel getSpotFeatureSelectionPanel() {
        return this.spotFeatureSelectionPanel;
    }

    public FeaturePlotSelectionPanel getEdgeFeatureSelectionPanel() {
        return this.edgeFeatureSelectionPanel;
    }

    public FeaturePlotSelectionPanel getTrackFeatureSelectionPanel() {
        return this.trackFeatureSelectionPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void plotSpotFeatures(String xFeature, List<String> yFeatures) {
        EverythingDisablerAndReenabler enabler = new EverythingDisablerAndReenabler(this, new Class[]{JLabel.class});
        enabler.disable();
        try {
            ArrayList<Object> spots;
            if (this.rdbtnAll.isSelected()) {
                spots = new ArrayList(this.trackmate.getModel().getSpots().getNSpots(true));
                for (Integer trackID : this.trackmate.getModel().getTrackModel().trackIDs(true)) {
                    spots.addAll(this.trackmate.getModel().getTrackModel().trackSpots(trackID));
                }
            } else if (this.rdbtnSelection.isSelected()) {
                spots = new ArrayList<Spot>(this.selectionModel.getSpotSelection());
            } else {
                this.selectionModel.selectTrack(this.selectionModel.getSpotSelection(), this.selectionModel.getEdgeSelection(), 0);
                spots = new ArrayList<Spot>(this.selectionModel.getSpotSelection());
            }
            boolean addLines = this.chkboxConnectDots.isSelected();
            SpotFeatureGrapher grapher = new SpotFeatureGrapher(spots, xFeature, yFeatures, this.trackmate.getModel(), this.selectionModel, this.displaySettings, addLines);
            JFrame frame = grapher.render();
            frame.setIconImage(Icons.PLOT_ICON.getImage());
            frame.setTitle(this.trackmate.getSettings().imp.getShortTitle() + " spot features");
            GuiUtils.positionWindow(frame, SwingUtilities.getWindowAncestor(this));
            frame.setVisible(true);
        }
        finally {
            enabler.reenable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void plotEdgeFeatures(String xFeature, List<String> yFeatures) {
        EverythingDisablerAndReenabler enabler = new EverythingDisablerAndReenabler(this, new Class[]{JLabel.class});
        enabler.disable();
        try {
            ArrayList<Object> edges;
            if (this.rdbtnAll.isSelected()) {
                edges = new ArrayList();
                for (Integer trackID : this.trackmate.getModel().getTrackModel().trackIDs(true)) {
                    edges.addAll(this.trackmate.getModel().getTrackModel().trackEdges(trackID));
                }
            } else if (this.rdbtnSelection.isSelected()) {
                edges = new ArrayList<DefaultWeightedEdge>(this.selectionModel.getEdgeSelection());
            } else {
                this.selectionModel.selectTrack(this.selectionModel.getSpotSelection(), this.selectionModel.getEdgeSelection(), 0);
                edges = new ArrayList<DefaultWeightedEdge>(this.selectionModel.getEdgeSelection());
            }
            boolean addLines = this.chkboxConnectDots.isSelected();
            EdgeFeatureGrapher grapher = new EdgeFeatureGrapher(edges, xFeature, yFeatures, this.trackmate.getModel(), this.selectionModel, this.displaySettings, addLines);
            JFrame frame = grapher.render();
            frame.setIconImage(Icons.PLOT_ICON.getImage());
            frame.setTitle(this.trackmate.getSettings().imp.getShortTitle() + " edge features");
            GuiUtils.positionWindow(frame, SwingUtilities.getWindowAncestor(this));
            frame.setVisible(true);
            this.edgeFeatureSelectionPanel.setEnabled(true);
        }
        finally {
            enabler.reenable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void plotTrackFeatures(String xFeature, List<String> yFeatures) {
        EverythingDisablerAndReenabler enabler = new EverythingDisablerAndReenabler(this, new Class[]{JLabel.class});
        enabler.disable();
        try {
            ArrayList<Integer> trackIDs;
            if (this.rdbtnAll.isSelected()) {
                trackIDs = new ArrayList<Integer>(this.trackmate.getModel().getTrackModel().unsortedTrackIDs(true));
            } else {
                HashSet<Integer> set = new HashSet<Integer>();
                for (Spot spot : this.selectionModel.getSpotSelection()) {
                    set.add(this.trackmate.getModel().getTrackModel().trackIDOf(spot));
                }
                for (DefaultWeightedEdge edge : this.selectionModel.getEdgeSelection()) {
                    set.add(this.trackmate.getModel().getTrackModel().trackIDOf(edge));
                }
                trackIDs = new ArrayList(set);
            }
            TrackFeatureGrapher grapher = new TrackFeatureGrapher(trackIDs, xFeature, yFeatures, this.trackmate.getModel(), this.selectionModel, this.displaySettings);
            JFrame frame = grapher.render();
            frame.setIconImage(Icons.PLOT_ICON.getImage());
            frame.setTitle(this.trackmate.getSettings().imp.getShortTitle() + " track features");
            GuiUtils.positionWindow(frame, SwingUtilities.getWindowAncestor(this));
            frame.setVisible(true);
        }
        finally {
            enabler.reenable();
        }
    }
}

