/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard.descriptors;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.TrackMatePlugIn;
import fiji.plugin.trackmate.gui.components.LogPanel;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.wizard.WizardPanelDescriptor;
import fiji.plugin.trackmate.gui.wizard.WizardSequence;
import fiji.plugin.trackmate.io.IOUtils;
import fiji.plugin.trackmate.io.TmXmlWriter;
import fiji.plugin.trackmate.util.TMUtils;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.SwingUtilities;

public class SaveDescriptor
extends WizardPanelDescriptor {
    private static final String KEY = "Saving";
    private final TrackMate trackmate;
    private final DisplaySettings displaySettings;
    private final WizardSequence sequence;

    public SaveDescriptor(TrackMate trackmate, DisplaySettings displaySettings, WizardSequence sequence) {
        super(KEY);
        this.targetPanel = sequence.logDescriptor().getPanelComponent();
        this.trackmate = trackmate;
        this.displaySettings = displaySettings;
        this.sequence = sequence;
    }

    @Override
    public void displayingPanel() {
        LogPanel logPanel = (LogPanel)this.targetPanel;
        Logger logger = logPanel.getLogger();
        logger.log("Saving data...\n", Logger.BLUE_COLOR);
        File file = TrackMatePlugIn.lastLoadedFile != null && TrackMatePlugIn.lastLoadedFile.exists() ? TrackMatePlugIn.lastLoadedFile : TMUtils.proposeTrackMateSaveFile(this.trackmate.getSettings(), logger);
        if (this.trackmate.getModel().getTrackModel().nTracks(false) > 0) {
            this.trackmate.computeEdgeFeatures(true);
            this.trackmate.computeTrackFeatures(true);
        }
        if ((file = IOUtils.askForFileForSaving(file, (Frame)SwingUtilities.getWindowAncestor(logPanel))) == null) {
            logger.log("Saving aborted.\n");
            return;
        }
        TrackMatePlugIn.lastLoadedFile = file;
        TmXmlWriter writer = new TmXmlWriter(file, logger);
        writer.appendLog(logPanel.getTextContent());
        writer.appendModel(this.trackmate.getModel());
        writer.appendSettings(this.trackmate.getSettings());
        writer.appendGUIState(this.sequence.current().getPanelDescriptorIdentifier());
        writer.appendDisplaySettings(this.displaySettings);
        try {
            writer.writeToFile();
            logger.log("Data saved to: " + file.toString() + '\n');
        }
        catch (FileNotFoundException e) {
            logger.error("File not found:\n" + e.getMessage() + '\n');
            return;
        }
        catch (IOException e) {
            logger.error("Input/Output error:\n" + e.getMessage() + '\n');
            return;
        }
    }
}

