/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import java.util.Arrays;
import java.util.Comparator;

public class AlphanumComparator {
    private static final Comparator<Object> raw = Comparator.comparingInt(s -> {
        try {
            return Integer.parseInt(((String)s).replaceAll("\\D", ""));
        }
        catch (NumberFormatException nfe) {
            return Integer.MIN_VALUE;
        }
    }).thenComparing(s -> ((String)s).replaceAll("\\d", ""));
    public static final Comparator<String> instance = raw;

    private AlphanumComparator() {
    }

    public static void main(String[] args) {
        String[] names = new String[]{"Track_0", "track_11", "track_2", "track_3", "track_4", "track_5", "track_6", "", "a"};
        Arrays.sort(names, instance);
        Arrays.stream(names).forEach(System.out::println);
    }
}

