/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

public class OnRequestUpdater
extends Thread {
    private long request = 0L;
    private final Refreshable refreshable;

    public OnRequestUpdater(Refreshable refreshable) {
        super("OnRequestUpdater for " + refreshable.toString());
        this.refreshable = refreshable;
        this.setPriority(5);
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdate() {
        if (this.isInterrupted()) {
            return;
        }
        OnRequestUpdater onRequestUpdater = this;
        synchronized (onRequestUpdater) {
            ++this.request;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        this.interrupt();
        OnRequestUpdater onRequestUpdater = this;
        synchronized (onRequestUpdater) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                long r;
                OnRequestUpdater onRequestUpdater = this;
                synchronized (onRequestUpdater) {
                    r = this.request;
                }
                if (r > 0L) {
                    this.refreshable.refresh();
                }
                onRequestUpdater = this;
                synchronized (onRequestUpdater) {
                    if (r == this.request) {
                        this.request = 0L;
                        this.wait();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface Refreshable {
        public void refresh();
    }
}

