/*
 * Decompiled with CFR 0.152.
 */
package bdv.gui;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ImprovedFormattedTextField
extends JFormattedTextField {
    private static final Color ERROR_BACKGROUND_COLOR = new Color(255, 215, 215);
    private static final Color ERROR_FOREGROUND_COLOR = null;
    private Color fBackground;
    private Color fForeground;
    private Runnable updateCallback;
    private boolean runCallback = true;

    public ImprovedFormattedTextField(Format aFormat) {
        super(new ParseAllFormat(aFormat));
        this.setFocusLostBehavior(1);
        this.updateBackgroundOnEachUpdate();
        this.addFocusListener(new MousePositionCorrectorListener());
    }

    public ImprovedFormattedTextField(Format aFormat, Object aValue) {
        this(aFormat);
        this.setValue(aValue);
    }

    public void setCallback(Runnable updateCallback) {
        this.updateCallback = updateCallback;
    }

    private void updateBackgroundOnEachUpdate() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImprovedFormattedTextField.this.updateBackground();
                if (ImprovedFormattedTextField.this.runCallback && ImprovedFormattedTextField.this.updateCallback != null) {
                    ImprovedFormattedTextField.this.updateCallback.run();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImprovedFormattedTextField.this.updateBackground();
                if (ImprovedFormattedTextField.this.runCallback && ImprovedFormattedTextField.this.updateCallback != null) {
                    ImprovedFormattedTextField.this.updateCallback.run();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ImprovedFormattedTextField.this.updateBackground();
                if (ImprovedFormattedTextField.this.runCallback && ImprovedFormattedTextField.this.updateCallback != null) {
                    ImprovedFormattedTextField.this.updateCallback.run();
                }
            }
        });
    }

    private void updateBackground() {
        boolean valid = this.validContent();
        if (ERROR_BACKGROUND_COLOR != null) {
            this.setBackground(valid ? this.fBackground : ERROR_BACKGROUND_COLOR);
        }
        if (ERROR_FOREGROUND_COLOR != null) {
            this.setForeground(valid ? this.fForeground : ERROR_FOREGROUND_COLOR);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.fBackground = this.getBackground();
        this.fForeground = this.getForeground();
    }

    private boolean validContent() {
        JFormattedTextField.AbstractFormatter formatter = this.getFormatter();
        if (formatter != null) {
            try {
                formatter.stringToValue(this.getText());
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }
        return true;
    }

    public void setValue(Object value, boolean callback) {
        boolean validValue = true;
        try {
            JFormattedTextField.AbstractFormatter formatter = this.getFormatter();
            if (formatter != null) {
                formatter.valueToString(value);
            }
        }
        catch (ParseException e) {
            validValue = false;
            this.updateBackground();
        }
        if (validValue) {
            int old_caret_position = this.getCaretPosition();
            boolean before = this.runCallback;
            this.runCallback = callback;
            super.setValue(value);
            this.runCallback = before;
            this.setCaretPosition(Math.min(old_caret_position, this.getText().length()));
        }
    }

    public void setValueNoCallback(Object value) {
        this.setValue(value, false);
    }

    @Override
    public void setValue(Object value) {
        this.setValue(value, true);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (this.validContent()) {
            return super.processKeyBinding(ks, e, condition, pressed) && ks != KeyStroke.getKeyStroke(10, 0);
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public static class ParseAllFormat
    extends Format {
        private final Format fDelegate;

        public ParseAllFormat(Format aDelegate) {
            this.fDelegate = aDelegate;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return this.fDelegate.format(obj, toAppendTo, pos);
        }

        @Override
        public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
            return this.fDelegate.formatToCharacterIterator(obj);
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            int initialIndex = pos.getIndex();
            if (this.fDelegate == null) {
                return source;
            }
            Object result = this.fDelegate.parseObject(source, pos);
            if (result != null && pos.getIndex() < source.length()) {
                int errorIndex = pos.getIndex();
                pos.setIndex(initialIndex);
                pos.setErrorIndex(errorIndex);
                return null;
            }
            return result;
        }

        @Override
        public Object parseObject(String source) throws ParseException {
            return super.parseObject(source);
        }
    }

    private static class MousePositionCorrectorListener
    extends FocusAdapter {
        private MousePositionCorrectorListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            final JTextField field = (JTextField)e.getSource();
            final int dot = field.getCaret().getDot();
            final int mark = field.getCaret().getMark();
            if (field.isEnabled() && field.isEditable()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (dot == mark) {
                            field.getCaret().setDot(dot);
                        }
                    }
                });
            }
        }
    }
}

