/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.source;

import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bigwarp.BigWarpData;
import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.source.JacobianDeterminantRandomAccess;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.BoundingBoxEstimation;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.inverse.DifferentiableRealTransform;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class JacobianDeterminantSource<T extends RealType<T>>
implements Source<T> {
    protected final String name;
    protected final BigWarpData<?> sourceData;
    protected final Interval interval;
    protected final JacobianDeterminantRandomAccess.JacobianDeterminantRandomAccessibleInterval<T> jacDetImg;
    protected final VoxelDimensions voxDims;
    protected T type;

    public JacobianDeterminantSource(String name, BigWarpData<?> data, T t) {
        this.name = name;
        this.type = t;
        this.sourceData = data;
        BoundingBoxEstimation bbe = new BoundingBoxEstimation();
        AffineTransform3D affine = new AffineTransform3D();
        data.getTargetSource(0).getSpimSource().getSourceTransform(0, 0, affine);
        this.interval = bbe.estimatePixelInterval((RealTransform)affine, (Interval)data.getTargetSource(0).getSpimSource().getSource(0, 0));
        VoxelDimensions srcVoxDims = this.sourceData.getTargetSource(0).getSpimSource().getVoxelDimensions();
        String unit = "pix";
        if (srcVoxDims != null) {
            unit = srcVoxDims.unit();
        }
        this.voxDims = new FinalVoxelDimensions(unit, new double[]{1.0, 1.0, 1.0});
        this.jacDetImg = new JacobianDeterminantRandomAccess.JacobianDeterminantRandomAccessibleInterval<T>(this.interval, t, null);
    }

    public double getMax(LandmarkTableModel lm) {
        double maxVal = 0.0;
        int ndims = lm.getNumdims();
        double[] pt = new double[ndims];
        for (Double[] movingPt : lm.getPoints(true)) {
            for (int d = 0; d < ndims; ++d) {
                pt[d] = movingPt[d];
            }
            this.jacDetImg.ra.setPosition(pt);
            double val = this.jacDetImg.ra.get().getRealDouble();
            if (!(val > maxVal)) continue;
            maxVal = val;
        }
        return maxVal;
    }

    public void setTransform(DifferentiableRealTransform transform) {
        this.jacDetImg.setTransform(transform);
    }

    @Deprecated
    public void debug(double[] pt) {
    }

    public double[] minMax() {
        double[] minmax = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
        Cursor curs = this.getSource(0, 0).cursor();
        while (curs.hasNext()) {
            double val = ((RealType)curs.next()).getRealDouble();
            if (val < minmax[0]) {
                minmax[0] = val;
                continue;
            }
            if (!(val > minmax[1])) continue;
            minmax[1] = val;
        }
        return minmax;
    }

    public boolean isPresent(int t) {
        return t == 0;
    }

    public RandomAccessibleInterval<T> getSource(int t, int level) {
        return Views.interval((RandomAccessible)Views.raster(this.getInterpolatedSource(t, level, Interpolation.NEARESTNEIGHBOR)), (Interval)this.interval);
    }

    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        return this.jacDetImg;
    }

    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        transform.identity();
    }

    public T getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public VoxelDimensions getVoxelDimensions() {
        return this.voxDims;
    }

    public int getNumMipmapLevels() {
        return 1;
    }
}

