/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.source;

import bdv.viewer.overlay.BigWarpMaskSphereOverlay;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mpicbg.spim.data.XmlHelpers;
import net.imglib2.FinalInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.position.FunctionRealRandomAccessible;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Intervals;
import org.jdom2.Content;
import org.jdom2.Element;

public class PlateauSphericalMaskRealRandomAccessible
implements RealRandomAccessible<DoubleType> {
    private transient BiConsumer<RealLocalizable, DoubleType> pfun;
    private transient FunctionRealRandomAccessible<DoubleType> rra;
    private transient List<BigWarpMaskSphereOverlay> overlays;
    private FalloffShape fallOffShape;
    private transient int nd;
    private transient double plateauR;
    @SerializedName(value="squaredRadius")
    private double plateauR2;
    private transient double sigma;
    @SerializedName(value="squaredSigma")
    private double sqrSigma;
    private transient double invSqrSigma;
    private transient double gaussInvSqrSigma;
    @JsonAdapter(value=RealPointToDoubleArray.class)
    private RealPoint center;
    private static final double EPS = 1.0E-6;
    private static final double PIon2 = 1.5707963267948966;
    private static final double PI = Math.PI;
    public static final String FALLOFF_SHAPE = "falloffShape";
    public static final String CENTER = "center";
    public static final String SQUARED_RADIUS = "squaredRadius";
    public static final String SQUARED_SIGMA = "squaredSigma";

    public PlateauSphericalMaskRealRandomAccessible(RealPoint center) {
        this.nd = center.numDimensions();
        this.center = center;
        this.fallOffShape = FalloffShape.COSINE;
        this.pfun = this.fallOffShape.createFalloffFunction(this);
        this.update();
        this.setRadius(8.0);
        this.setSigma(10.0);
    }

    public void setOverlays(List<BigWarpMaskSphereOverlay> overlays) {
        this.overlays = overlays;
        if (overlays != null) {
            overlays.stream().forEach(o -> {
                o.setCenter(this.center);
                o.setInnerRadius(this.plateauR);
                o.setOuterRadiusDelta(this.sigma);
            });
        }
    }

    public static void main(String[] args) {
        long S = 50L;
        double[] center = new double[]{50.0, 50.0, 50.0};
        RealPoint pt = RealPoint.wrap((double[])center);
        PlateauSphericalMaskRealRandomAccessible img = new PlateauSphericalMaskRealRandomAccessible(pt);
        img.setRadius(10.0);
        img.setSigma(10.0);
        FinalInterval interval = Intervals.createMinSize((long[])new long[]{0L, 0L, 0L, 100L, 100L, 100L});
        double x = 50.0;
        RealRandomAccess<DoubleType> access = img.realRandomAccess();
        access.setPosition(center);
        while (x < 100.0) {
            access.move(1, 0);
            System.out.println(x + "," + ((DoubleType)access.get()).getRealDouble());
            x = access.getDoublePosition(0);
        }
    }

    private void update() {
        this.rra = new FunctionRealRandomAccessible(this.nd, this.getFalloffFunction(), DoubleType::new);
    }

    private BiConsumer<RealLocalizable, DoubleType> getFalloffFunction() {
        if (this.pfun == null) {
            this.pfun = this.fallOffShape.createFalloffFunction(this);
        }
        return this.pfun;
    }

    public FalloffShape getFallOffShape() {
        return this.fallOffShape;
    }

    public void setFalloffShape(String type) {
        this.setFalloffShape(FalloffShape.valueOf(type));
    }

    public void setFalloffShape(FalloffShape shape) {
        this.fallOffShape = shape;
        this.pfun = shape.createFalloffFunction(this);
        this.update();
    }

    public double getSquaredRadius() {
        return this.plateauR2;
    }

    public void setRadius(double r) {
        this.plateauR = r;
        this.plateauR2 = this.plateauR * this.plateauR;
        if (this.overlays != null) {
            this.overlays.stream().forEach(o -> o.setInnerRadius(this.plateauR));
        }
    }

    public void setSquaredRadius(double r2) {
        this.plateauR2 = r2;
        this.plateauR = Math.sqrt(this.plateauR2);
        if (this.overlays != null) {
            this.overlays.stream().forEach(o -> o.setInnerRadius(this.plateauR));
        }
    }

    public double getSquaredSigma() {
        return this.sqrSigma;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma < 0.0 ? -sigma : sigma;
        this.sqrSigma = this.sigma * this.sigma;
        if (this.sqrSigma <= 0.0) {
            this.sqrSigma = 1.0E-6;
        }
        this.invSqrSigma = 1.0 / this.sqrSigma;
        this.updateGaussSigma();
        if (this.overlays != null) {
            this.overlays.stream().forEach(o -> o.setOuterRadiusDelta(this.sigma));
        }
    }

    public void setSquaredSigma(double squaredSigma) {
        this.setSigma(Math.sqrt(squaredSigma));
    }

    public void incSquaredSigma(double increment) {
        this.sqrSigma += increment;
        this.sigma = Math.sqrt(this.sqrSigma);
        if (this.sqrSigma <= 0.0) {
            this.sqrSigma = 1.0E-6;
        }
        this.invSqrSigma = 1.0 / this.sqrSigma;
        this.updateGaussSigma();
        if (this.overlays != null) {
            this.overlays.stream().forEach(o -> o.setOuterRadiusDelta(this.sigma));
        }
    }

    private void updateGaussSigma() {
        double gsig = PlateauSphericalMaskRealRandomAccessible.gaussSigma(this.sigma);
        this.gaussInvSqrSigma = 1.0 / (gsig * gsig);
    }

    public void setCenter(RealLocalizable p) {
        p.localize((RealPositionable)this.center);
        if (this.overlays != null) {
            this.overlays.stream().forEach(o -> o.setCenter(p));
        }
    }

    public void setCenter(double[] p) {
        this.center.setPosition(p);
        if (this.overlays != null) {
            this.overlays.stream().forEach(o -> o.setCenter(p));
        }
    }

    public RealPoint getCenter() {
        return this.center;
    }

    public static final double squaredDistance(RealLocalizable position1, RealLocalizable position2) {
        double dist = 0.0;
        int n = position1.numDimensions();
        for (int d = 0; d < n; ++d) {
            double pos = position2.getDoublePosition(d) - position1.getDoublePosition(d);
            dist += pos * pos;
        }
        return dist;
    }

    public int numDimensions() {
        return this.rra.numDimensions();
    }

    public RealRandomAccess<DoubleType> realRandomAccess() {
        return this.rra.realRandomAccess();
    }

    public RealRandomAccess<DoubleType> realRandomAccess(RealInterval interval) {
        return this.rra.realRandomAccess(interval);
    }

    public DoubleType getType() {
        return new DoubleType();
    }

    public Element toXml() {
        Element maskSettings = new Element("transform-mask");
        Element type = new Element("type");
        type.setText("plateau-spherical");
        maskSettings.addContent((Content)type);
        Element c = XmlHelpers.doubleArrayElement((String)CENTER, (double[])this.center.positionAsDoubleArray());
        maskSettings.addContent((Content)c);
        Element p = new Element("parameters");
        p.addContent((Content)XmlHelpers.doubleElement((String)SQUARED_RADIUS, (double)this.plateauR2));
        p.addContent((Content)XmlHelpers.doubleElement((String)SQUARED_SIGMA, (double)this.sqrSigma));
        maskSettings.addContent((Content)p);
        return maskSettings;
    }

    public void fromXml(Element elem) {
        this.setCenter(XmlHelpers.getDoubleArray((Element)elem, (String)CENTER));
        Element p = elem.getChild("parameters");
        this.setSquaredRadius(XmlHelpers.getDouble((Element)p, (String)SQUARED_RADIUS));
        this.setSquaredSigma(XmlHelpers.getDouble((Element)p, (String)SQUARED_SIGMA));
    }

    @Deprecated
    public void fromJson(JsonObject json) {
        JsonArray c = json.get(CENTER).getAsJsonArray();
        double[] center = new double[c.size()];
        for (int i = 0; i < c.size(); ++i) {
            center[i] = c.get(i).getAsDouble();
        }
        this.setCenter(center);
        this.setSquaredRadius(json.get(SQUARED_RADIUS).getAsDouble());
        this.setSquaredSigma(json.get(SQUARED_SIGMA).getAsDouble());
    }

    public static double gaussSigma(double T) {
        return 0.40535876907923957 * T + 0.03706937;
    }

    public static class RealPointToDoubleArray
    extends TypeAdapter<RealPoint> {
        public void write(JsonWriter out, RealPoint value) throws IOException {
            JsonWriter jsonWriter = out.beginArray();
            for (int i = 0; i < value.numDimensions(); ++i) {
                jsonWriter.value(value.getDoublePosition(i));
            }
            jsonWriter.endArray();
        }

        public RealPoint read(JsonReader in) throws IOException {
            in.beginArray();
            ArrayList<Double> pos = new ArrayList<Double>();
            while (in.hasNext()) {
                pos.add(in.nextDouble());
            }
            in.endArray();
            return new RealPoint(pos.stream().mapToDouble(it -> it).toArray());
        }
    }

    public static class LinearFalloff
    implements BiConsumer<RealLocalizable, DoubleType> {
        private final PlateauSphericalMaskRealRandomAccessible mask;

        public LinearFalloff(PlateauSphericalMaskRealRandomAccessible mask) {
            this.mask = mask;
        }

        @Override
        public void accept(RealLocalizable x, DoubleType v) {
            v.setZero();
            double r2 = PlateauSphericalMaskRealRandomAccessible.squaredDistance(x, (RealLocalizable)this.mask.center);
            double d2 = this.mask.plateauR + this.mask.sigma;
            if (r2 <= this.mask.plateauR2) {
                v.setOne();
            } else if (r2 >= d2 * d2) {
                v.setZero();
            } else {
                double r = Math.sqrt(r2);
                v.set(1.0 - (r - this.mask.plateauR) / this.mask.sigma);
            }
        }
    }

    public static class CosineFalloff
    implements BiConsumer<RealLocalizable, DoubleType> {
        private final PlateauSphericalMaskRealRandomAccessible mask;

        public CosineFalloff(PlateauSphericalMaskRealRandomAccessible mask) {
            this.mask = mask;
        }

        @Override
        public void accept(RealLocalizable x, DoubleType v) {
            double r2 = PlateauSphericalMaskRealRandomAccessible.squaredDistance(x, (RealLocalizable)this.mask.center);
            double r = Math.sqrt(r2);
            if (r2 <= this.mask.plateauR2) {
                v.setOne();
            } else if (r >= this.mask.plateauR + this.mask.sigma) {
                v.setZero();
            } else {
                double t = r - this.mask.plateauR;
                double val = 0.5 + 0.5 * Math.cos(t * Math.PI / this.mask.sigma);
                v.set(val);
            }
        }
    }

    public static class GaussianFalloff
    implements BiConsumer<RealLocalizable, DoubleType> {
        private final PlateauSphericalMaskRealRandomAccessible mask;

        public GaussianFalloff(PlateauSphericalMaskRealRandomAccessible mask) {
            this.mask = mask;
        }

        @Override
        public void accept(RealLocalizable x, DoubleType v) {
            v.setZero();
            double r2 = PlateauSphericalMaskRealRandomAccessible.squaredDistance(x, (RealLocalizable)this.mask.center);
            if (r2 <= this.mask.plateauR2) {
                v.setOne();
            } else {
                double r = Math.sqrt(r2);
                double t = r - this.mask.plateauR;
                v.set(Math.exp(-0.5 * t * t * this.mask.gaussInvSqrSigma));
            }
        }
    }

    public static enum FalloffShape {
        COSINE(it -> new CosineFalloff((PlateauSphericalMaskRealRandomAccessible)it)),
        GAUSSIAN(it -> new GaussianFalloff((PlateauSphericalMaskRealRandomAccessible)it)),
        LINEAR(it -> new LinearFalloff((PlateauSphericalMaskRealRandomAccessible)it));

        private final Function<PlateauSphericalMaskRealRandomAccessible, BiConsumer<RealLocalizable, DoubleType>> fallOffProvider;

        private FalloffShape(Function<PlateauSphericalMaskRealRandomAccessible, BiConsumer<RealLocalizable, DoubleType>> fallOffProvider) {
            this.fallOffProvider = fallOffProvider;
        }

        public BiConsumer<RealLocalizable, DoubleType> createFalloffFunction(PlateauSphericalMaskRealRandomAccessible mask) {
            return this.fallOffProvider.apply(mask);
        }
    }
}

