/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.compat;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.AWTEventListener;
import java.awt.event.ContainerEvent;
import java.io.File;
import java.util.WeakHashMap;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;

public class JFileChooserDecorator
implements DropTargetListener {
    JFileChooser fileChooser;
    protected static WeakHashMap<JFileChooser, JFileChooserDecorator> allJFileChoosers = new WeakHashMap();

    protected JFileChooserDecorator(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
    }

    public static void registerAutomaticDecorator() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AutomaticDecorator(), 2L);
    }

    static void removeDropTargetsFromChildren(Container container) {
        for (Component component : container.getComponents()) {
            component.setDropTarget(null);
            if (!(component instanceof Container)) continue;
            JFileChooserDecorator.removeDropTargetsFromChildren((Container)component);
        }
    }

    void removeDropTargetsWithDelay(final int count) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (count > 0) {
                    JFileChooserDecorator.this.removeDropTargetsWithDelay(count - 1);
                    return;
                }
                JFileChooserDecorator.removeDropTargetsFromChildren(JFileChooserDecorator.this.fileChooser);
            }
        });
    }

    String trim(String string) {
        int i;
        for (i = string.length(); i > 0 && "\r\n".indexOf(string.charAt(i - 1)) >= 0; --i) {
        }
        return string.substring(0, i);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(1);
        Transferable t = dtde.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String string = (String)t.getTransferData(DataFlavor.stringFlavor);
                if (string.startsWith("file://")) {
                    File file = new File(string = this.trim(string.substring(7)));
                    if (file.isDirectory()) {
                        this.fileChooser.setCurrentDirectory(file);
                    } else {
                        this.fileChooser.setCurrentDirectory(file.getParentFile());
                        this.fileChooser.setSelectedFile(file);
                    }
                    this.removeDropTargetsWithDelay(4);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        this.removeDropTargetsWithDelay(8);
        e.acceptDrag(1);
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public static void main(String[] args) {
        JFileChooserDecorator.registerAutomaticDecorator();
        JFileChooserDecorator.report("JFileChooser decorator started");
        JFileChooserDecorator.report("========================");
        new JFileChooser().showOpenDialog(null);
    }

    public static void report(String message) {
        if (!message.endsWith("\n")) {
            message = message + "\n";
        }
        System.err.println(message);
    }

    static class AutomaticDecorator
    implements AWTEventListener {
        AutomaticDecorator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void eventDispatched(AWTEvent e) {
            Object source = e.getSource();
            if (e.getID() != 300 || !(source instanceof JFileChooser)) {
                return;
            }
            ((ContainerEvent)e).getChild().setDropTarget(null);
            AutomaticDecorator automaticDecorator = this;
            synchronized (automaticDecorator) {
                if (allJFileChoosers.containsKey(source)) {
                    return;
                }
                allJFileChoosers.put((JFileChooser)source, null);
            }
            JFileChooserDecorator decorator = new JFileChooserDecorator((JFileChooser)source);
            new DropTarget((JFileChooser)source, decorator);
            allJFileChoosers.put((JFileChooser)source, decorator);
            decorator.removeDropTargetsWithDelay(8);
        }
    }
}

