/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.List;
import mpicbg.ij.SIFT;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2DSIFT;

public class SIFT_Test
implements PlugIn {
    private static final FloatArray2DSIFT.Param p = new FloatArray2DSIFT.Param();
    static final List<Feature> fs = new ArrayList<Feature>();

    static void drawSquare(ImageProcessor ip, double[] o, double scale, double orient) {
        double sin = Math.sin(orient);
        double cos = Math.cos(orient);
        int[] x = new int[6];
        int[] y = new int[6];
        x[0] = (int)(o[0] + (sin - cos) * (scale /= 2.0));
        y[0] = (int)(o[1] - (sin + cos) * scale);
        x[1] = (int)o[0];
        y[1] = (int)o[1];
        x[2] = (int)(o[0] + (sin + cos) * scale);
        y[2] = (int)(o[1] + (sin - cos) * scale);
        x[3] = (int)(o[0] - (sin - cos) * scale);
        y[3] = (int)(o[1] + (sin + cos) * scale);
        x[4] = (int)(o[0] - (sin + cos) * scale);
        y[4] = (int)(o[1] - (sin - cos) * scale);
        x[5] = x[0];
        y[5] = y[0];
        ip.drawPolygon(new Polygon(x, y, x.length));
    }

    public void run(String args) {
        if (IJ.versionLessThan((String)"1.37i")) {
            return;
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            System.err.println("There are no images open");
            return;
        }
        GenericDialog gd = new GenericDialog("Test SIFT");
        SIFT.addFields((GenericDialog)gd, (FloatArray2DSIFT.Param)p);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        SIFT.readFields((GenericDialog)gd, (FloatArray2DSIFT.Param)p);
        ImageProcessor ip1 = imp.getProcessor().convertToFloat();
        ImageProcessor ip2 = imp.getProcessor().duplicate().convertToRGB();
        SIFT ijSift = new SIFT(new FloatArray2DSIFT(p));
        fs.clear();
        long start_time = System.currentTimeMillis();
        System.out.print("processing SIFT ...");
        ijSift.extractFeatures(ip1, fs);
        System.out.println(" took " + (System.currentTimeMillis() - start_time) + "ms");
        System.out.println(fs.size() + " features identified and processed");
        ip2.setLineWidth(1);
        ip2.setColor(Color.red);
        for (Feature f : fs) {
            SIFT_Test.drawSquare(ip2, new double[]{f.location[0], f.location[1]}, (double)SIFT_Test.p.fdSize * 4.0 * f.scale, f.orientation);
        }
        new ImagePlus(imp.getTitle() + " Features ", ip2).show();
    }
}

