/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation.randomaccess;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.interpolation.randomaccess.NLinearInterpolator;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.util.Util;

public class NLinearInterpolatorARGB
extends NLinearInterpolator<ARGBType> {
    protected double accA;
    protected double accR;
    protected double accG;
    protected double accB;

    protected NLinearInterpolatorARGB(NLinearInterpolatorARGB interpolator) {
        super(interpolator);
    }

    protected NLinearInterpolatorARGB(RandomAccessible<ARGBType> randomAccessible, ARGBType type) {
        super(randomAccessible, type);
    }

    protected NLinearInterpolatorARGB(RandomAccessible<ARGBType> randomAccessible) {
        this(randomAccessible, (ARGBType)randomAccessible.randomAccess().get());
    }

    @Override
    public ARGBType get() {
        this.fillWeights();
        int argb = ((ARGBType)((RandomAccess)this.target).get()).get();
        this.accA = (double)(argb >> 24 & 0xFF) * this.weights[0];
        this.accR = (double)(argb >> 16 & 0xFF) * this.weights[0];
        this.accG = (double)(argb >> 8 & 0xFF) * this.weights[0];
        this.accB = (double)(argb & 0xFF) * this.weights[0];
        this.code = 0;
        this.graycodeFwdRecursive(this.n - 1);
        ((RandomAccess)this.target).bck(this.n - 1);
        int a = Math.min(255, (int)Util.round(this.accA));
        int r = Math.min(255, (int)Util.round(this.accR));
        int g = Math.min(255, (int)Util.round(this.accG));
        int b = Math.min(255, (int)Util.round(this.accB));
        ((ARGBType)this.accumulator).set(((a << 8 | r) << 8 | g) << 8 | b);
        return (ARGBType)this.accumulator;
    }

    @Override
    public NLinearInterpolatorARGB copy() {
        return new NLinearInterpolatorARGB(this);
    }

    private final void graycodeFwdRecursive(int dimension) {
        if (dimension == 0) {
            ((RandomAccess)this.target).fwd(0);
            ++this.code;
            this.accumulate();
        } else {
            this.graycodeFwdRecursive(dimension - 1);
            ((RandomAccess)this.target).fwd(dimension);
            this.code += 1 << dimension;
            this.accumulate();
            this.graycodeBckRecursive(dimension - 1);
        }
    }

    private final void graycodeBckRecursive(int dimension) {
        if (dimension == 0) {
            ((RandomAccess)this.target).bck(0);
            --this.code;
            this.accumulate();
        } else {
            this.graycodeFwdRecursive(dimension - 1);
            ((RandomAccess)this.target).bck(dimension);
            this.code -= 1 << dimension;
            this.accumulate();
            this.graycodeBckRecursive(dimension - 1);
        }
    }

    private final void accumulate() {
        int argb = ((ARGBType)((RandomAccess)this.target).get()).get();
        this.accA += (double)(argb >> 24 & 0xFF) * this.weights[this.code];
        this.accR += (double)(argb >> 16 & 0xFF) * this.weights[this.code];
        this.accG += (double)(argb >> 8 & 0xFF) * this.weights[this.code];
        this.accB += (double)(argb & 0xFF) * this.weights[this.code];
    }

    private final void printWeights() {
        for (int i = 0; i < this.weights.length; ++i) {
            System.out.printf("weights [ %2d ] = %f\n", i, this.weights[i]);
        }
    }

    private final void printCode() {
        int maxbits = 4;
        String binary = Integer.toBinaryString(this.code);
        for (int i = binary.length(); i < 4; ++i) {
            System.out.print("0");
        }
        System.out.print(binary);
    }
}

