/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Util;

public abstract class GenericByteType<T extends GenericByteType<T>>
extends AbstractIntegerType<T>
implements NativeType<T> {
    final Index i = new Index();
    protected final NativeImg<?, ? extends ByteAccess> img;
    protected ByteAccess dataAccess;

    public GenericByteType(NativeImg<?, ? extends ByteAccess> byteStorage) {
        this.img = byteStorage;
    }

    public GenericByteType(byte value) {
        this.img = null;
        this.dataAccess = new ByteArray(1);
        this.setByte(value);
    }

    public GenericByteType(ByteAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public GenericByteType() {
        this(0);
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction();
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public Index index() {
        return this.i;
    }

    @Override
    public abstract NativeTypeFactory<T, ByteAccess> getNativeTypeFactory();

    @Deprecated
    protected byte getValue() {
        return this.dataAccess.getValue(this.i.get());
    }

    @Deprecated
    protected void setValue(byte f) {
        this.dataAccess.setValue(this.i.get(), f);
    }

    public byte getByte() {
        return this.dataAccess.getValue(this.i.get());
    }

    public void setByte(byte f) {
        this.dataAccess.setValue(this.i.get(), f);
    }

    @Override
    public void mul(float c) {
        byte a = this.getByte();
        this.setByte((byte)Util.round((float)a * c));
    }

    @Override
    public void mul(double c) {
        byte a = this.getByte();
        this.setByte((byte)Util.round((double)a * c));
    }

    @Override
    public void add(T c) {
        byte a = this.getByte();
        this.setByte((byte)(a + ((GenericByteType)c).getByte()));
    }

    @Override
    public void div(T c) {
        byte a = this.getByte();
        this.setByte((byte)(a / ((GenericByteType)c).getByte()));
    }

    @Override
    public void mul(T c) {
        byte a = this.getByte();
        this.setByte((byte)(a * ((GenericByteType)c).getByte()));
    }

    @Override
    public void sub(T c) {
        byte a = this.getByte();
        this.setByte((byte)(a - ((GenericByteType)c).getByte()));
    }

    @Override
    public void set(T c) {
        this.setByte(((GenericByteType)c).getByte());
    }

    @Override
    public void setOne() {
        this.setByte((byte)1);
    }

    @Override
    public void setZero() {
        this.setByte((byte)0);
    }

    @Override
    public void inc() {
        byte a = this.getByte();
        a = (byte)(a + 1);
        this.setByte(a);
    }

    @Override
    public void dec() {
        byte a = this.getByte();
        a = (byte)(a - 1);
        this.setByte(a);
    }

    @Override
    public String toString() {
        return "" + this.getByte();
    }

    @Override
    public int getBitsPerPixel() {
        return 8;
    }

    @Override
    public int compareTo(T other) {
        return Byte.compare(this.getByte(), ((GenericByteType)other).getByte());
    }

    @Override
    public boolean valueEquals(T t) {
        return this.getByte() == ((GenericByteType)t).getByte();
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        GenericByteType t = (GenericByteType)obj;
        return this.valueEquals((T)t);
    }

    @Override
    public int hashCode() {
        return Byte.hashCode(this.getByte());
    }
}

