/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class KD_Cartoon
implements PlugInFilter {
    private ImagePlus image;

    public int setup(String arg, ImagePlus img) {
        this.image = img;
        return 159;
    }

    public void run(ImageProcessor ip) {
        GenericDialog gd = new GenericDialog("Despeckle");
        gd.addNumericField("ratio color/space", 256.0 / (double)(ip.getWidth() * ip.getHeight()), 3);
        gd.addNumericField("number of classes", 20.0, 0);
        gd.addNumericField("iterations (at most)", 50.0, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        double ratio = gd.getNextNumber();
        int n = (int)gd.getNextNumber();
        int iter = (int)gd.getNextNumber();
        KD kd = new KD(ip, ratio, n, iter);
        ImageProcessor result = kd.getResult();
        new ImagePlus("KD Cartoon of " + this.image.getTitle(), result).show();
    }

    private static class KD {
        ImageProcessor ip;
        boolean isColor;
        double ratio;
        int w;
        int h;
        int n;
        int iterations;
        int[] c;
        Difference[] diff;

        public KD(ImageProcessor ip, double ratio, int n, int iter) {
            this.ip = ip;
            this.isColor = ip.isColorLut() || ip instanceof ColorProcessor;
            this.ratio = ratio;
            this.w = ip.getWidth();
            this.h = ip.getHeight();
            this.c = new int[this.w * this.h];
            for (int i = 0; i < this.w * this.h; ++i) {
                this.c[i] = (int)(Math.random() * (double)n);
            }
            this.n = n;
            this.iterations = iter;
        }

        public int iterate() {
            int i;
            this.diff = new Difference[this.n];
            for (i = 0; i < this.n; ++i) {
                this.diff[i] = this.isColor ? new ColorDifference(this.ip, this.ratio) : new GrayDifference(this.ip, this.ratio);
                this.diff[i].init();
            }
            for (int y = 0; y < this.h; ++y) {
                for (int x = 0; x < this.w; ++x) {
                    this.diff[this.c[x + this.w * y]].add(x, y);
                }
            }
            for (i = 0; i < this.n; ++i) {
                this.diff[i].finish();
            }
            int count = 0;
            for (int y = 0; y < this.h; ++y) {
                for (int x = 0; x < this.w; ++x) {
                    int best = 0;
                    double d = this.diff[0].getDiff(x, y);
                    for (int i2 = 1; i2 < this.n; ++i2) {
                        double d2 = this.diff[i2].getDiff(x, y);
                        if (!(d > d2)) continue;
                        best = i2;
                        d = d2;
                    }
                    if (this.c[x + this.w * y] == best) continue;
                    ++count;
                    this.c[x + this.w * y] = best;
                }
            }
            return count;
        }

        public ImageProcessor getResult() {
            for (int i = 0; i < this.iterations; ++i) {
                int count = this.iterate();
                IJ.showStatus((String)("adjusted pixels: " + count + " (" + (i + 1) + "/" + this.iterations + ")"));
                if (count == 0) break;
            }
            return this.getImage();
        }

        private ImageProcessor getImage() {
            if (this.isColor) {
                int[] colors = new int[this.n];
                for (int i = 0; i < this.n; ++i) {
                    colors[i] = ((ColorDifference)this.diff[i]).getMean();
                }
                int[] pixels = new int[this.w * this.h];
                for (int i = 0; i < this.w * this.h; ++i) {
                    pixels[i] = colors[this.c[i]];
                }
                return new ColorProcessor(this.w, this.h, pixels);
            }
            float[] colors = new float[this.n];
            for (int i = 0; i < this.n; ++i) {
                colors[i] = ((GrayDifference)this.diff[i]).getMean();
            }
            float[] pixels = new float[this.w * this.h];
            for (int i = 0; i < this.w * this.h; ++i) {
                pixels[i] = colors[this.c[i]];
            }
            return new FloatProcessor(this.w, this.h, pixels, null);
        }
    }

    private static class GrayDifference
    extends Difference {
        float mean;

        public GrayDifference(ImageProcessor ip, double space_color_ratio) {
            super(ip, space_color_ratio);
        }

        @Override
        public void init() {
            this.mean = 0.0f;
            super.init();
        }

        @Override
        public void add(int x, int y) {
            this.mean += this.ip.getf(x, y);
            super.add(x, y);
        }

        @Override
        public void finish() {
            if (this.count < 1) {
                return;
            }
            this.mean /= (float)this.count;
            super.finish();
        }

        @Override
        public double getDiff(int x, int y) {
            float c = this.mean - this.ip.getf(x, y);
            return super.getDiff(x, y) + (double)(c * c);
        }

        public float getMean() {
            return this.mean;
        }
    }

    private static class ColorDifference
    extends Difference {
        double r;
        double g;
        double b;
        double r2;
        double g2;
        double b2;

        public ColorDifference(ImageProcessor ip, double space_color_ratio) {
            super(ip, space_color_ratio);
        }

        private void decompose(int c) {
            this.r = c >> 16 & 0xFF;
            this.g = c >> 8 & 0xFF;
            this.b = c & 0xFF;
        }

        @Override
        public void init() {
            this.b2 = 0.0;
            this.g2 = 0.0;
            this.r2 = 0.0;
            super.init();
        }

        @Override
        public void add(int x, int y) {
            int c = this.ip.get(x, y);
            this.decompose(c);
            this.r2 += this.r;
            this.g2 += this.g;
            this.b2 += this.b;
            super.add(x, y);
        }

        @Override
        public void finish() {
            if (this.count < 1) {
                return;
            }
            this.r2 /= (double)this.count;
            this.g2 /= (double)this.count;
            this.b2 /= (double)this.count;
            super.finish();
        }

        @Override
        public double getDiff(int x, int y) {
            int c = this.ip.get(x, y);
            this.decompose(c);
            this.r -= this.r2;
            this.g -= this.g2;
            this.b -= this.b2;
            double x1 = (double)x - this.x2;
            double y1 = (double)y - this.y2;
            return super.getDiff(x, y) + this.r * this.r + this.g * this.g + this.b * this.b;
        }

        public int getMean() {
            return (int)this.r2 << 16 | (int)this.g2 << 8 | (int)this.b2;
        }
    }

    private static class Difference {
        ImageProcessor ip;
        double ratio;
        int count;
        double x2;
        double y2;

        public Difference(ImageProcessor ip, double space_color_ratio) {
            this.ip = ip;
            this.ratio = space_color_ratio;
        }

        public void init() {
            this.y2 = 0.0;
            this.x2 = 0.0;
            this.count = 0;
        }

        public void add(int x, int y) {
            this.x2 += (double)x;
            this.y2 += (double)y;
            ++this.count;
        }

        public void finish() {
            this.x2 /= (double)this.count;
            this.y2 /= (double)this.count;
        }

        public double getDiff(int x, int y) {
            double x1 = (double)x - this.x2;
            double y1 = (double)y - this.y2;
            return this.ratio * (x1 * x1 + y1 * y1);
        }
    }
}

