/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import process3d.Find_Minima;
import process3d.Flood_Fill;
import vib.BenesNamedPoint;
import vib.InterpolatedImage;
import vib.PointList;

public class IFT_
implements PlugInFilter {
    private static final String INDICES_KEY = "VIB.IFT.showIndices";
    private static final String RESULTS_KEY = "VIB.IFT.showResults";
    private static final String INTENSITIES_KEY = "VIB.IFT.showIntensities";
    private static final boolean DEFAULT_SHOW_INDICES = true;
    private static final boolean DEFAULT_SHOW_RESULTS = true;
    private static final boolean DEFAULT_SHOW_INTENSITIES = true;
    private ImagePlus image;
    private int w;
    private int h;
    private int wh;
    private int d;
    private PriorityQueue queue;
    private byte[][] data;
    private int[][] result;
    private int[] C;
    private boolean[] flag;
    private GenericDialog settingsDialog;
    private int seed;
    private boolean showIndices;
    private boolean showResults;
    private boolean showIntensities;
    Cls[] classes;
    private int[] neighbors = new int[6];

    public IFT_(ImagePlus image) {
        this.image = image;
    }

    public IFT_() {
    }

    public void run(ImageProcessor ip) {
        int[] wIDs = WindowManager.getIDList();
        if (wIDs == null) {
            IJ.error((String)"No images open");
            return;
        }
        String[] titles = new String[wIDs.length + 2];
        for (int i = 0; i < wIDs.length; ++i) {
            titles[i] = WindowManager.getImage((int)wIDs[i]).getTitle();
        }
        titles[titles.length - 1] = "use seeds from point list";
        titles[titles.length - 2] = "use local minima";
        this.loadSettings();
        this.createSettingsDialog(titles);
        this.settingsDialog.showDialog();
        if (this.settingsDialog.wasCanceled()) {
            return;
        }
        this.readSettings();
        this.saveSettings();
        if (this.seed == titles.length - 1) {
            this.initFromPointList();
        } else if (this.seed == titles.length - 2) {
            this.initFromMinima();
        } else {
            this.initFromImage(WindowManager.getImage((String)titles[this.seed]));
        }
        this.propagate();
        if (this.showIndices) {
            this.createResult().show();
        }
        if (this.showIntensities) {
            this.createMeans().show();
        }
        if (this.showResults) {
            new TextWindow("Classes", "min\tmax\tmean\tvol\tcogx\tcogy\tcogz\tox\toy\toz", this.createSummaryString(), 400, 500);
        }
    }

    public void initFromImage(ImagePlus seeds) {
        int z;
        ArrayList<Cls> classlist = new ArrayList<Cls>();
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.wh = this.w * this.h;
        this.d = this.image.getStackSize();
        this.data = new byte[this.d][];
        for (z = 0; z < this.d; ++z) {
            this.data[z] = (byte[])this.image.getStack().getProcessor(z + 1).getPixels();
        }
        this.C = new int[this.w * this.h * this.d];
        this.flag = new boolean[this.w * this.h * this.d];
        this.result = new int[this.d][this.w * this.h];
        for (int i = 0; i < this.C.length; ++i) {
            this.C[i] = 255;
        }
        this.queue = new PriorityQueue();
        for (z = 0; z < seeds.getStackSize(); ++z) {
            byte[] b = (byte[])seeds.getStack().getPixels(z + 1);
            for (int y = 0; y < this.h; ++y) {
                for (int x = 0; x < this.w; ++x) {
                    int cost;
                    int i = y * this.w + x;
                    if (b[i] == 0) continue;
                    int index = z * b.length + i;
                    this.C[index] = cost = 0;
                    this.result[z][i] = b[i] & 0xFF;
                    this.queue.add(index, cost);
                    IFT_.addClass(classlist, x, y, z, b[i]);
                }
            }
        }
        this.classes = new Cls[classlist.size()];
        classlist.toArray(this.classes);
    }

    public void initFromMinima() {
        IJ.showStatus((String)"Find minima");
        ArrayList<Cls> classlist = new ArrayList<Cls>();
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.wh = this.w * this.h;
        this.d = this.image.getStackSize();
        this.data = new byte[this.d][];
        for (int z = 0; z < this.d; ++z) {
            this.data[z] = (byte[])this.image.getStack().getProcessor(z + 1).getPixels();
        }
        this.C = new int[this.w * this.h * this.d];
        this.flag = new boolean[this.w * this.h * this.d];
        this.result = new int[this.d][this.w * this.h];
        for (int i = 0; i < this.C.length; ++i) {
            this.C[i] = 255;
        }
        ImagePlus minima = new Find_Minima(this.image).classify();
        this.queue = new PriorityQueue();
        int counter = 0;
        for (int z = 0; z < minima.getStackSize(); ++z) {
            byte[] b = (byte[])minima.getStack().getPixels(z + 1);
            for (int y = 0; y < this.h; ++y) {
                for (int x = 0; x < this.w; ++x) {
                    int cost;
                    int i = y * this.w + x;
                    if (b[i] == 0) continue;
                    int index = z * b.length + i;
                    this.C[index] = cost = 0;
                    this.result[z][i] = counter++;
                    this.queue.add(index, cost);
                    IFT_.addClass(classlist, x, y, z, this.data[z][y * this.w + x]);
                    Flood_Fill.fill(minima, x, y, z, 0);
                }
            }
            IJ.showProgress((int)(z + 1), (int)this.d);
        }
        System.out.println(counter + " classes");
        this.classes = new Cls[counter];
        classlist.toArray(this.classes);
    }

    protected static void addClass(List<Cls> classlist, int x, int y, int z, byte value) {
        Cls cls = new Cls();
        cls.add(x, y, z, value);
        cls.originx = x;
        cls.originy = y;
        cls.originz = z;
        classlist.add(cls);
    }

    public void initFromPointList() {
        ArrayList<Cls> classlist = new ArrayList<Cls>();
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.wh = this.w * this.h;
        this.d = this.image.getStackSize();
        PointList markers = PointList.load((ImagePlus)this.image);
        this.data = new byte[this.d][];
        for (int z = 0; z < this.d; ++z) {
            this.data[z] = (byte[])this.image.getStack().getProcessor(z + 1).getPixels();
        }
        this.C = new int[this.w * this.h * this.d];
        this.flag = new boolean[this.w * this.h * this.d];
        this.result = new int[this.d][this.w * this.h];
        for (int i = 0; i < this.C.length; ++i) {
            this.C[i] = 255;
        }
        this.queue = new PriorityQueue();
        int m = 1;
        for (BenesNamedPoint p : markers) {
            int cost;
            int z = (int)p.z;
            int i = (int)p.y * this.w + (int)p.x;
            int index = z * this.w * this.h + i;
            this.C[index] = cost = 0;
            this.result[z][i] = m += 10;
            this.queue.add(index, cost);
            IFT_.addClass(classlist, (int)p.x, (int)p.y, (int)p.z, (byte)m);
        }
        this.classes = new Cls[classlist.size()];
        classlist.toArray(this.classes);
    }

    public void propagate() {
        System.out.println("Propagate");
        int counter = 0;
        int whd = this.wh * this.d;
        while (!this.queue.isEmpty()) {
            int v = this.queue.poll();
            this.flag[v] = true;
            this.getNeighbours(v);
            for (int i = 0; i < this.neighbors.length; ++i) {
                int p = this.neighbors[i];
                if (p == -1) continue;
                int pCost = this.C[p];
                int m = this.C[v] + this.weight(v, p);
                if (m >= this.C[p]) continue;
                this.C[p] = m;
                int pz = p / this.wh;
                int pi = p % this.wh;
                int vz = v / this.wh;
                int vi = v % this.wh;
                this.result[pz][pi] = this.result[vz][vi];
                this.classes[this.result[vz][vi]].add(pi % this.w, pi / this.w, pz, this.data[pz][pi]);
                ++counter;
                this.queue.removeFromBucket(p, pCost);
                this.queue.add(p, this.C[p]);
            }
            if (counter % 1000 != 0) continue;
            IJ.showProgress((int)counter, (int)whd);
        }
        IJ.showProgress((double)1.0);
        for (int i = 0; i < this.classes.length; ++i) {
            this.classes[i].finished();
        }
    }

    public ImagePlus createResult() {
        ImageStack stack = new ImageStack(this.w, this.h);
        for (int z = 0; z < this.d; ++z) {
            stack.addSlice("", (ImageProcessor)new ColorProcessor(this.w, this.h, this.result[z]));
        }
        ImagePlus ret = new ImagePlus("Result", stack);
        ret.setCalibration(this.image.getCalibration());
        return ret;
    }

    public ImagePlus createMeans() {
        ImageStack stack = new ImageStack(this.w, this.h);
        for (int z = 0; z < this.d; ++z) {
            byte[] means = new byte[this.wh];
            for (int i = 0; i < this.wh; ++i) {
                means[i] = (byte)this.classes[this.result[z][i]].mean;
            }
            stack.addSlice("", (ImageProcessor)new ByteProcessor(this.w, this.h, means, null));
        }
        ImagePlus ret = new ImagePlus("Result", stack);
        ret.setCalibration(this.image.getCalibration());
        return ret;
    }

    public String createSummaryString() {
        String ret = "";
        for (int i = 0; i < this.classes.length; ++i) {
            Cls c = this.classes[i];
            ret = ret + c.min + "\t" + c.max + "\t" + c.mean + "\t" + c.vol + "\t" + c.cogx + "\t" + c.cogy + "\t" + c.cogz + c.originx + "\t" + c.originy + "\t" + c.originz + "\n";
        }
        return ret;
    }

    public Cls[] getClasses() {
        return this.classes;
    }

    public int weight(int n1, int n2) {
        int z1 = n1 / this.wh;
        int i1 = n1 % this.wh;
        int z2 = n2 / this.wh;
        int i2 = n2 % this.wh;
        return Math.abs((this.data[z1][i1] & 0xFF) - (this.data[z2][i2] & 0xFF));
    }

    public int setup(String arg, ImagePlus image) {
        this.image = image;
        return 1;
    }

    public void getNeighbours(int index) {
        int z = index / this.wh;
        int s = index % this.wh;
        int x = s % this.w;
        int y = s / this.w;
        for (int i = 0; i < this.neighbors.length; ++i) {
            this.neighbors[i] = -1;
        }
        if (x > 1 && !this.flag[z * this.wh + s - 1]) {
            this.neighbors[0] = z * this.wh + s - 1;
        }
        if (x < this.w - 1 && !this.flag[z * this.wh + s + 1]) {
            this.neighbors[1] = z * this.wh + s + 1;
        }
        if (y > 1 && !this.flag[z * this.wh + (y - 1) * this.w + x]) {
            this.neighbors[2] = z * this.wh + (y - 1) * this.w + x;
        }
        if (y < this.h - 1 && !this.flag[z * this.wh + (y + 1) * this.w + x]) {
            this.neighbors[3] = z * this.wh + (y + 1) * this.w + x;
        }
        if (z > 1 && !this.flag[(z - 1) * this.wh + s]) {
            this.neighbors[4] = (z - 1) * this.wh + s;
        }
        if (z < this.d - 1 && !this.flag[(z + 1) * this.wh + s]) {
            this.neighbors[5] = (z + 1) * this.wh + s;
        }
    }

    public ImagePlus checkLabelfield(ImagePlus labels) {
        InterpolatedImage ilabels = new InterpolatedImage(labels);
        InterpolatedImage created = ilabels.cloneDimensionsOnly();
        int w = labels.getWidth();
        int h = labels.getHeight();
        int d = labels.getStackSize();
        ImagePlus result = this.createResult();
        for (int z = 0; z < d; ++z) {
            int[] res_p = (int[])result.getStack().getPixels(z + 1);
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int c_idx = res_p[y * w + x] & 0xFFFFFF;
                    Cls c = this.classes[c_idx];
                    created.set(x, y, z, ilabels.getNoCheck(c.originx, c.originy, c.originz));
                }
            }
        }
        return created.getImage();
    }

    private void loadSettings() {
        this.showIndices = Prefs.get((String)INDICES_KEY, (boolean)true);
        this.showIntensities = Prefs.get((String)INTENSITIES_KEY, (boolean)true);
        this.showResults = Prefs.get((String)RESULTS_KEY, (boolean)true);
    }

    private void createSettingsDialog(String[] titles) {
        this.settingsDialog = new GenericDialog("Watershed from markers");
        this.settingsDialog.addChoice("Seeds", titles, titles[0]);
        this.settingsDialog.addCheckbox("Show class indices", this.showIndices);
        this.settingsDialog.addCheckbox("Show mean intensities", this.showIntensities);
        this.settingsDialog.addCheckbox("Show results table", this.showResults);
        this.settingsDialog.addHelp("http://imagej.net/3D_Binary_Filters");
    }

    private void readSettings() {
        this.seed = this.settingsDialog.getNextChoiceIndex();
        this.showIndices = this.settingsDialog.getNextBoolean();
        this.showIntensities = this.settingsDialog.getNextBoolean();
        this.showResults = this.settingsDialog.getNextBoolean();
    }

    private void saveSettings() {
        Prefs.set((String)INDICES_KEY, (boolean)this.showIndices);
        Prefs.set((String)INTENSITIES_KEY, (boolean)this.showIntensities);
        Prefs.set((String)RESULTS_KEY, (boolean)this.showResults);
    }

    public static void writeClasses(String path, Cls[] classes) throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(path));
        out.println(classes.length + " classes");
        for (int i = 0; i < classes.length; ++i) {
            out.println(classes[i]);
        }
        out.close();
    }

    public static Cls[] readClasses(String path) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(path));
        String line = reader.readLine();
        int nClasses = Integer.parseInt(line.split("\\s")[0]);
        Cls[] classes = new Cls[nClasses];
        for (int i = 0; i < nClasses; ++i) {
            classes[i] = Cls.initFromString(reader.readLine());
        }
        reader.close();
        return classes;
    }

    private static final class IntArray {
        private int[] array;
        private int size = 0;
        private int initCap;

        public IntArray(int cap) {
            this.initCap = cap;
            this.array = new int[cap];
        }

        public final int size() {
            return this.size;
        }

        public final boolean isEmpty() {
            return this.size == 0;
        }

        public final int get(int i) {
            if (i >= 0 && i < this.size) {
                return this.array[i];
            }
            return -1;
        }

        public final void add(int n) {
            if (this.size == this.array.length) {
                int additional = this.initCap / 5;
                additional = additional == 0 ? 1 : additional;
                int[] tmp = this.array;
                this.array = new int[this.array.length + additional];
                System.arraycopy(tmp, 0, this.array, 0, tmp.length);
            }
            this.array[this.size] = n;
            ++this.size;
        }

        public final void removeIndex(int i) {
            if (i < 0 || i >= this.size) {
                return;
            }
            --this.size;
            for (int k = i; k < this.size; ++k) {
                this.array[k] = this.array[k + 1];
            }
        }

        public final int removeLast() {
            --this.size;
            return this.array[this.size];
        }

        public final boolean removeValue(int v) {
            int k;
            for (k = 0; k < this.size && this.array[k] != v; ++k) {
            }
            if (k == this.size) {
                return false;
            }
            --this.size;
            while (k < this.size) {
                this.array[k] = this.array[k + 1];
                ++k;
            }
            return true;
        }

        public final void set(int index, int value) {
            if (index >= 0 && index < this.size) {
                this.array[index] = value;
            }
        }

        public final void removeAll() {
            this.size = 0;
        }
    }

    private static final class PriorityQueue {
        private IntArray[] arr = new IntArray[256];
        private int size = 0;

        public final void add(int value, int cost) {
            if (this.arr[cost] == null) {
                this.arr[cost] = new IntArray(10000);
            }
            this.arr[cost].add(value);
            ++this.size;
        }

        public final boolean isEmpty() {
            return this.size == 0;
        }

        public final int poll() {
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] == null || this.arr[i].isEmpty()) continue;
                int ret = this.arr[i].removeLast();
                --this.size;
                return ret;
            }
            return -1;
        }

        public final void removeFromBucket(int value, int bucket) {
            if (this.arr[bucket] != null && this.arr[bucket].removeValue(value)) {
                --this.size;
            }
        }
    }

    public static final class Cls {
        public int min = 255;
        public int max = 0;
        public int mean = 0;
        public int vol = 0;
        public int cogx = 0;
        public int cogy = 0;
        public int cogz = 0;
        public int originx = 0;
        public int originy = 0;
        public int originz = 0;

        private final void add(int x, int y, int z, byte pixel) {
            int value = pixel & 0xFF;
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
            this.mean += value;
            ++this.vol;
            this.cogx += x;
            this.cogy += y;
            this.cogz += z;
        }

        private final void finished() {
            this.mean /= this.vol;
            this.cogx /= this.vol;
            this.cogy /= this.vol;
            this.cogz /= this.vol;
        }

        static Cls initFromString(String line) {
            Cls cls = new Cls();
            String[] tokens = line.split("\\s");
            cls.min = Integer.parseInt(tokens[0]);
            cls.max = Integer.parseInt(tokens[1]);
            cls.mean = Integer.parseInt(tokens[2]);
            cls.vol = Integer.parseInt(tokens[3]);
            cls.cogx = Integer.parseInt(tokens[4]);
            cls.cogy = Integer.parseInt(tokens[5]);
            cls.cogz = Integer.parseInt(tokens[6]);
            cls.originx = Integer.parseInt(tokens[7]);
            cls.originy = Integer.parseInt(tokens[8]);
            cls.originz = Integer.parseInt(tokens[9]);
            return cls;
        }

        public String toString() {
            return this.min + " " + this.max + " " + this.mean + " " + this.vol + " " + this.cogx + " " + this.cogy + " " + this.cogz + " " + this.originx + " " + this.originy + " " + this.originz;
        }
    }
}

