/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.builder;

import java.io.File;
import java.io.IOException;
import org.apposed.appose.Builder;
import org.apposed.appose.BuilderFactory;
import org.apposed.appose.builder.UvBuilder;

public class UvBuilderFactory
implements BuilderFactory {
    @Override
    public Builder<?> createBuilder() {
        return new UvBuilder();
    }

    @Override
    public Builder<?> createBuilder(String source) throws IOException {
        return new UvBuilder(source);
    }

    @Override
    public Builder<?> createBuilder(String source, String scheme) throws IOException {
        return new UvBuilder(source, scheme);
    }

    @Override
    public String name() {
        return "uv";
    }

    @Override
    public boolean supportsScheme(String scheme) {
        switch (scheme) {
            case "requirements.txt": 
            case "pypi": {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsSource(String source) {
        return source.endsWith("requirements.txt") || source.endsWith(".txt");
    }

    @Override
    public double priority() {
        return 75.0;
    }

    @Override
    public boolean canWrap(File envDir) {
        boolean hasPyvenvCfg = new File(envDir, "pyvenv.cfg").isFile();
        boolean isNotPixi = !new File(envDir, ".pixi").isDirectory() && !new File(envDir, "pixi.toml").isFile();
        boolean isNotConda = !new File(envDir, "conda-meta").isDirectory();
        return hasPyvenvCfg && isNotPixi && isNotConda;
    }
}

