/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.hdf5;

import bdv.img.hdf5.ViewLevelId;
import hdf.hdf5lib.HDF5Constants;
import mpicbg.spim.data.sequence.ViewId;
import org.janelia.saalfeldlab.n5.DataType;

public class Util {
    private static final String groupFormatString = "t%05d/s%02d/%d";
    private static final String cellsFormatString = "%s/cells";
    private static final String setupFormatString = "s%02d";
    private static final String resolutionsFormatString = "s%02d/resolutions";
    private static final String subdivisionsFormatString = "s%02d/subdivisions";

    public static String getGroupPath(int timepointId, int setupId, int level) {
        return String.format(groupFormatString, timepointId, setupId, level);
    }

    public static String getGroupPath(ViewId viewId, int level) {
        return String.format(groupFormatString, viewId.getTimePointId(), viewId.getViewSetupId(), level);
    }

    public static String getGroupPath(ViewLevelId viewLevelId) {
        return String.format(groupFormatString, viewLevelId.getTimePointId(), viewLevelId.getViewSetupId(), viewLevelId.getLevel());
    }

    public static String getCellsPath(int timepoint, int setup, int level) {
        return String.format(cellsFormatString, Util.getGroupPath(timepoint, setup, level));
    }

    public static String getCellsPath(ViewId viewId, int level) {
        return String.format(cellsFormatString, Util.getGroupPath(viewId, level));
    }

    public static String getCellsPath(ViewLevelId viewLevelId) {
        return String.format(cellsFormatString, Util.getGroupPath(viewLevelId));
    }

    public static String getSetupPath(int setupId) {
        return String.format(setupFormatString, setupId);
    }

    public static String getResolutionsPath(int setupId) {
        return String.format(resolutionsFormatString, setupId);
    }

    public static String getSubdivisionsPath(int setupId) {
        return String.format(subdivisionsFormatString, setupId);
    }

    public static long[] reorder(long[] in, long[] out) {
        assert (in.length == out.length);
        int i = 0;
        int o = in.length - 1;
        while (i < in.length) {
            out[o] = in[i];
            ++i;
            --o;
        }
        return out;
    }

    public static long[] reorder(long[] in) {
        return in == null ? null : Util.reorder(in, new long[in.length]);
    }

    public static int[] reorder(int[] in, int[] out) {
        assert (in.length == out.length);
        int i = 0;
        int o = in.length - 1;
        while (i < in.length) {
            out[o] = in[i];
            ++i;
            --o;
        }
        return out;
    }

    public static int[] reorder(int[] in) {
        return in == null ? null : Util.reorder(in, new int[in.length]);
    }

    public static long[] reorder(int[] in, long[] out) {
        assert (in.length == out.length);
        int i = 0;
        int o = in.length - 1;
        while (i < in.length) {
            out[o] = in[i];
            ++i;
            --o;
        }
        return out;
    }

    public static int[] castToInts(double[] doubles) {
        int[] ints = new int[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            ints[i] = (int)doubles[i];
        }
        return ints;
    }

    public static int[][] castToInts(double[][] doubles) {
        int[][] ints = new int[doubles.length][];
        for (int l = 0; l < doubles.length; ++l) {
            ints[l] = Util.castToInts(doubles[l]);
        }
        return ints;
    }

    public static double[] castToDoubles(int[] ints) {
        double[] doubles = new double[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            doubles[i] = ints[i];
        }
        return doubles;
    }

    public static double[][] castToDoubles(int[][] ints) {
        double[][] doubles = new double[ints.length][];
        for (int l = 0; l < ints.length; ++l) {
            doubles[l] = Util.castToDoubles(ints[l]);
        }
        return doubles;
    }

    public static long memTypeId(DataType dataType) {
        switch (dataType) {
            case INT8: {
                return HDF5Constants.H5T_NATIVE_INT8;
            }
            case UINT8: {
                return HDF5Constants.H5T_NATIVE_UINT8;
            }
            case INT16: {
                return HDF5Constants.H5T_NATIVE_INT16;
            }
            case UINT16: {
                return HDF5Constants.H5T_NATIVE_UINT16;
            }
            case INT32: {
                return HDF5Constants.H5T_NATIVE_INT32;
            }
            case UINT32: {
                return HDF5Constants.H5T_NATIVE_UINT32;
            }
            case INT64: {
                return HDF5Constants.H5T_NATIVE_INT64;
            }
            case UINT64: {
                return HDF5Constants.H5T_NATIVE_UINT64;
            }
            case FLOAT32: {
                return HDF5Constants.H5T_NATIVE_FLOAT;
            }
            case FLOAT64: {
                return HDF5Constants.H5T_NATIVE_DOUBLE;
            }
        }
        throw new IllegalArgumentException();
    }
}

