/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import bdv.viewer.DisplayMode;
import bdv.viewer.Interpolation;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceGroup;
import bdv.viewer.ViewerStateChangeListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.listeners.Listeners;

public interface ViewerState {
    public ViewerState snapshot();

    public Listeners<ViewerStateChangeListener> changeListeners();

    public Interpolation getInterpolation();

    public void setInterpolation(Interpolation var1);

    public DisplayMode getDisplayMode();

    public void setDisplayMode(DisplayMode var1);

    public int getNumTimepoints();

    public void setNumTimepoints(int var1);

    public int getCurrentTimepoint();

    public void setCurrentTimepoint(int var1);

    public void getViewerTransform(AffineTransform3D var1);

    default public AffineTransform3D getViewerTransform() {
        AffineTransform3D transform = new AffineTransform3D();
        this.getViewerTransform(transform);
        return transform;
    }

    public void setViewerTransform(AffineTransform3D var1);

    public List<SourceAndConverter<?>> getSources();

    public SourceAndConverter<?> getCurrentSource();

    public boolean isCurrentSource(SourceAndConverter<?> var1);

    public boolean setCurrentSource(SourceAndConverter<?> var1);

    public Set<SourceAndConverter<?>> getActiveSources();

    public boolean isSourceActive(SourceAndConverter<?> var1);

    public boolean setSourceActive(SourceAndConverter<?> var1, boolean var2);

    public boolean setSourcesActive(Collection<? extends SourceAndConverter<?>> var1, boolean var2);

    public boolean isSourceVisible(SourceAndConverter<?> var1);

    public boolean isSourceVisibleAndPresent(SourceAndConverter<?> var1);

    public Set<SourceAndConverter<?>> getVisibleSources();

    public Set<SourceAndConverter<?>> getVisibleAndPresentSources();

    public boolean containsSource(SourceAndConverter<?> var1);

    public boolean addSource(SourceAndConverter<?> var1);

    public boolean addSources(Collection<? extends SourceAndConverter<?>> var1);

    public boolean removeSource(SourceAndConverter<?> var1);

    public boolean removeSources(Collection<? extends SourceAndConverter<?>> var1);

    public void clearSources();

    public Comparator<SourceAndConverter<?>> sourceOrder();

    public List<SourceGroup> getGroups();

    public SourceGroup getCurrentGroup();

    public boolean isCurrentGroup(SourceGroup var1);

    public boolean setCurrentGroup(SourceGroup var1);

    public Set<SourceGroup> getActiveGroups();

    public boolean isGroupActive(SourceGroup var1);

    public boolean setGroupActive(SourceGroup var1, boolean var2);

    public boolean setGroupsActive(Collection<? extends SourceGroup> var1, boolean var2);

    public String getGroupName(SourceGroup var1);

    public void setGroupName(SourceGroup var1, String var2);

    public boolean containsGroup(SourceGroup var1);

    public boolean addGroup(SourceGroup var1);

    public boolean addGroups(Collection<? extends SourceGroup> var1);

    public boolean removeGroup(SourceGroup var1);

    public boolean removeGroups(Collection<? extends SourceGroup> var1);

    public boolean addSourceToGroup(SourceAndConverter<?> var1, SourceGroup var2);

    public boolean addSourcesToGroup(Collection<? extends SourceAndConverter<?>> var1, SourceGroup var2);

    public boolean removeSourceFromGroup(SourceAndConverter<?> var1, SourceGroup var2);

    public boolean removeSourcesFromGroup(Collection<? extends SourceAndConverter<?>> var1, SourceGroup var2);

    public Set<SourceAndConverter<?>> getSourcesInGroup(SourceGroup var1);

    public void clearGroups();

    public Comparator<SourceGroup> groupOrder();
}

