/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.tools;

import java.util.LinkedList;
import net.imagej.ChannelCollection;
import net.imagej.Dataset;
import net.imagej.ImgPlus;
import net.imagej.Position;
import net.imagej.axis.Axes;
import net.imagej.display.DataView;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageCanvas;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imglib2.RandomAccess;
import net.imglib2.display.screenimage.awt.ARGBScreenImage;
import net.imglib2.type.numeric.RealType;
import org.scijava.Context;
import org.scijava.display.Display;
import org.scijava.display.event.input.MsEvent;
import org.scijava.plugin.Parameter;
import org.scijava.util.ColorRGB;
import org.scijava.util.Colors;
import org.scijava.util.IntCoords;
import org.scijava.util.RealCoords;

public class PixelRecorder {
    @Parameter
    private ImageDisplayService imageDisplayService;
    private long cx = 0L;
    private long cy = 0L;
    private Dataset dataset = null;
    private ChannelCollection channels = null;
    private ColorRGB color = Colors.BLACK;
    private boolean wasAltKeyDown = false;
    private boolean recordColor = false;

    public PixelRecorder(Context context, boolean recordColor) {
        context.inject((Object)this);
        this.recordColor = recordColor;
        this.channels = new ChannelCollection();
    }

    public boolean record(MsEvent evt) {
        long[] otherPositions;
        IntCoords mousePos;
        Display display = evt.getDisplay();
        if (!(display instanceof ImageDisplay)) {
            return false;
        }
        ImageDisplay imageDisplay = (ImageDisplay)display;
        ImageCanvas canvas = imageDisplay.getCanvas();
        if (!canvas.isInImage(mousePos = new IntCoords(evt.getX(), evt.getY()))) {
            return false;
        }
        this.wasAltKeyDown = evt.getModifiers().isAltDown() || evt.getModifiers().isAltGrDown();
        DataView activeView = imageDisplay.getActiveView();
        this.dataset = this.imageDisplayService.getActiveDataset(imageDisplay);
        ImgPlus image = this.dataset.getImgPlus();
        RandomAccess randomAccess = image.randomAccess();
        int xAxis = this.dataset.dimensionIndex(Axes.X);
        int yAxis = this.dataset.dimensionIndex(Axes.Y);
        int chanAxis = this.dataset.dimensionIndex(Axes.CHANNEL);
        RealCoords coords = canvas.panelToDataCoords(mousePos);
        this.cx = coords.getLongX();
        this.cy = coords.getLongY();
        Position planePos = activeView.getPlanePosition();
        if (chanAxis == -1) {
            otherPositions = new long[planePos.numDimensions()];
            for (int i = 0; i < planePos.numDimensions(); ++i) {
                otherPositions[i] = planePos.getLongPosition(i);
            }
        } else {
            otherPositions = new long[planePos.numDimensions() - 1];
            int d = 0;
            for (int i = 0; i < planePos.numDimensions(); ++i) {
                if (i == chanAxis - 2) continue;
                otherPositions[d++] = planePos.getLongPosition(i);
            }
        }
        if (this.recordColor) {
            DatasetView view = this.imageDisplayService.getActiveDatasetView(imageDisplay);
            ARGBScreenImage screenImage = view.getScreenImage();
            int[] argbPixels = view.getScreenImage().getData();
            int pixelIndex = (int)(this.cy * screenImage.dimension(0) + this.cx);
            int argb = argbPixels[pixelIndex];
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb >> 0 & 0xFF;
            this.color = new ColorRGB(r, g, b);
        }
        long numChannels = chanAxis == -1 ? 1L : this.dataset.dimension(chanAxis);
        LinkedList<Double> values = new LinkedList<Double>();
        for (long chan = 0L; chan < numChannels; ++chan) {
            this.setPosition(randomAccess, this.cx, this.cy, chan, otherPositions, xAxis, yAxis, chanAxis);
            double value = ((RealType)randomAccess.get()).getRealDouble();
            values.add(value);
        }
        this.channels = new ChannelCollection(values);
        return true;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public ChannelCollection getValues() {
        return this.channels;
    }

    public ColorRGB getColor() {
        return this.color;
    }

    public long getCX() {
        return this.cx;
    }

    public long getCY() {
        return this.cy;
    }

    public boolean wasAltKeyDown() {
        return this.wasAltKeyDown;
    }

    public void releaseDataset() {
        this.dataset = null;
    }

    private void setPosition(RandomAccess<? extends RealType<?>> randomAccess, long x, long y, long c, long[] otherCoordValues, int xAxis, int yAxis, int cAxis) {
        int i = 0;
        for (int d = 0; d < randomAccess.numDimensions(); ++d) {
            if (d == xAxis) {
                randomAccess.setPosition(x, xAxis);
                continue;
            }
            if (d == yAxis) {
                randomAccess.setPosition(y, yAxis);
                continue;
            }
            if (d == cAxis) {
                randomAccess.setPosition(c, cAxis);
                continue;
            }
            randomAccess.setPosition(otherCoordValues[i++], d);
        }
    }
}

