/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij.export;

import bdv.ij.export.imgloader.HuiskenImageLoader;
import bdv.ij.export.imgloader.StackImageLoader;
import bdv.spimdata.SequenceDescriptionMinimal;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.AffineModel3D;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.fusion.SPIMImageFusion;
import mpicbg.spim.io.ConfigurationParserException;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;
import mpicbg.spim.registration.bead.BeadRegistration;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;
import spim.vecmath.Point3f;
import spimopener.SPIMExperiment;

@Deprecated
public class SpimRegistrationSequence {
    private final SequenceDescriptionMinimal sequenceDescription;
    private final ViewRegistrations viewRegistrations;
    private final SPIMConfiguration conf;

    public SpimRegistrationSequence(SPIMConfiguration conf) {
        this.conf = conf;
        ArrayList<ViewSetup> setups = SpimRegistrationSequence.createViewSetups(conf);
        TimePoints timepoints = SpimRegistrationSequence.createTimePoints(conf);
        BasicImgLoader imgLoader = SpimRegistrationSequence.createImageLoader(conf, setups);
        this.viewRegistrations = SpimRegistrationSequence.createViewRegistrations(conf, setups);
        this.sequenceDescription = new SequenceDescriptionMinimal(timepoints, (Map)Entity.idMap(SpimRegistrationSequence.createViewSetups(conf)), imgLoader, null);
    }

    public SpimRegistrationSequence(String huiskenExperimentXmlFile, String channels, String angles, String timepoints, int referenceTimePoint) throws ConfigurationParserException {
        this(SpimRegistrationSequence.initExperimentConfiguration(huiskenExperimentXmlFile, "", channels, angles, timepoints, referenceTimePoint, false, 0.0));
    }

    public SpimRegistrationSequence(String inputDirectory, String inputFilePattern, String channels, String angles, String timepoints, int referenceTimePoint, boolean overrideImageZStretching, double zStretching) throws ConfigurationParserException {
        this(SpimRegistrationSequence.initExperimentConfiguration(inputDirectory, inputFilePattern, channels, angles, timepoints, referenceTimePoint, overrideImageZStretching, zStretching));
    }

    public SequenceDescriptionMinimal getSequenceDescription() {
        return this.sequenceDescription;
    }

    public ViewRegistrations getViewRegistrations() {
        return this.viewRegistrations;
    }

    protected static BasicImgLoader createImageLoader(SPIMConfiguration conf, ArrayList<ViewSetup> setups) {
        int numTimepoints = conf.timepoints.length;
        HashMap<ViewId, String> filenames = new HashMap<ViewId, String>();
        for (int timepoint = 0; timepoint < numTimepoints; ++timepoint) {
            int timepointId = conf.timepoints[timepoint];
            ViewStructure viewStructure = ViewStructure.initViewStructure((SPIMConfiguration)conf, (int)timepoint, (AbstractAffineModel3D)new AffineModel3D(), (String)("ViewStructure Timepoint " + timepointId), (int)conf.debugLevelInt);
            for (ViewDataBeads viewDataBeads : viewStructure.getViews()) {
                int angle = viewDataBeads.getAcqusitionAngle();
                int illumination = viewDataBeads.getIllumination();
                int channel = viewDataBeads.getChannel();
                int setupId = SpimRegistrationSequence.getViewSetupId(setups, angle, illumination, channel);
                filenames.put(new ViewId(timepointId, setupId), viewDataBeads.getFileName());
            }
        }
        if (conf.isHuiskenFormat()) {
            String exp = conf.inputdirectory.endsWith("/") ? conf.inputdirectory.substring(0, conf.inputdirectory.length() - 1) : conf.inputdirectory;
            return new HuiskenImageLoader(new File(exp + ".xml"), Entity.idMap(setups));
        }
        boolean useImageJOpener = conf.inputFilePattern.endsWith(".tif");
        return new StackImageLoader(filenames, useImageJOpener);
    }

    protected static SPIMConfiguration initExperimentConfiguration(String inputDirectory, String inputFilePattern, String angles, String timepoints, int referenceTimePoint, boolean overrideImageZStretching, double zStretching) throws ConfigurationParserException {
        return SpimRegistrationSequence.initExperimentConfiguration(inputDirectory, inputFilePattern, "", angles, timepoints, referenceTimePoint, overrideImageZStretching, zStretching);
    }

    protected static SPIMConfiguration initExperimentConfiguration(String inputDirectory, String inputFilePattern, String channels, String angles, String timepoints, int referenceTimePoint, boolean overrideImageZStretching, double zStretching) throws ConfigurationParserException {
        SPIMConfiguration conf = new SPIMConfiguration();
        conf.timepointPattern = timepoints;
        conf.channelsToFuse = channels == null ? "" : channels;
        conf.channelsToRegister = conf.channelsToFuse;
        conf.channelPattern = conf.channelsToFuse;
        conf.anglePattern = angles;
        File f = new File(inputDirectory);
        if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
            conf.spimExperiment = new SPIMExperiment(f.getAbsolutePath());
            conf.inputdirectory = f.getAbsolutePath().substring(0, f.getAbsolutePath().length() - 4) + "/";
        } else {
            conf.inputdirectory = inputDirectory;
        }
        conf.inputFilePattern = inputFilePattern;
        if (referenceTimePoint >= 0) {
            conf.timeLapseRegistration = true;
        }
        conf.referenceTimePoint = referenceTimePoint;
        conf.inputdirectory = conf.inputdirectory.replace('\\', '/');
        conf.inputdirectory = conf.inputdirectory.replaceAll("//", "/");
        conf.inputdirectory = conf.inputdirectory.trim();
        if (conf.inputdirectory.length() > 0 && !conf.inputdirectory.endsWith("/")) {
            conf.inputdirectory = conf.inputdirectory + "/";
        }
        conf.outputdirectory = conf.inputdirectory + "output/";
        conf.registrationFiledirectory = conf.inputdirectory + "registration/";
        conf.overrideImageZStretching = overrideImageZStretching;
        conf.zStretching = zStretching;
        conf.fuseOnly = true;
        if (conf.isHuiskenFormat()) {
            conf.getFilenamesHuisken();
        } else {
            conf.getFileNames();
        }
        return conf;
    }

    protected static ArrayList<ViewSetup> createViewSetups(SPIMConfiguration conf) {
        ArrayList<ViewSetup> setups = new ArrayList<ViewSetup>();
        int setup_id = 0;
        for (int channelIndex = 0; channelIndex < conf.file[0].length; ++channelIndex) {
            for (int angleIndex = 0; angleIndex < conf.file[0][channelIndex].length; ++angleIndex) {
                for (int illuminationIndex = 0; illuminationIndex < conf.file[0][channelIndex][angleIndex].length; ++illuminationIndex) {
                    String name = "";
                    if (conf.angles.length > 1) {
                        name = name + "a " + conf.angles[angleIndex];
                    }
                    if (conf.channels.length > 1) {
                        name = name + (name.isEmpty() ? "" : " ") + "c " + conf.channels[channelIndex];
                    }
                    if (conf.illuminations.length > 1) {
                        name = name + (name.isEmpty() ? "" : " ") + "i " + conf.illuminations[illuminationIndex];
                    }
                    Channel channel = new Channel(conf.channels[channelIndex]);
                    Angle angle = new Angle(conf.angles[angleIndex]);
                    Illumination illumination = new Illumination(conf.illuminations[illuminationIndex]);
                    FinalDimensions size = null;
                    FinalVoxelDimensions voxelSize = null;
                    ViewStructure viewStructure = ViewStructure.initViewStructure((SPIMConfiguration)conf, (int)0, (AbstractAffineModel3D)new AffineModel3D(), (String)"ViewStructure Timepoint 0", (int)conf.debugLevelInt);
                    for (ViewDataBeads viewDataBeads : viewStructure.getViews()) {
                        if (angle.getId() != viewDataBeads.getAcqusitionAngle() || illumination.getId() != viewDataBeads.getIllumination() || channel.getId() != viewDataBeads.getChannel()) continue;
                        voxelSize = new FinalVoxelDimensions("px", new double[]{1.0, 1.0, viewDataBeads.getZStretching()});
                        size = new FinalDimensions(viewDataBeads.getImageSize());
                        break;
                    }
                    setups.add(new ViewSetup(setup_id++, name, size, voxelSize, channel, angle, illumination));
                }
            }
        }
        return setups;
    }

    protected static TimePoints createTimePoints(SPIMConfiguration conf) {
        ArrayList<TimePoint> timepoints = new ArrayList<TimePoint>();
        for (int tp : conf.timepoints) {
            timepoints.add(new TimePoint(tp));
        }
        return new TimePoints(timepoints);
    }

    public Map<Integer, AffineTransform3D> getFusionTransforms(int cropOffsetX, int cropOffsetY, int cropOffsetZ, int scale) {
        this.conf.cropOffsetX = cropOffsetX;
        this.conf.cropOffsetY = cropOffsetY;
        this.conf.cropOffsetZ = cropOffsetZ;
        this.conf.scale = scale;
        HashMap<Integer, AffineTransform3D> transforms = new HashMap<Integer, AffineTransform3D>();
        if (this.conf.timeLapseRegistration) {
            SPIMConfiguration refconf = this.conf;
            if (this.conf.getTimePointIndex(this.conf.referenceTimePoint) < 0) {
                try {
                    String inputdirectory = this.conf.isHuiskenFormat() ? this.conf.inputdirectory.substring(0, this.conf.inputdirectory.length() - 1) + ".xml" : this.conf.inputdirectory;
                    refconf = SpimRegistrationSequence.initExperimentConfiguration(inputdirectory, this.conf.inputFilePattern, this.conf.anglePattern, "" + this.conf.referenceTimePoint, this.conf.referenceTimePoint, this.conf.overrideImageZStretching, this.conf.zStretching);
                    refconf.cropOffsetX = cropOffsetX;
                    refconf.cropOffsetY = cropOffsetY;
                    refconf.cropOffsetZ = cropOffsetZ;
                    refconf.scale = scale;
                }
                catch (ConfigurationParserException e) {
                    e.printStackTrace();
                }
            }
            RealInterval interval = SpimRegistrationSequence.getFusionBoundingBox(refconf, 0);
            double tx = interval.realMin(0);
            double ty = interval.realMin(1);
            double tz = interval.realMin(2);
            double s = scale;
            System.out.println("tx = " + tx + " ty = " + ty + " tz = " + tz + " scale = " + scale);
            AffineTransform3D transform = new AffineTransform3D();
            transform.set(s, 0.0, 0.0, tx, 0.0, s, 0.0, ty, 0.0, 0.0, s, tz);
            for (int tp : this.conf.timepoints) {
                transforms.put(tp, transform);
            }
        } else {
            for (int tp : this.conf.timepoints) {
                RealInterval interval = SpimRegistrationSequence.getFusionBoundingBox(this.conf, tp);
                double tx = interval.realMin(0);
                double ty = interval.realMin(1);
                double tz = interval.realMin(2);
                double s = scale;
                System.out.println("tx = " + tx + " ty = " + ty + " tz = " + tz + " scale = " + scale);
                AffineTransform3D transform = new AffineTransform3D();
                transform.set(s, 0.0, 0.0, tx, 0.0, s, 0.0, ty, 0.0, 0.0, s, tz);
                transforms.put(tp, transform);
            }
        }
        return transforms;
    }

    protected static RealInterval getFusionBoundingBox(SPIMConfiguration conf, int timepointId) {
        Point3f min = new Point3f();
        Point3f max = new Point3f();
        Point3f size = new Point3f();
        int tp = conf.getTimePointIndex(conf.timeLapseRegistration ? conf.referenceTimePoint : timepointId);
        ViewStructure reference = ViewStructure.initViewStructure((SPIMConfiguration)conf, (int)tp, (AbstractAffineModel3D)conf.getModel(), (String)("Reference ViewStructure Timepoint " + conf.referenceTimePoint), (int)conf.debugLevelInt);
        for (ViewDataBeads viewDataBeads : reference.getViews()) {
            if (conf.timeLapseRegistration) {
                viewDataBeads.loadRegistrationTimePoint(conf.referenceTimePoint);
            } else {
                viewDataBeads.loadRegistration();
            }
            BeadRegistration.concatenateAxialScaling((ViewDataBeads)viewDataBeads, (int)reference.getDebugLevel());
        }
        SPIMImageFusion.computeImageSize((ArrayList)reference.getViews(), (Point3f)min, (Point3f)max, (Point3f)size, (int)conf.scale, (int)conf.cropSizeX, (int)conf.cropSizeY, (int)conf.cropSizeZ, (int)reference.getDebugLevel());
        int scale = conf.scale;
        int cropOffsetX = conf.cropOffsetX;
        int cropOffsetY = conf.cropOffsetY;
        int cropOffsetZ = conf.cropOffsetZ;
        int imgW = conf.cropSizeX == 0 ? (Math.round((float)Math.ceil(size.x)) + 1) / scale : conf.cropSizeX / scale;
        int imgH = conf.cropSizeY == 0 ? (Math.round((float)Math.ceil(size.y)) + 1) / scale : conf.cropSizeY / scale;
        int imgD = conf.cropSizeZ == 0 ? (Math.round((float)Math.ceil(size.z)) + 1) / scale : conf.cropSizeZ / scale;
        return FinalRealInterval.createMinMax((double[])new double[]{(int)min.x + cropOffsetX, (int)min.y + cropOffsetY, (int)min.z + cropOffsetZ, (int)min.x + cropOffsetX + imgW - 1, (int)min.y + cropOffsetY + imgH - 1, (int)min.z + cropOffsetZ + imgD - 1});
    }

    protected static ViewRegistrations createViewRegistrations(SPIMConfiguration conf, ArrayList<ViewSetup> setups) {
        ArrayList<ViewRegistration> regs = new ArrayList<ViewRegistration>();
        for (int i = 0; i < conf.timepoints.length; ++i) {
            int timepointId = conf.timepoints[i];
            ViewStructure viewStructure = ViewStructure.initViewStructure((SPIMConfiguration)conf, (int)i, (AbstractAffineModel3D)new AffineModel3D(), (String)("ViewStructure Timepoint " + timepointId), (int)conf.debugLevelInt);
            for (ViewDataBeads viewDataBeads : viewStructure.getViews()) {
                if (conf.timeLapseRegistration) {
                    viewDataBeads.loadRegistrationTimePoint(conf.referenceTimePoint);
                } else {
                    viewDataBeads.loadRegistration();
                }
                BeadRegistration.concatenateAxialScaling((ViewDataBeads)viewDataBeads, (int)viewStructure.getDebugLevel());
                int angle = viewDataBeads.getAcqusitionAngle();
                int illumination = viewDataBeads.getIllumination();
                int channel = viewDataBeads.getChannel();
                AffineTransform3D model = new AffineTransform3D();
                double[][] tmp = new double[3][4];
                ((AffineModel3D)viewDataBeads.getTile().getModel()).toMatrix(tmp);
                model.set(tmp);
                int setupId = SpimRegistrationSequence.getViewSetupId(setups, angle, illumination, channel);
                regs.add(new ViewRegistration(timepointId, setupId, model));
            }
        }
        return new ViewRegistrations(regs);
    }

    protected static ArrayList<Integer> makeList(int[] ints) {
        ArrayList<Integer> list = new ArrayList<Integer>(ints.length);
        for (int i : ints) {
            list.add(i);
        }
        return list;
    }

    protected static int getViewSetupId(ArrayList<ViewSetup> setups, int angle, int illumination, int channel) {
        for (ViewSetup s : setups) {
            if (s.getAngle().getId() != angle || s.getIllumination().getId() != illumination || s.getChannel().getId() != channel) continue;
            return s.getId();
        }
        return -1;
    }

    public SPIMConfiguration getConf() {
        return this.conf;
    }
}

