/*
 * Decompiled with CFR 0.152.
 */
package fsalign;

import fsalign.FSAlignListener;
import fsalign.FolderWatcher;
import fsalign.ImageListener;
import ij.IJ;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.DirectoryChooser;
import ij.plugin.PlugIn;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Vector;
import mpicbg.trakem2.align.Align;

public class FS_Align_TrakEM2
implements PlugIn {
    private static final String REGEX_KEY = "fsalign.FSAlignTrakEM2.regex";
    private static final String REGEX_TEST_KEY = "fsalign.FSAlignTrakEM2.regextest";
    private static final String POLL_KEY = "fsalign.FSAlignTrakEM2.poll";
    private static final String APPEND_KEY = "fsalign.FSAlignTrakEM2.append";
    private String email;
    private String regexp;
    private int delayMS;
    private double thickness;
    private boolean doAppend;

    private void setupFinishWindow(FolderWatcher watcher) {
        Frame f = new Frame("File System Image Registration Plugin");
        Panel p = new Panel(new FlowLayout(1));
        Button b = new Button("Done");
        b.addActionListener(new DoneListener(f, watcher));
        p.add(b);
        f.add(p);
        f.pack();
        f.setVisible(true);
    }

    private boolean getPluginParams() {
        boolean tfOffset = false;
        GenericDialog gd = new GenericDialog("Folder Watch Alignment Plugin Settings");
        Button button = new Button("Update Result");
        Panel panel = new Panel(new FlowLayout(1));
        double pollTime = Prefs.get((String)POLL_KEY, (double)30.0);
        String regexField = Prefs.get((String)REGEX_KEY, (String)"Tile.*(tif|tiff|png)$");
        String regexTestField = Prefs.get((String)REGEX_TEST_KEY, (String)"Tile_r1-c1_Something Something.tif");
        boolean appendField = Prefs.get((String)APPEND_KEY, (String)"true").equals("true");
        panel.add(button);
        gd.addNumericField("Section Thickness (pixels)", 1.0, 2);
        gd.addCheckbox("Append After the Last Section", appendField);
        gd.addNumericField("Poll Frequency (seconds)", pollTime, 2);
        gd.addStringField("Regular Expression", regexField);
        gd.addMessage("Regular Expressions are used to match file names");
        gd.addMessage("Test your regular expression below");
        gd.addStringField("Test", regexTestField);
        gd.addStringField("Result", "");
        gd.addPanel(panel);
        Vector stringFields = gd.getStringFields();
        for (Object o : stringFields) {
            TextField tf = (TextField)o;
            tf.setColumns(96);
        }
        button.addActionListener(new RegexpListener((TextField)stringFields.get(0), (TextField)stringFields.get(1), (TextField)stringFields.get(2)));
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.thickness = gd.getNextNumber();
        this.delayMS = (int)(1000.0 * gd.getNextNumber());
        this.regexp = gd.getNextString();
        this.doAppend = gd.getNextBoolean();
        Prefs.set((String)POLL_KEY, (double)((double)this.delayMS / 1000.0));
        Prefs.set((String)REGEX_KEY, (String)this.regexp);
        Prefs.set((String)REGEX_TEST_KEY, (String)gd.getNextString());
        if (this.doAppend) {
            Prefs.set((String)APPEND_KEY, (String)"true");
        } else {
            Prefs.set((String)APPEND_KEY, (String)"false");
        }
        Prefs.savePreferences();
        return true;
    }

    private boolean getAlignParams() {
        GenericDialog gd = new GenericDialog("Alignment Parameters");
        Align.param.addFields(gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        Align.param.readFields(gd);
        return true;
    }

    public void run(String s) {
        Project trakemProject;
        Display display = Display.getFront();
        Project project = trakemProject = display == null ? null : display.getProject();
        if (trakemProject != null) {
            DirectoryChooser folderDialog = new DirectoryChooser("Choose Folder to Watch");
            String watchPath = folderDialog.getDirectory();
            if (!this.getPluginParams()) {
                return;
            }
            if (!this.getAlignParams()) {
                return;
            }
            FSAlignListener alignListener = new FSAlignListener(trakemProject, this.thickness, this.doAppend);
            alignListener.setNotifyEmail(this.email);
            try {
                FolderWatcher fw = ImageListener.imageFolderWatcher(watchPath, this.delayMS, alignListener, this.regexp);
                this.setupFinishWindow(fw);
                fw.start();
            }
            catch (IOException ioe) {
                IJ.log((String)("FS Align Plugin Caught IOException:\n" + ioe));
            }
        } else {
            GenericDialog gd = new GenericDialog("Need a TrakEM2 Project");
            gd.addMessage("Please either open a TrakEM2 project or create a new one through File->New->TrakEM2 Project");
            gd.showDialog();
        }
    }

    private static class DoneListener
    implements ActionListener {
        private final FolderWatcher watcher;
        private final Frame frame;

        public DoneListener(Frame f, FolderWatcher fw) {
            this.frame = f;
            this.watcher = fw;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GenericDialog gd = new GenericDialog("Sure?");
            gd.addMessage("Are You Sure?");
            gd.showDialog();
            if (gd.wasOKed()) {
                this.watcher.cancel();
                this.frame.dispose();
            }
        }
    }

    private static class RegexpListener
    implements ActionListener {
        final TextField tf0;
        final TextField tf1;
        final TextField tf2;

        public RegexpListener(TextField intf0, TextField intf1, TextField intf2) {
            this.tf0 = intf0;
            this.tf1 = intf1;
            this.tf2 = intf2;
            this.tf2.setEditable(false);
            this.actionPerformed(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean match = this.tf1.getText().matches(this.tf0.getText());
            String add = match ? " Matches" : " Does Not Match";
            this.tf2.setText(this.tf1.getText() + add);
        }
    }
}

