/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.network.shell;

import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.ui.ClusterXML;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NodeShellParameters {
    private final HashMap<String, String> parameterMap;
    private final HashMap<String, String> defaultParameterMap;
    private final ArrayList<String> fileKeys;
    private final ArrayList<String> stringKeys;
    private final ArrayList<String> floatKeys;
    private final ArrayList<String> intKeys;

    public NodeShellParameters() {
        this.parameterMap = new HashMap();
        this.defaultParameterMap = new HashMap();
        this.fileKeys = new ArrayList();
        this.intKeys = new ArrayList();
        this.floatKeys = new ArrayList();
        this.stringKeys = new ArrayList();
    }

    public NodeShellParameters(NodeShellParameters params) {
        this.parameterMap = new HashMap<String, String>(params.parameterMap);
        this.defaultParameterMap = new HashMap<String, String>(params.defaultParameterMap);
        this.fileKeys = new ArrayList<String>(params.fileKeys);
        this.intKeys = new ArrayList<String>(params.intKeys);
        this.floatKeys = new ArrayList<String>(params.floatKeys);
        this.stringKeys = new ArrayList<String>(params.stringKeys);
    }

    protected void addKey(String key, File defaultValue) {
        this.parameterMap.put(key, defaultValue.getAbsolutePath());
        this.defaultParameterMap.put(key, defaultValue.getAbsolutePath());
        this.fileKeys.add(key);
    }

    protected void addKey(String key, String defaultValue) {
        this.parameterMap.put(key, defaultValue);
        this.defaultParameterMap.put(key, defaultValue);
        this.stringKeys.add(key);
    }

    protected void addKey(String key, int defaultValue) {
        this.parameterMap.put(key, "" + defaultValue);
        this.defaultParameterMap.put(key, "" + defaultValue);
        this.intKeys.add(key);
    }

    protected void addKey(String key, float defaultValue) {
        this.parameterMap.put(key, "" + defaultValue);
        this.defaultParameterMap.put(key, "" + defaultValue);
        this.floatKeys.add(key);
    }

    private void checkKey(String key) throws Exception {
        if (!this.parameterMap.containsKey(key)) {
            throw new Exception("No such key: " + key);
        }
    }

    public int getInteger(String key) throws Exception {
        this.checkKey(key);
        String val = this.getString(key);
        return Integer.parseInt(val);
    }

    public float getFloat(String key) throws Exception {
        this.checkKey(key);
        String val = this.getString(key);
        return Float.parseFloat(val);
    }

    public String getStringOrEmpty(String key) {
        String val = this.parameterMap.get(key);
        return val == null ? "" : val;
    }

    public String getString(String key) throws Exception {
        this.checkKey(key);
        String val = this.parameterMap.get(key);
        if (val == null) {
            throw new Exception("Null value associated with key: " + key);
        }
        return val;
    }

    public Set<String> getKeys() {
        return this.parameterMap.keySet();
    }

    public boolean isFile(String key) {
        return this.fileKeys.contains(key);
    }

    public boolean isInt(String key) {
        return this.intKeys.contains(key);
    }

    public boolean isFloat(String key) {
        return this.floatKeys.contains(key);
    }

    public boolean isString(String key) {
        return this.stringKeys.contains(key);
    }

    public void putValue(String key, String value) throws Exception {
        if (!this.parameterMap.containsKey(key)) {
            throw new Exception("No such key: " + key);
        }
        this.parameterMap.put(key, value);
    }

    public void fromXML(Element e) throws Exception {
        NodeList children = e.getChildNodes();
        ArrayList<String> keyList = new ArrayList<String>(this.parameterMap.keySet());
        for (int i = 0; i < children.getLength() && !keyList.isEmpty(); ++i) {
            String name = children.item(i).getNodeName();
            if (!keyList.contains(name)) continue;
            String value = ClusterXML.replaceProperties(children.item(i).getTextContent());
            keyList.remove(name);
            FijiArchipelago.debug("fromXML: " + name + " <- " + value);
            this.parameterMap.put(name, value);
        }
        if (!keyList.isEmpty()) {
            throw new Exception("XML did not contain all parameter keys");
        }
    }

    public void toXML(Element e) throws Exception {
        for (String key : this.parameterMap.keySet()) {
            Element subE = e.getOwnerDocument().createElement(key);
            subE.appendChild(e.getOwnerDocument().createTextNode(this.getString(key)));
            e.appendChild(subE);
        }
    }

    public void merge(NodeShellParameters params) {
        for (String key : this.getKeys()) {
            if (this.getStringOrEmpty(key).equals(params.getStringOrEmpty(key))) continue;
            this.parameterMap.put(key, "");
        }
    }
}

