/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.downsample;

import net.imglib2.algorithm.blocks.BlockProcessor;
import net.imglib2.algorithm.blocks.downsample.AbstractDownsample;
import net.imglib2.algorithm.blocks.downsample.AbstractDownsampleAvgBlock;
import net.imglib2.algorithm.blocks.downsample.AbstractDownsampleHalfPixel;
import net.imglib2.type.PrimitiveType;

class DownsampleBlockProcessors {
    private static final int bw_float = 128;
    private static final int bw_double = 64;

    DownsampleBlockProcessors() {
    }

    private static void downsample_float(float[] source, int[] destSize, float[] dest, int dim) {
        if (dim == 0) {
            DownsampleBlockProcessors.downsampleX_float(source, destSize, dest);
        } else {
            DownsampleBlockProcessors.downsampleN_float(source, destSize, dest, dim);
        }
    }

    private static void downsampleX_float(float[] source, int[] destSize, float[] dest) {
        int len1 = destSize[0];
        int len2 = DownsampleBlockProcessors.mulDims(destSize, 1, destSize.length);
        for (int z = 0; z < len2; ++z) {
            int destOffsetZ = z * len1;
            int srcOffsetZ = z * (2 * len1 + 1);
            for (int x = 0; x < len1; ++x) {
                dest[destOffsetZ + x] = DownsampleBlockProcessors.wavg_float(source[srcOffsetZ + 2 * x], source[srcOffsetZ + 2 * x + 1], source[srcOffsetZ + 2 * x + 2]);
            }
        }
    }

    private static void downsampleN_float(float[] source, int[] destSize, float[] dest, int dim) {
        int len0 = DownsampleBlockProcessors.mulDims(destSize, 0, dim);
        int len1 = destSize[dim];
        int len2 = DownsampleBlockProcessors.mulDims(destSize, dim + 1, destSize.length);
        for (int z = 0; z < len2; ++z) {
            int destOffsetZ = z * len1 * len0;
            int srcOffsetZ = z * (2 * len1 + 1) * len0;
            for (int y = 0; y < len1; ++y) {
                int destOffset = destOffsetZ + y * len0;
                int srcOffset = srcOffsetZ + 2 * y * len0;
                for (int x = 0; x < len0; ++x) {
                    dest[destOffset + x] = DownsampleBlockProcessors.wavg_float(source[srcOffset + x], source[srcOffset + x + len0], source[srcOffset + x + 2 * len0]);
                }
            }
        }
    }

    private static float wavg_float(float a, float b, float c) {
        return 0.25f * (a + 2.0f * b + c);
    }

    private static void downsample_double(double[] source, int[] destSize, double[] dest, int dim) {
        if (dim == 0) {
            DownsampleBlockProcessors.downsampleX_double(source, destSize, dest);
        } else {
            DownsampleBlockProcessors.downsampleN_double(source, destSize, dest, dim);
        }
    }

    private static void downsampleX_double(double[] source, int[] destSize, double[] dest) {
        int len1 = destSize[0];
        int len2 = DownsampleBlockProcessors.mulDims(destSize, 1, destSize.length);
        for (int z = 0; z < len2; ++z) {
            int destOffsetZ = z * len1;
            int srcOffsetZ = z * (2 * len1 + 1);
            for (int x = 0; x < len1; ++x) {
                dest[destOffsetZ + x] = DownsampleBlockProcessors.wavg_double(source[srcOffsetZ + 2 * x], source[srcOffsetZ + 2 * x + 1], source[srcOffsetZ + 2 * x + 2]);
            }
        }
    }

    private static void downsampleN_double(double[] source, int[] destSize, double[] dest, int dim) {
        int len0 = DownsampleBlockProcessors.mulDims(destSize, 0, dim);
        int len1 = destSize[dim];
        int len2 = DownsampleBlockProcessors.mulDims(destSize, dim + 1, destSize.length);
        for (int z = 0; z < len2; ++z) {
            int destOffsetZ = z * len1 * len0;
            int srcOffsetZ = z * (2 * len1 + 1) * len0;
            for (int y = 0; y < len1; ++y) {
                int destOffset = destOffsetZ + y * len0;
                int srcOffset = srcOffsetZ + 2 * y * len0;
                for (int x = 0; x < len0; ++x) {
                    dest[destOffset + x] = DownsampleBlockProcessors.wavg_double(source[srcOffset + x], source[srcOffset + x + len0], source[srcOffset + x + 2 * len0]);
                }
            }
        }
    }

    private static double wavg_double(double a, double b, double c) {
        return 0.25 * (a + 2.0 * b + c);
    }

    private static void downsample_halfpixel_float(float[] source, int[] destSize, float[] dest, int dim) {
        if (dim == 0) {
            DownsampleBlockProcessors.downsampleX_halfpixel_float(source, destSize, dest);
        } else {
            DownsampleBlockProcessors.downsampleN_halfpixel_float(source, destSize, dest, dim);
        }
    }

    private static void downsampleX_halfpixel_float(float[] source, int[] destSize, float[] dest) {
        int len = DownsampleBlockProcessors.mulDims(destSize, 0, destSize.length);
        for (int x = 0; x < len; ++x) {
            dest[x] = DownsampleBlockProcessors.avg_float(source[2 * x], source[2 * x + 1]);
        }
    }

    private static void downsampleN_halfpixel_float(float[] source, int[] destSize, float[] dest, int dim) {
        int len0 = DownsampleBlockProcessors.mulDims(destSize, 0, dim);
        int len1 = DownsampleBlockProcessors.mulDims(destSize, dim, destSize.length);
        for (int y = 0; y < len1; ++y) {
            int destOffset = y * len0;
            int srcOffset = 2 * destOffset;
            for (int x = 0; x < len0; ++x) {
                dest[destOffset + x] = DownsampleBlockProcessors.avg_float(source[srcOffset + x], source[srcOffset + x + len0]);
            }
        }
    }

    private static float avg_float(float a, float b) {
        return 0.5f * (a + b);
    }

    private static void downsample_halfpixel_double(double[] source, int[] destSize, double[] dest, int dim) {
        if (dim == 0) {
            DownsampleBlockProcessors.downsampleX_halfpixel_double(source, destSize, dest);
        } else {
            DownsampleBlockProcessors.downsampleN_halfpixel_double(source, destSize, dest, dim);
        }
    }

    private static void downsampleX_halfpixel_double(double[] source, int[] destSize, double[] dest) {
        int len = DownsampleBlockProcessors.mulDims(destSize, 0, destSize.length);
        for (int x = 0; x < len; ++x) {
            dest[x] = DownsampleBlockProcessors.avg_double(source[2 * x], source[2 * x + 1]);
        }
    }

    private static void downsampleN_halfpixel_double(double[] source, int[] destSize, double[] dest, int dim) {
        int len0 = DownsampleBlockProcessors.mulDims(destSize, 0, dim);
        int len1 = DownsampleBlockProcessors.mulDims(destSize, dim, destSize.length);
        for (int y = 0; y < len1; ++y) {
            int destOffset = y * len0;
            int srcOffset = 2 * destOffset;
            for (int x = 0; x < len0; ++x) {
                dest[destOffset + x] = DownsampleBlockProcessors.avg_double(source[srcOffset + x], source[srcOffset + x + len0]);
            }
        }
    }

    private static double avg_double(double a, double b) {
        return 0.5 * (a + b);
    }

    private static void downsample_avgblock_float(float[] source, int[] destSize, float[] dest, int dim, int factor) {
        if (factor == 2) {
            DownsampleBlockProcessors.downsample_halfpixel_float(source, destSize, dest, dim);
        } else if (dim == 0) {
            DownsampleBlockProcessors.downsampleX_avgblock_float(source, destSize, dest, factor);
        } else {
            DownsampleBlockProcessors.downsampleN_avgblock_float(source, destSize, dest, dim, factor);
        }
    }

    private static void downsampleX_avgblock_float(float[] source, int[] destSize, float[] dest, int factor) {
        float scale = (float)(1.0 / (double)factor);
        int len = DownsampleBlockProcessors.mulDims(destSize, 0, destSize.length);
        int nBlocks = (len - 1) / 128 + 1;
        int trailing = len - (nBlocks - 1) * 128;
        for (int b = 0; b < nBlocks; ++b) {
            int x;
            int tob = b * 128;
            int bwb = b == nBlocks - 1 ? trailing : 128;
            int sob = factor * tob;
            for (x = 0; x < bwb; ++x) {
                dest[tob + x] = source[sob + factor * x];
            }
            for (int i = 1; i < factor; ++i) {
                int sobi = sob + i;
                for (int x2 = 0; x2 < bwb; ++x2) {
                    int n = tob + x2;
                    dest[n] = dest[n] + source[sobi + factor * x2];
                }
            }
            for (x = 0; x < bwb; ++x) {
                int n = tob + x;
                dest[n] = dest[n] * scale;
            }
        }
    }

    private static void downsampleN_avgblock_float(float[] source, int[] destSize, float[] dest, int dim, int factor) {
        float scale = (float)(1.0 / (double)factor);
        int len0 = DownsampleBlockProcessors.mulDims(destSize, 0, dim);
        int len1 = DownsampleBlockProcessors.mulDims(destSize, dim, destSize.length);
        int nBlocks = (len0 - 1) / 128 + 1;
        int trailing = len0 - (nBlocks - 1) * 128;
        for (int y = 0; y < len1; ++y) {
            int destOffset = y * len0;
            for (int b = 0; b < nBlocks; ++b) {
                int tob = b * 128 + destOffset;
                int bwb = b == nBlocks - 1 ? trailing : 128;
                int sob = factor * destOffset + b * 128;
                System.arraycopy(source, sob, dest, tob, bwb);
                for (int i = 1; i < factor; ++i) {
                    int sobi = sob + i * len0;
                    for (int x = 0; x < bwb; ++x) {
                        int n = tob + x;
                        dest[n] = dest[n] + source[sobi + x];
                    }
                }
                for (int x = 0; x < bwb; ++x) {
                    int n = tob + x;
                    dest[n] = dest[n] * scale;
                }
            }
        }
    }

    private static void downsample_avgblock_double(double[] source, int[] destSize, double[] dest, int dim, int factor) {
        if (factor == 2) {
            DownsampleBlockProcessors.downsample_halfpixel_double(source, destSize, dest, dim);
        } else if (dim == 0) {
            DownsampleBlockProcessors.downsampleX_avgblock_double(source, destSize, dest, factor);
        } else {
            DownsampleBlockProcessors.downsampleN_avgblock_double(source, destSize, dest, dim, factor);
        }
    }

    private static void downsampleX_avgblock_double(double[] source, int[] destSize, double[] dest, int factor) {
        double scale = 1.0 / (double)factor;
        int len = DownsampleBlockProcessors.mulDims(destSize, 0, destSize.length);
        int nBlocks = (len - 1) / 64 + 1;
        int trailing = len - (nBlocks - 1) * 64;
        for (int b = 0; b < nBlocks; ++b) {
            int x;
            int tob = b * 64;
            int bwb = b == nBlocks - 1 ? trailing : 64;
            int sob = factor * tob;
            for (x = 0; x < bwb; ++x) {
                dest[tob + x] = source[sob + factor * x];
            }
            for (int i = 1; i < factor; ++i) {
                int sobi = sob + i;
                for (int x2 = 0; x2 < bwb; ++x2) {
                    int n = tob + x2;
                    dest[n] = dest[n] + source[sobi + factor * x2];
                }
            }
            for (x = 0; x < bwb; ++x) {
                int n = tob + x;
                dest[n] = dest[n] * scale;
            }
        }
    }

    private static void downsampleN_avgblock_double(double[] source, int[] destSize, double[] dest, int dim, int factor) {
        double scale = 1.0 / (double)factor;
        int len0 = DownsampleBlockProcessors.mulDims(destSize, 0, dim);
        int len1 = DownsampleBlockProcessors.mulDims(destSize, dim, destSize.length);
        int nBlocks = (len0 - 1) / 64 + 1;
        int trailing = len0 - (nBlocks - 1) * 64;
        for (int y = 0; y < len1; ++y) {
            int destOffset = y * len0;
            for (int b = 0; b < nBlocks; ++b) {
                int tob = b * 64 + destOffset;
                int bwb = b == nBlocks - 1 ? trailing : 64;
                int sob = factor * destOffset + b * 64;
                System.arraycopy(source, sob, dest, tob, bwb);
                for (int i = 1; i < factor; ++i) {
                    int sobi = sob + i * len0;
                    for (int x = 0; x < bwb; ++x) {
                        int n = tob + x;
                        dest[n] = dest[n] + source[sobi + x];
                    }
                }
                for (int x = 0; x < bwb; ++x) {
                    int n = tob + x;
                    dest[n] = dest[n] * scale;
                }
            }
        }
    }

    private static int mulDims(int[] dims, int from, int to) {
        int product = 1;
        for (int d = from; d < to; ++d) {
            product *= dims[d];
        }
        return product;
    }

    static class AvgBlockDouble
    extends AbstractDownsampleAvgBlock<AvgBlockDouble, double[]> {
        public AvgBlockDouble(int[] downsamplingFactors) {
            super(downsamplingFactors, PrimitiveType.DOUBLE);
        }

        private AvgBlockDouble(AvgBlockDouble downsample) {
            super(downsample);
        }

        @Override
        public BlockProcessor<double[], double[]> independentCopy() {
            return new AvgBlockDouble(this);
        }

        @Override
        void downsample(double[] source, int[] destSize, double[] dest, int dim) {
            int factor = this.downsamplingFactors[dim];
            DownsampleBlockProcessors.downsample_avgblock_double(source, destSize, dest, dim, factor);
        }
    }

    static class AvgBlockFloat
    extends AbstractDownsampleAvgBlock<AvgBlockFloat, float[]> {
        public AvgBlockFloat(int[] downsamplingFactors) {
            super(downsamplingFactors, PrimitiveType.FLOAT);
        }

        private AvgBlockFloat(AvgBlockFloat downsample) {
            super(downsample);
        }

        @Override
        public BlockProcessor<float[], float[]> independentCopy() {
            return new AvgBlockFloat(this);
        }

        @Override
        void downsample(float[] source, int[] destSize, float[] dest, int dim) {
            int factor = this.downsamplingFactors[dim];
            DownsampleBlockProcessors.downsample_avgblock_float(source, destSize, dest, dim, factor);
        }
    }

    static class HalfPixelDouble
    extends AbstractDownsampleHalfPixel<HalfPixelDouble, double[]> {
        public HalfPixelDouble(boolean[] downsampleInDim) {
            super(downsampleInDim, PrimitiveType.DOUBLE);
        }

        private HalfPixelDouble(HalfPixelDouble downsample) {
            super(downsample);
        }

        @Override
        public BlockProcessor<double[], double[]> independentCopy() {
            return new HalfPixelDouble(this);
        }

        @Override
        void downsample(double[] source, int[] destSize, double[] dest, int dim) {
            DownsampleBlockProcessors.downsample_halfpixel_double(source, destSize, dest, dim);
        }
    }

    static class HalfPixelFloat
    extends AbstractDownsampleHalfPixel<HalfPixelFloat, float[]> {
        public HalfPixelFloat(boolean[] downsampleInDim) {
            super(downsampleInDim, PrimitiveType.FLOAT);
        }

        private HalfPixelFloat(HalfPixelFloat downsample) {
            super(downsample);
        }

        @Override
        public BlockProcessor<float[], float[]> independentCopy() {
            return new HalfPixelFloat(this);
        }

        @Override
        void downsample(float[] source, int[] destSize, float[] dest, int dim) {
            DownsampleBlockProcessors.downsample_halfpixel_float(source, destSize, dest, dim);
        }
    }

    static class CenterDouble
    extends AbstractDownsample<CenterDouble, double[]> {
        public CenterDouble(boolean[] downsampleInDim) {
            super(downsampleInDim, PrimitiveType.DOUBLE);
        }

        private CenterDouble(CenterDouble downsample) {
            super(downsample);
        }

        @Override
        public BlockProcessor<double[], double[]> independentCopy() {
            return new CenterDouble(this);
        }

        @Override
        void downsample(double[] source, int[] destSize, double[] dest, int dim) {
            DownsampleBlockProcessors.downsample_double(source, destSize, dest, dim);
        }
    }

    static class CenterFloat
    extends AbstractDownsample<CenterFloat, float[]> {
        public CenterFloat(boolean[] downsampleInDim) {
            super(downsampleInDim, PrimitiveType.FLOAT);
        }

        private CenterFloat(CenterFloat downsample) {
            super(downsample);
        }

        @Override
        public BlockProcessor<float[], float[]> independentCopy() {
            return new CenterFloat(this);
        }

        @Override
        void downsample(float[] source, int[] destSize, float[] dest, int dim) {
            DownsampleBlockProcessors.downsample_float(source, destSize, dest, dim);
        }
    }
}

