/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.convolution;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.convolution.Concatenation;

public interface Convolution<T> {
    public Interval requiredSourceInterval(Interval var1);

    public T preferredSourceType(T var1);

    @Deprecated
    default public void setExecutor(ExecutorService executor) {
    }

    public void process(RandomAccessible<? extends T> var1, RandomAccessibleInterval<? extends T> var2);

    public static <T> Convolution<T> concat(Convolution<T> ... steps) {
        return Convolution.concat(Arrays.asList(steps));
    }

    public static <T> Convolution<T> concat(List<? extends Convolution<T>> steps) {
        if (steps.isEmpty()) {
            throw new IllegalArgumentException("Concat requires at least one convolution operation.");
        }
        if (steps.size() == 1) {
            return steps.get(0);
        }
        return new Concatenation(steps);
    }
}

