/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math;

import java.util.Map;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.math.abstractions.IFunction;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.algorithm.math.abstractions.RandomAccessOnly;
import net.imglib2.algorithm.math.abstractions.ViewableFunction;
import net.imglib2.algorithm.math.execution.LetBinding;
import net.imglib2.algorithm.math.execution.RandomAccessibleOffsetSource;
import net.imglib2.algorithm.math.execution.RandomAccessibleOffsetSourceDirect;
import net.imglib2.algorithm.math.execution.Variable;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.RealType;

public class RandomAccessibleSource<I extends RealType<I>>
extends ViewableFunction
implements IFunction,
RandomAccessOnly<I> {
    private final RandomAccessible<I> src;
    private final long[] offset;

    public RandomAccessibleSource(RandomAccessible<I> src) {
        this.src = src;
        this.offset = new long[src.numDimensions()];
    }

    public RandomAccessibleSource(RandomAccessible<I> src, long[] offset) {
        this.src = src;
        this.offset = offset;
    }

    @Override
    public <O extends RealType<O>> OFunction<O> reInit(O tmp, Map<String, LetBinding<O>> bindings, Converter<RealType<?>, O> converter, Map<Variable<O>, OFunction<O>> imgSources) {
        if (tmp.getClass().isAssignableFrom(((RealType)this.src.randomAccess().get()).getClass())) {
            return new RandomAccessibleOffsetSourceDirect<RealType>((RealType)tmp.copy(), this.src, this.offset);
        }
        return new RandomAccessibleOffsetSource<I, RealType>((RealType)tmp.copy(), converter, this.src, this.offset);
    }

    @Override
    public RandomAccessible<I> getRandomAccessible() {
        return this.src;
    }
}

