/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.util.unionfind;

import java.util.Arrays;
import net.imglib2.algorithm.util.unionfind.UnionFind;

public class IntArrayRankedUnionFind
implements UnionFind {
    private final int[] parents;
    private final int[] ranks;
    private int nSets;

    public IntArrayRankedUnionFind(int size) {
        this(IntArrayRankedUnionFind.intRange(new int[size]), new int[size], size);
    }

    private IntArrayRankedUnionFind(int[] parents, int[] ranks, int nSets) {
        this.parents = parents;
        this.ranks = ranks;
        this.nSets = nSets;
    }

    public int findRoot(int id) {
        int startIndex1 = id;
        int startIndex2 = id;
        int tmp = id;
        while (startIndex1 != this.parents[startIndex1]) {
            startIndex1 = this.parents[startIndex1];
        }
        while (startIndex2 != startIndex1) {
            tmp = this.parents[startIndex2];
            this.parents[startIndex2] = startIndex1;
            startIndex2 = tmp;
        }
        return startIndex1;
    }

    public int join(int id1, int id2) {
        if (id1 == id2) {
            return id1;
        }
        --this.nSets;
        int r1 = this.ranks[id1];
        int r2 = this.ranks[id2];
        if (r1 < r2) {
            this.parents[id1] = id2;
            return id2;
        }
        this.parents[id2] = id1;
        if (r1 == r2) {
            this.ranks[id1] = r1 + 1;
        }
        return id1;
    }

    @Override
    public long findRoot(long id) {
        return this.findRoot((int)id);
    }

    @Override
    public long join(long id1, long id2) {
        return this.join((int)id1, (int)id2);
    }

    @Override
    public long size() {
        return this.intSize();
    }

    @Override
    public long setCount() {
        return this.intSetCount();
    }

    public int intSize() {
        return this.parents.length;
    }

    public int intSetCount() {
        return this.nSets;
    }

    private static int[] intRange(int[] data) {
        return IntArrayRankedUnionFind.intRange(data, 0);
    }

    private static int[] intRange(int[] data, int offset) {
        Arrays.setAll(data, d -> d + offset);
        return data;
    }
}

