/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import mpicbg.spim.io.ConfigurationParserGeneral;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.ProgramConfiguration;
import mpicbg.spim.io.TextFileAccess;

public class ClusterReconstruction {
    protected static Method setReadable;
    protected static Method setWritable;
    protected static Method setExecutable;

    public static void main(String[] args) {
        ProgramConfiguration conf = null;
        try {
            conf = ConfigurationParserGeneral.parseFile("config/configuration.txt");
        }
        catch (Exception e) {
            IOFunctions.printErr("Cannot open configuration file: " + e);
            e.printStackTrace();
            return;
        }
        conf.printParameters();
        for (int timePointIndex = 0; timePointIndex < conf.timepoints.length; ++timePointIndex) {
            String spimConfigFile = conf.baseFolder + conf.configFolder + conf.configFileTemplate + "_" + timePointIndex + ".txt";
            String spimConfigTemplate = conf.baseFolder + conf.configFolder + conf.configFileTemplate;
            try {
                BufferedReader in = TextFileAccess.openFileRead(spimConfigTemplate);
                PrintWriter out = TextFileAccess.openFileWrite(spimConfigFile);
                while (in.ready()) {
                    String line = in.readLine();
                    if (line.startsWith("Time Point Pattern = ")) {
                        line = "Time Point Pattern = \"" + conf.timepoints[timePointIndex] + "\"";
                    }
                    out.println(line);
                }
                in.close();
                out.close();
            }
            catch (Exception e) {
                IOFunctions.printErr("Cannot read spim configuration template from: '" + spimConfigTemplate + "'");
                IOFunctions.printErr("Cannot write spim configuration to: '" + spimConfigFile + "'");
                IOFunctions.printErr(e);
                e.printStackTrace();
                System.exit(0);
            }
            String jobFile = conf.baseFolder + conf.jobFolder + "jobspim_" + timePointIndex;
            try {
                PrintWriter job = TextFileAccess.openFileWrite(jobFile);
                job.println("#!/bin/sh");
                job.println("#$ -S /bin/sh");
                job.println("cd " + conf.baseFolder);
                job.println(conf.javaExecutable + " " + conf.javaArguments + " -cp " + conf.binariesFolder + ClusterReconstruction.getLibraries(conf.baseFolder + conf.librariesFolder) + ":/home/tomancak/ImageJ/ij.jar mpi.fruitfly.spim.Reconstruction " + spimConfigFile);
                job.close();
            }
            catch (Exception e) {
                IOFunctions.printErr("Cannot write spim job file: '" + jobFile + "'");
                IOFunctions.printErr(e);
                e.printStackTrace();
                System.exit(0);
            }
            File f = new File(jobFile);
            ClusterReconstruction.setReadable(f, true, false);
            ClusterReconstruction.setWritable(f, true, false);
            ClusterReconstruction.setExecutable(f, true, false);
        }
        String submissionFile = conf.baseFolder + "submitjobs";
        try {
            PrintWriter submissionScript = TextFileAccess.openFileWrite(submissionFile);
            submissionScript.println("#!/bin/sh");
            submissionScript.println("");
            for (int timePointIndex = 0; timePointIndex < conf.timepoints.length; ++timePointIndex) {
                submissionScript.println("qsub -P spim " + conf.baseFolder + conf.jobFolder + "jobspim_" + timePointIndex);
            }
            submissionScript.close();
        }
        catch (Exception e) {
            IOFunctions.printErr("Cannot write submission file: '" + submissionFile + "'");
            IOFunctions.printErr(e);
            e.printStackTrace();
            System.exit(0);
        }
        File f = new File(submissionFile);
        ClusterReconstruction.setReadable(f, true, false);
        ClusterReconstruction.setWritable(f, true, false);
        ClusterReconstruction.setExecutable(f, true, false);
    }

    protected static String getLibraries(String directory) {
        String[] libraries;
        String libString = "";
        for (String lib : libraries = ClusterReconstruction.getDirectoryListingOfFiles(directory, ".jar")) {
            libString = libString + ":" + lib;
        }
        return libString;
    }

    private static String[] getDirectoryListingOfFiles(String directory, final String filterFileName) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.toUpperCase().endsWith(filterFileName.toUpperCase())) {
                    File f = new File(dir, name);
                    return f.isFile();
                }
                return false;
            }
        };
        File dir = new File(directory);
        Object[] children = dir.list(filter);
        Arrays.sort(children);
        for (int i = 0; i < children.length; ++i) {
            children[i] = dir + "/" + (String)children[i];
            children[i] = ((String)children[i]).replace('\\', '/');
        }
        return children;
    }

    public static void getMovements(String directory, String extension) {
        String[] regFiles = ClusterReconstruction.getDirectoryListingOfFiles(directory, extension);
        IOFunctions.println("Timepoint\tx\ty\tz");
        String lasttimepoint = "";
        for (String file : regFiles) {
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            String timepoint = file.substring(file.indexOf("TL") + 2, file.indexOf("Angle") - 1);
            try {
                BufferedReader in = TextFileAccess.openFileRead(file);
                while (in.ready()) {
                    String line = in.readLine().trim();
                    if (line.startsWith("m03:")) {
                        x = Float.parseFloat(line.substring(line.indexOf(":") + 1, line.length()));
                        continue;
                    }
                    if (line.startsWith("m13:")) {
                        y = Float.parseFloat(line.substring(line.indexOf(":") + 1, line.length()));
                        continue;
                    }
                    if (!line.startsWith("m23:")) continue;
                    z = Float.parseFloat(line.substring(line.indexOf(":") + 1, line.length()));
                }
                in.close();
                if (!timepoint.equals(lasttimepoint)) {
                    IOFunctions.println(timepoint + "\t" + x + "\t" + y + "\t" + z);
                }
                lasttimepoint = timepoint;
            }
            catch (Exception e) {
                IOFunctions.printErr("Cannot read file: " + file);
                e.printStackTrace();
                System.exit(0);
            }
        }
    }

    public static void getDisplacements(String directory) {
        String[] regFiles = ClusterReconstruction.getDirectoryListingOfFiles(directory, ".registration");
        IOFunctions.println("Timepoint\tavg\tmin\tmax");
        String lasttimepoint = "";
        for (String file : regFiles) {
            float min = 0.0f;
            float avg = 0.0f;
            float max = 0.0f;
            String timepoint = file.substring(file.indexOf("TL") + 2, file.indexOf("Angle") - 1);
            try {
                BufferedReader in = TextFileAccess.openFileRead(file);
                while (in.ready()) {
                    String line = in.readLine().trim();
                    if (line.startsWith("minError:")) {
                        min = Float.parseFloat(line.substring(line.indexOf(":") + 1, line.length()));
                        continue;
                    }
                    if (line.startsWith("maxError:")) {
                        max = Float.parseFloat(line.substring(line.indexOf(":") + 1, line.length()));
                        continue;
                    }
                    if (!line.startsWith("avgError:")) continue;
                    avg = Float.parseFloat(line.substring(line.indexOf(":") + 1, line.length()));
                }
                in.close();
                if (!timepoint.equals(lasttimepoint)) {
                    IOFunctions.println(timepoint + "\t" + avg + "\t" + min + "\t" + max);
                }
                lasttimepoint = timepoint;
            }
            catch (Exception e) {
                IOFunctions.printErr("Cannot read file: " + file);
                e.printStackTrace();
                System.exit(0);
            }
        }
    }

    protected static boolean setReadable(File file, boolean readable, boolean ownerOnly) {
        try {
            return (Boolean)setReadable.invoke((Object)file, readable, ownerOnly);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static boolean setWritable(File file, boolean writable, boolean ownerOnly) {
        try {
            return (Boolean)setWritable.invoke((Object)file, writable, ownerOnly);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static boolean setExecutable(File file, boolean executable, boolean ownerOnly) {
        try {
            return (Boolean)setExecutable.invoke((Object)file, executable, ownerOnly);
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        try {
            Class<?> file = Class.forName("java.io.File");
            Class[] types = new Class[]{Boolean.TYPE, Boolean.TYPE};
            setReadable = file.getMethod("setReadable", types);
            setWritable = file.getMethod("setWritable", types);
            setExecutable = file.getMethod("setExecutable", types);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

