/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin;

import ij.ImageJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import spim.fiji.plugin.interestpointdetection.DifferenceOf;
import spim.fiji.plugin.interestpointdetection.DifferenceOfGaussian;
import spim.fiji.plugin.interestpointdetection.DifferenceOfMean;
import spim.fiji.plugin.interestpointdetection.InterestPointDetection;
import spim.fiji.plugin.queryXML.LoadParseQueryXML;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.imgloaders.AbstractImgLoader;
import spim.fiji.spimdata.interestpoints.CorrespondingInterestPoints;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.fiji.spimdata.interestpoints.InterestPointList;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;

public class Interest_Point_Detection
implements PlugIn {
    public static ArrayList<InterestPointDetection> staticAlgorithms = new ArrayList();
    public static int defaultAlgorithm = 1;
    public static boolean defaultDownSample = true;
    public static boolean defaultDefineAnisotropy = false;
    public static boolean defaultAdditionalSmoothing = false;
    public static boolean defaultSetMinMax = false;
    public static boolean defaultLimitDetections = false;
    public static String defaultLabel = "beads";

    public void run(String arg) {
        LoadParseQueryXML result = new LoadParseQueryXML();
        if (!result.queryXML("perfoming interest point detection", true, true, true, true)) {
            return;
        }
        this.detectInterestPoints((SpimData2)((Object)result.getData()), SpimData2.getAllViewIdsSorted((SpimData)result.getData(), result.getViewSetupsToProcess(), result.getTimePointsToProcess()), result.getClusterExtension(), result.getXMLFileName(), true);
    }

    public boolean detectInterestPoints(SpimData2 data, List<ViewId> viewIds) {
        return this.detectInterestPoints(data, viewIds, "", null, false);
    }

    public boolean detectInterestPoints(SpimData2 data, List<ViewId> viewIds, String xmlFileName, boolean saveXML) {
        return this.detectInterestPoints(data, viewIds, "", xmlFileName, saveXML);
    }

    public boolean detectInterestPoints(SpimData2 data, List<ViewId> viewIds, String clusterExtension, String xmlFileName, boolean saveXML) {
        String[] descriptions = new String[staticAlgorithms.size()];
        for (int i = 0; i < staticAlgorithms.size(); ++i) {
            descriptions[i] = staticAlgorithms.get(i).getDescription();
        }
        if (defaultAlgorithm >= descriptions.length) {
            defaultAlgorithm = 0;
        }
        GenericDialog gd = new GenericDialog("Detect Interest Points");
        gd.addChoice("Type_of_interest_point_detection", descriptions, descriptions[defaultAlgorithm]);
        gd.addStringField("Label_interest_points", defaultLabel);
        gd.addMessage("");
        gd.addMessage("Channels to detect interest points in", GUIHelper.largefont);
        ArrayList<Channel> channels = SpimData2.getAllChannelsSorted(data, viewIds);
        for (int i = 0; i < channels.size(); ++i) {
            gd.addMessage("Channel " + channels.get(i).getName(), GUIHelper.smallStatusFont);
        }
        gd.addMessage("");
        gd.addCheckbox("Downsample_images prior to segmentation", defaultDownSample);
        gd.addCheckbox("Define_anisotropy for segmentation", defaultDefineAnisotropy);
        gd.addCheckbox("Additional_smoothing", defaultAdditionalSmoothing);
        gd.addCheckbox("Set_minimal_and_maximal_intensity", defaultSetMinMax);
        gd.addCheckbox("Limit_amount_of_detections", defaultLimitDetections);
        gd.addMessage("");
        GUIHelper.addWebsite(gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        int algorithm = defaultAlgorithm = gd.getNextChoiceIndex();
        String label = defaultLabel = gd.getNextString();
        ArrayList<Channel> channelsToProcess = new ArrayList<Channel>();
        for (int i = 0; i < channels.size(); ++i) {
            channelsToProcess.add(channels.get(i));
        }
        boolean downsample = defaultDownSample = gd.getNextBoolean();
        boolean defineAnisotropy = defaultDefineAnisotropy = gd.getNextBoolean();
        boolean additionalSmoothing = defaultAdditionalSmoothing = gd.getNextBoolean();
        boolean setMinMax = defaultSetMinMax = gd.getNextBoolean();
        boolean limitDetections = defaultLimitDetections = gd.getNextBoolean();
        InterestPointDetection ipd = staticAlgorithms.get(algorithm).newInstance(data, viewIds);
        if (!ipd.queryParameters(downsample, defineAnisotropy, additionalSmoothing, setMinMax, limitDetections)) {
            return false;
        }
        for (TimePoint tp : SpimData2.getAllTimePointsSorted(data, viewIds)) {
            HashMap<ViewId, List<InterestPoint>> points = ipd.findInterestPoints(tp);
            if (ipd instanceof DifferenceOf) {
                IOFunctions.println("Opening of files took: " + ((DifferenceOf)ipd).getBenchmark().openFiles / 1000L + " sec.");
                IOFunctions.println("Detecting interest points took: " + ((DifferenceOf)ipd).getBenchmark().computation / 1000L + " sec.");
            }
            SequenceDescription seqDesc = (SequenceDescription)data.getSequenceDescription();
            for (ViewId viewId : points.keySet()) {
                ViewDescription viewDesc = seqDesc.getViewDescription(viewId.getTimePointId(), viewId.getViewSetupId());
                int channelId = ((ViewSetup)viewDesc.getViewSetup()).getChannel().getId();
                InterestPointList list = new InterestPointList(data.getBasePath(), new File("interestpoints", "tpId_" + viewId.getTimePointId() + "_viewSetupId_" + viewId.getViewSetupId() + "." + label));
                list.setParameters(ipd.getParameters(channelId));
                list.setInterestPoints(points.get(viewId));
                if (saveXML) {
                    if (!list.saveInterestPoints()) {
                        IOFunctions.println("Error saving interest point list: " + new File(list.getBaseDir(), list.getFile().toString() + list.getInterestPointsExt()));
                        return false;
                    }
                    list.setCorrespondingInterestPoints(new ArrayList<CorrespondingInterestPoints>());
                    if (!list.saveCorrespondingInterestPoints()) {
                        IOFunctions.println("Failed to clear corresponding interest point list: " + new File(list.getBaseDir(), list.getFile().toString() + list.getCorrespondencesExt()));
                    }
                }
                ViewInterestPointLists vipl = data.getViewInterestPoints().getViewInterestPointLists(viewId);
                vipl.addInterestPointList(label, list);
            }
            if (((SequenceDescription)data.getSequenceDescription()).getImgLoader() instanceof AbstractImgLoader) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Updating metadata ... ");
                try {
                    ((AbstractImgLoader)((SequenceDescription)data.getSequenceDescription()).getImgLoader()).updateXMLMetaData(data, false);
                }
                catch (Exception e) {
                    IOFunctions.println("Failed to update metadata, this should not happen: " + e);
                }
            }
            if (!saveXML) continue;
            SpimData2.saveXML(data, xmlFileName, clusterExtension);
        }
        return true;
    }

    public static void main(String[] args) {
        new ImageJ();
        new Interest_Point_Detection().run(null);
    }

    static {
        IOFunctions.printIJLog = true;
        staticAlgorithms.add(new DifferenceOfMean(null, null));
        staticAlgorithms.add(new DifferenceOfGaussian(null, null));
    }
}

