/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.fusion;

import ij.gui.GenericDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import net.imglib2.Dimensions;
import net.imglib2.util.Intervals;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.ViewSetupUtils;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.export.ImgExport;

public abstract class Fusion {
    public static String[] interpolationTypes = new String[]{"Nearest Neighbor", "Linear Interpolation"};
    public static int defaultInterpolation = 1;
    protected int interpolation = 1;
    public static boolean defaultUseBlending = true;
    protected boolean useBlending = true;
    public static boolean defaultUseContentBased = false;
    protected boolean useContentBased = false;
    protected Map<ViewSetup, ViewSetup> newViewsetups = null;
    protected final List<ViewId> viewIdsToProcess;
    protected final List<TimePoint> timepointsToProcess;
    protected final List<Channel> channelsToProcess;
    protected final SpimData2 spimData;
    final int maxNumViews;
    protected final long avgPixels;

    public Fusion(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        this.spimData = spimData;
        this.viewIdsToProcess = viewIdsToProcess;
        if (viewIdsToProcess != null) {
            this.timepointsToProcess = SpimData2.getAllTimePointsSorted(spimData, viewIdsToProcess);
            this.channelsToProcess = SpimData2.getAllChannelsSorted(spimData, viewIdsToProcess);
            if (spimData == null) {
                this.avgPixels = 0L;
                this.maxNumViews = 0;
            } else {
                this.avgPixels = this.computeAvgImageSize();
                this.maxNumViews = this.computeMaxNumViews();
            }
        } else {
            this.timepointsToProcess = null;
            this.channelsToProcess = null;
            this.avgPixels = 0L;
            this.maxNumViews = 0;
        }
    }

    public abstract long totalRAM(long var1, int var3);

    public int getMaxNumViewsPerTimepoint() {
        return this.maxNumViews;
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    public abstract boolean fuseData(BoundingBoxGUI var1, ImgExport var2);

    public List<TimePoint> getTimepointsToProcess() {
        return this.timepointsToProcess;
    }

    public List<ViewSetup> getNewViewSetups() {
        ArrayList<ViewSetup> newSetups = new ArrayList<ViewSetup>();
        newSetups.addAll(new HashSet<ViewSetup>(this.newViewsetups.values()));
        Collections.sort(newSetups);
        return newSetups;
    }

    protected abstract Map<ViewSetup, ViewSetup> createNewViewSetups(BoundingBoxGUI var1);

    public void defineNewViewSetups(BoundingBoxGUI bb) {
        this.newViewsetups = this.createNewViewSetups(bb);
    }

    public abstract boolean supports16BitUnsigned();

    public abstract boolean supportsDownsampling();

    public abstract boolean compressBoundingBoxDialog();

    public abstract boolean queryParameters();

    public abstract void queryAdditionalParameters(GenericDialog var1);

    public void registerAdditionalListeners(BoundingBoxGUI.ManageListeners m) {
    }

    public abstract boolean parseAdditionalParameters(GenericDialog var1);

    public abstract Fusion newInstance(SpimData2 var1, List<ViewId> var2);

    public abstract String getDescription();

    protected long computeAvgImageSize() {
        long avgSize = 0L;
        int countImgs = 0;
        for (ViewId viewId : this.viewIdsToProcess) {
            ViewDescription desc = ((SequenceDescription)this.spimData.getSequenceDescription()).getViewDescription(viewId);
            if (!desc.isPresent()) continue;
            ViewSetup viewSetup = (ViewSetup)desc.getViewSetup();
            long numPixel = Intervals.numElements((Dimensions)ViewSetupUtils.getSizeOrLoad((BasicViewSetup)viewSetup, desc.getTimePoint(), (ImgLoader)((SequenceDescription)this.spimData.getSequenceDescription()).getImgLoader()));
            avgSize += numPixel;
            ++countImgs;
        }
        return avgSize / (long)countImgs;
    }

    protected int computeMaxNumViews() {
        int maxViews = 0;
        for (TimePoint t : this.timepointsToProcess) {
            for (Channel c : this.channelsToProcess) {
                int views = 0;
                for (ViewId viewId : this.viewIdsToProcess) {
                    ViewDescription vd = ((SequenceDescription)this.spimData.getSequenceDescription()).getViewDescription(viewId);
                    if (!vd.isPresent() || vd.getTimePointId() != t.getId() || ((ViewSetup)vd.getViewSetup()).getChannel().getId() != c.getId()) continue;
                    ++views;
                }
                maxViews = Math.max(maxViews, views);
            }
        }
        return maxViews;
    }
}

