/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer.interestpoint;

import bdv.viewer.OverlayRenderer;
import bdv.viewer.TransformListener;
import bdv.viewer.ViewerPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collection;
import net.imglib2.RealLocalizable;
import net.imglib2.realtransform.AffineTransform3D;

public class InterestPointOverlay
implements OverlayRenderer,
TransformListener<AffineTransform3D> {
    private final Collection<? extends InterestPointSource> interestPointSources;
    private final AffineTransform3D viewerTransform;
    private final ViewerPanel viewer;
    private Color col = Color.green.darker();

    public void setColor(Color col) {
        this.col = col;
    }

    private Color getColor(double[] gPos) {
        if (Math.abs(gPos[2]) < 3.0) {
            return Color.red;
        }
        int alpha = 255 - (int)Math.round(Math.abs(gPos[2]));
        if (alpha < 64) {
            alpha = 64;
        }
        return new Color(this.col.getRed(), this.col.getGreen(), this.col.getBlue(), alpha);
    }

    private double getPointSize(double[] gPos) {
        return 3.0;
    }

    public InterestPointOverlay(ViewerPanel viewer, Collection<? extends InterestPointSource> interestPointSources) {
        this.viewer = viewer;
        this.interestPointSources = interestPointSources;
        this.viewerTransform = new AffineTransform3D();
    }

    public void transformChanged(AffineTransform3D transform) {
        this.viewerTransform.set(transform);
    }

    public void drawOverlays(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        int t = this.viewer.getState().getCurrentTimepoint();
        double[] lPos = new double[3];
        double[] gPos = new double[3];
        AffineTransform3D transform = new AffineTransform3D();
        for (InterestPointSource interestPointSource : this.interestPointSources) {
            interestPointSource.getLocalToGlobalTransform(t, transform);
            transform.preConcatenate(this.viewerTransform);
            for (RealLocalizable realLocalizable : interestPointSource.getLocalCoordinates(t)) {
                realLocalizable.localize(lPos);
                transform.apply(lPos, gPos);
                double size = this.getPointSize(gPos);
                int x = (int)(gPos[0] - 0.5 * size);
                int y = (int)(gPos[1] - 0.5 * size);
                int w = (int)size;
                graphics.setColor(this.getColor(gPos));
                graphics.fillOval(x, y, w, w);
            }
        }
    }

    public void setCanvasSize(int width, int height) {
    }

    public static interface InterestPointSource {
        public Collection<? extends RealLocalizable> getLocalCoordinates(int var1);

        public void getLocalToGlobalTransform(int var1, AffineTransform3D var2);
    }
}

